/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.Device;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardDevicesTreeBuilder;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/Qemu;", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "<init>", "()V", "getDisplayName", "", "getDefaultServerExecutableName", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "gatherData", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "generateConnectionString", "port", "", "getResetCommand", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nQemu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Qemu.kt\ncom/intellij/clion/embedded/execution/wizard/Qemu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n774#2:46\n865#2,2:47\n1869#2,2:49\n*S KotlinDebug\n*F\n+ 1 Qemu.kt\ncom/intellij/clion/embedded/execution/wizard/Qemu\n*L\n30#1:46\n30#1:47,2\n32#1:49,2\n*E\n"})
public final class Qemu
extends GdbServer {
    public Qemu() {
        super(GdbServerType.QEMU);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = EmbeddedBundle.message("qemu.displayname", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDefaultServerExecutableName() {
        return SystemInfo.isWindows ? "qemu-system-arm.exe" : "qemu-system-arm";
    }

    @Override
    @NotNull
    public DialogPanel getDialogPanel(@NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        return BuilderKt.panel(arg_0 -> Qemu.getDialogPanel$lambda$1(this, wizard, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void gatherData(@NotNull Project project, @NotNull GdbWizardOptions state) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String executable = this.getGdbserverLocation(state);
        String[] stringArray = new String[]{executable, "-M", "help"};
        ProcessOutput output = this.gatherProcessOutput(false, stringArray);
        GdbWizardDevicesTreeBuilder builder = new GdbWizardDevicesTreeBuilder();
        Regex wsRegex = new Regex("\\s+");
        String string = output.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        Object object = new String[]{"\n"};
        object = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = CollectionsKt.drop((Iterable)((List)destination$iv$iv), (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)line)).toString();
            int n = 2;
            List parts = wsRegex.split(charSequence, n);
            builder.addNode(new Device((String)CollectionsKt.first((List)parts), null, null, null, (String)CollectionsKt.last((List)parts), 14, null));
        }
        state.setDevicesTree(this.validateNonEmptyTree(builder.build()));
    }

    @Override
    @NotNull
    public String generateConnectionString(@NotNull GdbWizardOptions state, int port) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return " -machine " + this.selectedDeviceKey(state) + " -gdb tcp::" + port + " -S -nographic";
    }

    @Override
    @NotNull
    public String getResetCommand() {
        return "monitor system_reset";
    }

    private static final Unit getDialogPanel$lambda$1$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    private static final Unit getDialogPanel$lambda$1(Qemu this$0, GdbServerWizard $wizard, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = EmbeddedBundle.message("label.qemu", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, Qemu::getDialogPanel$lambda$1$lambda$0);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        this$0.devicesListRows($this$panel, $wizard);
        return Unit.INSTANCE;
    }
}

