/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.stm32cubemx;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.EmbeddedSettingsState;
import com.intellij.clion.embedded.execution.ui.EmbeddedMessages;
import com.intellij.clion.embedded.stm32cubemx.CubeMXFileType;
import com.intellij.clion.embedded.stm32cubemx.CubeMXManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunStm32CubeMXAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(RunStm32CubeMXAction.class);
    private static final Key<OSProcessHandler> IOC_EDITOR_PROCESS = new Key("IOC_EDITOR_PROCESS");

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(1);
        }
        VirtualFile file = RunStm32CubeMXAction.getIocFile(e);
        e.getPresentation().setVisible(file != null);
        e.getPresentation().setEnabled(RunStm32CubeMXAction.isEnabledForFile(file));
    }

    public static boolean isEnabledForFile(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        OSProcessHandler handler = (OSProcessHandler)IOC_EDITOR_PROCESS.get((UserDataHolder)file);
        return handler == null || handler.isProcessTerminated();
    }

    @ApiStatus.Internal
    public static void initializeFile(final @NotNull VirtualFile file, @NotNull OSProcessHandler handler, final @Nullable Project project) {
        if (file == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(2);
        }
        if (handler == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(3);
        }
        IOC_EDITOR_PROCESS.set((UserDataHolder)file, (Object)handler);
        if (project != null) {
            ((CubeMXManager)project.getService(CubeMXManager.class)).cubeUtilityStatus(true);
        }
        handler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project != null) {
                    ((CubeMXManager)project.getService(CubeMXManager.class)).cubeUtilityStatus(false);
                }
                IOC_EDITOR_PROCESS.set((UserDataHolder)file, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/clion/embedded/stm32cubemx/RunStm32CubeMXAction$1", "processTerminated"));
            }
        });
    }

    @Nullable
    private static VirtualFile getIocFile(@NotNull AnActionEvent e) {
        VirtualFile file;
        if (e == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(4);
        }
        if ((file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)CubeMXFileType.INSTANCE)) {
            return file;
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(5);
        }
        RunStm32CubeMXAction.openFile(e.getProject(), RunStm32CubeMXAction.getIocFile(e));
    }

    public static void openFile(final @Nullable Project project, final @Nullable VirtualFile file) {
        if (RunStm32CubeMXAction.isEnabledForFile(file)) {
            GeneralCommandLine commandLine = RunStm32CubeMXAction.createCommandLine(file);
            try {
                OSProcessHandler.Silent handler = new OSProcessHandler.Silent(commandLine){

                    protected void onOSProcessTerminated(int exitCode) {
                        super.onOSProcessTerminated(exitCode);
                        if (project != null) {
                            ((CubeMXManager)project.getService(CubeMXManager.class)).cubeUtilityStatus(false);
                        }
                        IOC_EDITOR_PROCESS.set((UserDataHolder)file, null);
                    }
                };
                if (project != null) {
                    ((CubeMXManager)project.getService(CubeMXManager.class)).cubeUtilityStatus(true);
                }
                handler.startNotify();
                IOC_EDITOR_PROCESS.set((UserDataHolder)file, (Object)handler);
            }
            catch (Throwable e) {
                EmbeddedMessages.showErrorMessage(project, e.getLocalizedMessage(), EmbeddedBundle.message("stm32cubemx", new Object[0]));
            }
        }
    }

    @Nullable
    public static GeneralCommandLine createJavaCommandLine(@Nullable VirtualFile file) {
        EmbeddedSettingsState state = EmbeddedSettingsState.getInstance();
        String cubeLocation = state.stm32CubeMXLocation;
        File cubeMXExecutable = new File(cubeLocation);
        if (!cubeMXExecutable.exists()) {
            EmbeddedMessages.showErrorMessage(null, EmbeddedBundle.message("stm32.cube.mx.project.generation.failure", new Object[0]), EmbeddedBundle.message("stm32.cube.mx.is.not.found", new Object[0]));
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(RunStm32CubeMXAction.retrieveJavaExecutablePath(cubeMXExecutable)).withParameters(new String[]{"-jar", cubeLocation});
        if (file != null) {
            commandLine.withWorkDirectory(RunStm32CubeMXAction.platformSpecificPath(file.getParent()));
            commandLine.withParameters(new String[]{RunStm32CubeMXAction.platformSpecificPath(file)});
        }
        return commandLine;
    }

    @NotNull
    private static String retrieveJavaExecutablePath(@NotNull File cubeMXExecutable) {
        String javaPath;
        if (cubeMXExecutable == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(6);
        }
        if (!new File(javaPath = cubeMXExecutable.getParent() + (SystemInfo.isWindows ? "\\jre\\bin\\java.exe" : (SystemInfo.isMac ? "/jre/Contents/Home/bin/java" : "/jre/bin/java"))).exists()) {
            LOG.warn("STM32CubeMX bundled JRE is not found, defaulting to JBR");
            javaPath = SystemProperties.getJavaHome() + (SystemInfo.isWindows ? "\\bin\\java.exe" : "/bin/java");
        }
        String string = javaPath;
        if (string == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull VirtualFile file) {
        if (file == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(8);
        }
        EmbeddedSettingsState state = EmbeddedSettingsState.getInstance();
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withWorkDirectory(RunStm32CubeMXAction.platformSpecificPath(file.getParent())).withExePath(state.stm32CubeMXLocation).withParameters(new String[]{RunStm32CubeMXAction.platformSpecificPath(file)});
        if (generalCommandLine == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(9);
        }
        return generalCommandLine;
    }

    @NotNull
    private static String platformSpecificPath(@NotNull VirtualFile file) {
        if (file == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(10);
        }
        String string = VfsUtilCore.virtualToIoFile((VirtualFile)file).getAbsolutePath();
        if (string == null) {
            RunStm32CubeMXAction.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/stm32cubemx/RunStm32CubeMXAction";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cubeMXExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/stm32cubemx/RunStm32CubeMXAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveJavaExecutablePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "platformSpecificPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initializeFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIocFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "retrieveJavaExecutablePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "platformSpecificPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 10 -> new IllegalArgumentException(string);
        };
    }
}

