/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.project.resolver;

import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.external.system.ExternalBundle;
import com.jetbrains.cidr.meson.MesonWorkspace;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.project.resolver.MesonEnvironmentProblemException;
import com.jetbrains.cidr.meson.project.resolver.MesonRemoteUtil;
import com.jetbrains.cidr.meson.project.resolver.MesonResolverContext;
import com.jetbrains.cidr.meson.project.resolver.MesonResolverStep;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0094@\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/MesonResolverPreparationStep;", "Lcom/jetbrains/cidr/meson/project/resolver/MesonResolverStep;", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "displayName", "getDisplayName", "doExecute", "resolverContext", "Lcom/jetbrains/cidr/meson/project/resolver/MesonResolverContext;", "(Lcom/jetbrains/cidr/meson/project/resolver/MesonResolverContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonResolverPreparationStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonResolverPreparationStep.kt\ncom/jetbrains/cidr/meson/project/resolver/MesonResolverPreparationStep\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class MesonResolverPreparationStep
extends MesonResolverStep<CPPEnvironment> {
    @NotNull
    private final String name;
    @NotNull
    private final String displayName = MesonBundle.message("resolver.preparation.step.display.name", new Object[0]);

    public MesonResolverPreparationStep() {
        this.name = "prepare";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    protected Object doExecute(@NotNull MesonResolverContext resolverContext, @NotNull Continuation<? super CPPEnvironment> $completion) {
        MesonResolverContext $this$doExecute_u24lambda_u242 = resolverContext;
        boolean bl = false;
        Path projectDir = Files.isDirectory($this$doExecute_u24lambda_u242.getProjectPath(), new LinkOption[0]) ? $this$doExecute_u24lambda_u242.getProjectPath() : $this$doExecute_u24lambda_u242.getProjectPath().getParent();
        if (!(projectDir != null)) {
            boolean $i$a$-require-MesonResolverPreparationStep$doExecute$2$32 = false;
            Object[] objectArray = new Object[]{$this$doExecute_u24lambda_u242.getProjectPath()};
            String string = ExternalBundle.message((String)"project.path.invalid.message", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String $i$a$-require-MesonResolverPreparationStep$doExecute$2$32 = string;
            throw new IllegalArgumentException($i$a$-require-MesonResolverPreparationStep$doExecute$2$32.toString());
        }
        Path mesonPath = projectDir.resolve("meson.build");
        Intrinsics.checkNotNull((Object)mesonPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(mesonPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean $i$a$-require-MesonResolverPreparationStep$doExecute$2$42 = false;
            Object[] objectArray = new Object[]{projectDir};
            String $i$a$-require-MesonResolverPreparationStep$doExecute$2$42 = MesonBundle.message("resolver.meson.file.not.found.message", objectArray);
            throw new IllegalArgumentException($i$a$-require-MesonResolverPreparationStep$doExecute$2$42.toString());
        }
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment environment = MesonWorkspace.Companion.getInstance($this$doExecute_u24lambda_u242.getProject()).createEnvironment($this$doExecute_u24lambda_u242.getProject(), $this$doExecute_u24lambda_u242.getProjectSettings().profile().getToolchainName(), environmentProblems, false, null);
        if (environment == null) {
            throw new MesonEnvironmentProblemException(environmentProblems);
        }
        if (MesonRemoteUtil.isSyncNeeded(environment)) {
            MesonRemoteUtil.syncProjectToRemote($this$doExecute_u24lambda_u242.getProject(), projectDir, environment);
        }
        return environment;
    }
}

