/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.project.resolver.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.project.resolver.MesonModelException;
import com.jetbrains.cidr.meson.project.resolver.model.MesonInfo;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroCompilers;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntroTargets;
import com.jetbrains.cidr.meson.project.resolver.model.MesonIntrospectionKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntrospection;", "", "directory", "Ljava/nio/file/Path;", "info", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonInfo;", "targets", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroTargets;", "compilers", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroCompilers;", "<init>", "(Ljava/nio/file/Path;Lcom/jetbrains/cidr/meson/project/resolver/model/MesonInfo;Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroTargets;Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroCompilers;)V", "getDirectory", "()Ljava/nio/file/Path;", "getInfo", "()Lcom/jetbrains/cidr/meson/project/resolver/model/MesonInfo;", "getTargets", "()Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroTargets;", "getCompilers", "()Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntroCompilers;", "Companion", "intellij.clion.meson"})
public final class MesonIntrospection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path directory;
    @NotNull
    private final MesonInfo info;
    @NotNull
    private final MesonIntroTargets targets;
    @Nullable
    private final MesonIntroCompilers compilers;

    public MesonIntrospection(@NotNull Path directory, @NotNull MesonInfo info, @NotNull MesonIntroTargets targets, @Nullable MesonIntroCompilers compilers) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        this.directory = directory;
        this.info = info;
        this.targets = targets;
        this.compilers = compilers;
    }

    @NotNull
    public final Path getDirectory() {
        return this.directory;
    }

    @NotNull
    public final MesonInfo getInfo() {
        return this.info;
    }

    @NotNull
    public final MesonIntroTargets getTargets() {
        return this.targets;
    }

    @Nullable
    public final MesonIntroCompilers getCompilers() {
        return this.compilers;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntrospection$Companion;", "", "<init>", "()V", "parse", "Lcom/jetbrains/cidr/meson/project/resolver/model/MesonIntrospection;", "directory", "Ljava/nio/file/Path;", "intellij.clion.meson"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MesonIntrospection parse(@NotNull Path directory) throws MesonModelException {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            try {
                MesonIntrospectionKt.access$checkIntrospectionVersion(directory);
                MesonInfo mesonInfo = MesonIntrospectionKt.access$parseMesonInfo(directory);
                MesonIntroTargets mesonTargets = MesonIntrospectionKt.access$parseMesonTargets(directory, mesonInfo);
                MesonIntroCompilers mesonCompilers = MesonIntrospectionKt.access$parseMesonCompilers(directory, mesonInfo);
                return new MesonIntrospection(directory, mesonInfo, mesonTargets, mesonCompilers);
            }
            catch (JsonMappingException ex) {
                MesonIntrospectionKt.access$getLOG$p().error((Throwable)ex);
                throw new MesonModelException(MesonBundle.message("model.generic.error", new Object[0]), null, 2, null);
            }
            catch (JsonProcessingException ex) {
                MesonIntrospectionKt.access$getLOG$p().error((Throwable)ex);
                throw new MesonModelException(MesonBundle.message("model.generic.error", new Object[0]), null, 2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

