/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.ui.projectStatus;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.external.system.project.ui.ExternalProjectStatusAndFixesProviderBase;
import com.jetbrains.cidr.cpp.external.system.project.ui.SelectAndLoadProjectActionBase;
import com.jetbrains.cidr.meson.MesonUtil;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.project.ui.popup.ProjectFixWrappingActionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/meson/ui/projectStatus/MesonProjectStatusAndFixesProvider;", "Lcom/jetbrains/cidr/cpp/external/system/project/ui/ExternalProjectStatusAndFixesProviderBase;", "<init>", "()V", "isBuildFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createLoadAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "createSelectAndLoadAction", "rootDirectory", "LoadMesonAction", "SelectAndLoadMesonAction", "intellij.clion.meson"})
public final class MesonProjectStatusAndFixesProvider
extends ExternalProjectStatusAndFixesProviderBase {
    public boolean isBuildFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return MesonUtil.INSTANCE.isMesonFile(file);
    }

    @NotNull
    public AnAction createLoadAction(@NotNull Project project, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return ProjectFixWrappingActionKt.asProjectFixAction$default((AnAction)new LoadMesonAction(project, buildFile), (String)"meson.load.project", null, (int)2, null);
    }

    @NotNull
    public AnAction createSelectAndLoadAction(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
        return ProjectFixWrappingActionKt.asProjectFixAction$default((AnAction)((AnAction)new SelectAndLoadMesonAction(project, rootDirectory)), (String)"meson.select.and.load.project", null, (int)2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/meson/ui/projectStatus/MesonProjectStatusAndFixesProvider$LoadMesonAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "mesonFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clion.meson"})
    private static final class LoadMesonAction
    extends AnAction {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile mesonFile;

        public LoadMesonAction(@NotNull Project project, @NotNull VirtualFile mesonFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)mesonFile, (String)"mesonFile");
            super(MesonBundle.message("action.Meson.LoadMesonProject.text", new Object[0]));
            this.project = project;
            this.mesonFile = mesonFile;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VirtualFile virtualFile = this.mesonFile.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            MesonUtil.INSTANCE.linkMesonProject(this.project, virtualFile);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/meson/ui/projectStatus/MesonProjectStatusAndFixesProvider$SelectAndLoadMesonAction;", "Lcom/jetbrains/cidr/cpp/external/system/project/ui/SelectAndLoadProjectActionBase;", "project", "Lcom/intellij/openapi/project/Project;", "rootDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "isBuildFile", "", "file", "linkProject", "", "intellij.clion.meson"})
    private static final class SelectAndLoadMesonAction
    extends SelectAndLoadProjectActionBase {
        public SelectAndLoadMesonAction(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
            super(project, rootDirectory, MesonBundle.message("project.status.action.select", new Object[0]));
        }

        public boolean isBuildFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return MesonUtil.INSTANCE.isMesonFile(file);
        }

        public void linkProject(@NotNull Project project, @NotNull VirtualFile rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)rootDirectory, (String)"rootDirectory");
            MesonUtil.INSTANCE.linkMesonProject(project, rootDirectory);
        }
    }
}

