/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.highlighting;

import com.intellij.dts.highlighting.DtsTextAttributes;
import com.intellij.dts.lang.DtsTokenSets;
import com.intellij.dts.lang.lexer.DtsHighlightingLexerAdapter;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J'\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0007\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dts/highlighting/DtsSyntaxHighlighter;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterBase;", "<init>", "()V", "getHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "pack", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "attr", "Lcom/intellij/dts/highlighting/DtsTextAttributes;", "([Lcom/intellij/dts/highlighting/DtsTextAttributes;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getTokenHighlights", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Factory", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsSyntaxHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsSyntaxHighlighter.kt\ncom/intellij/dts/highlighting/DtsSyntaxHighlighter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,48:1\n11228#2:49\n11563#2,3:50\n37#3:53\n36#3,3:54\n*S KotlinDebug\n*F\n+ 1 DtsSyntaxHighlighter.kt\ncom/intellij/dts/highlighting/DtsSyntaxHighlighter\n*L\n26#1:49\n26#1:50,3\n26#1:53\n26#1:54,3\n*E\n"})
public final class DtsSyntaxHighlighter
extends SyntaxHighlighterBase {
    @NotNull
    public Lexer getHighlightingLexer() {
        return (Lexer)new DtsHighlightingLexerAdapter();
    }

    /*
     * WARNING - void declaration
     */
    private final TextAttributesKey[] pack(DtsTextAttributes ... attr) {
        void $this$mapTo$iv$iv;
        DtsTextAttributes[] $this$map$iv = attr;
        boolean $i$f$map = false;
        DtsTextAttributes[] dtsTextAttributesArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAttribute());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TextAttributesKey[0]);
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@NotNull IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray;
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        if (DtsTokenSets.INSTANCE.getComments().contains(tokenType)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.COMMENT};
            return this.pack(dtsTextAttributesArray);
        }
        if (DtsTokenSets.INSTANCE.getStrings().contains(tokenType)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.STRING};
            return this.pack(dtsTextAttributesArray);
        }
        if (DtsTokenSets.INSTANCE.getNumbers().contains(tokenType)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.NUMBER};
            return this.pack(dtsTextAttributesArray);
        }
        if (DtsTokenSets.INSTANCE.getOperators().contains(tokenType)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.OPERATOR};
            return this.pack(dtsTextAttributesArray);
        }
        if (DtsTokenSets.INSTANCE.getCompilerDirectives().contains(tokenType)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.COMPILER_DIRECTIVE};
            return this.pack(dtsTextAttributesArray);
        }
        if (DtsTokenSets.INSTANCE.getIncludePath().contains(tokenType)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.INCLUDE_PATH};
            return this.pack(dtsTextAttributesArray);
        }
        IElementType iElementType = tokenType;
        if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.LBRACE) || Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.RBRACE)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.BRACES};
            textAttributesKeyArray = this.pack(dtsTextAttributesArray);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.LBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.RBRACKET) || Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.LANGL) || Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.RANGL)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.BRACKETS};
            textAttributesKeyArray = this.pack(dtsTextAttributesArray);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.SEMICOLON)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.SEMICOLON};
            textAttributesKeyArray = this.pack(dtsTextAttributesArray);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.COMMA)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.COMMA};
            textAttributesKeyArray = this.pack(dtsTextAttributesArray);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.PP_INACTIVE)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.INACTIVE};
            textAttributesKeyArray = this.pack(dtsTextAttributesArray);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)TokenType.BAD_CHARACTER)) {
            DtsTextAttributes[] dtsTextAttributesArray = new DtsTextAttributes[]{DtsTextAttributes.BAD_CHARACTER};
            textAttributesKeyArray = this.pack(dtsTextAttributesArray);
        } else {
            TextAttributesKey[] textAttributesKeyArray2 = SyntaxHighlighterBase.pack(null);
            textAttributesKeyArray = textAttributesKeyArray2;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray2, (String)"pack(...)");
        }
        return textAttributesKeyArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/dts/highlighting/DtsSyntaxHighlighter$Factory;", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighterFactory;", "<init>", "()V", "getSyntaxHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.dts"})
    public static final class Factory
    extends SyntaxHighlighterFactory {
        @NotNull
        public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
            return (SyntaxHighlighter)new DtsSyntaxHighlighter();
        }
    }
}

