/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.lang.resolve.files;

import com.intellij.dts.lang.psi.FileInclude;
import com.intellij.dts.zephyr.DtsZephyrFileUtil;
import com.intellij.dts.zephyr.DtsZephyrProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dts/lang/resolve/files/DtsIncludeFile;", "Lcom/intellij/dts/lang/psi/FileInclude;", "path", "", "offset", "", "<init>", "(Ljava/lang/String;I)V", "getPath", "()Ljava/lang/String;", "getOffset", "()Ljava/lang/Integer;", "findRelativeFile", "Lcom/intellij/psi/PsiFile;", "anchor", "findInIncludeDirs", "resolve", "intellij.dts"})
public final class DtsIncludeFile
implements FileInclude {
    @NotNull
    private final String path;
    private final int offset;

    public DtsIncludeFile(@NotNull String path, int offset) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
        this.offset = offset;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Integer getOffset() {
        return this.offset;
    }

    private final PsiFile findRelativeFile(PsiFile anchor) {
        VirtualFile context;
        VirtualFile virtualFile = context = anchor.getOriginalFile().getVirtualFile();
        if (!(virtualFile != null ? virtualFile.isValid() : false)) {
            return null;
        }
        VirtualFile virtualFile2 = context.getParent();
        if (virtualFile2 == null || (virtualFile2 = virtualFile2.findFileByRelativePath(this.path)) == null) {
            return null;
        }
        VirtualFile file = virtualFile2;
        return anchor.getManager().findFile(file);
    }

    private final PsiFile findInIncludeDirs(PsiFile anchor) {
        Project project = anchor.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DtsZephyrProvider provider = DtsZephyrProvider.Companion.of(project);
        List<VirtualFile> includes2 = DtsZephyrFileUtil.INSTANCE.getIncludeDirs(provider.getRoot(), provider.getBoard());
        PsiManager manager = anchor.getManager();
        for (VirtualFile include : includes2) {
            VirtualFile file;
            if (include.findFileByRelativePath(this.path) == null) continue;
            PsiFile psiFile = manager.findFile(file);
            if (psiFile == null) continue;
            return psiFile;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiFile resolve(@NotNull PsiFile anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        PsiFile psiFile = this.findRelativeFile(anchor);
        if (psiFile == null) {
            psiFile = this.findInIncludeDirs(anchor);
        }
        return psiFile;
    }
}

