/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.pp.lang.lexer;

import com.intellij.dts.pp.lang.PpTokenTypes;
import com.intellij.dts.pp.lang.lexer.PpLexerAdapterBase;
import com.intellij.dts.pp.lang.psi.PpElifStatement;
import com.intellij.dts.pp.lang.psi.PpIfStatement;
import com.intellij.dts.pp.lang.psi.PpStatement;
import com.intellij.dts.pp.lang.psi.PpStatementType;
import com.intellij.dts.pp.lang.psi.PpToken;
import com.intellij.lexer.Lexer;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/dts/pp/lang/lexer/PpHighlightingLexerAdapter;", "Lcom/intellij/dts/pp/lang/lexer/PpLexerAdapterBase;", "tokenTypes", "Lcom/intellij/dts/pp/lang/PpTokenTypes;", "baseLexer", "Lcom/intellij/lexer/Lexer;", "<init>", "(Lcom/intellij/dts/pp/lang/PpTokenTypes;Lcom/intellij/lexer/Lexer;)V", "stateStack", "Ljava/util/Stack;", "", "start", "", "buffer", "", "startOffset", "endOffset", "initialState", "getState", "storeState", "applyState", "popState", "processMarker", "intellij.dts.pp"})
public class PpHighlightingLexerAdapter
extends PpLexerAdapterBase {
    @NotNull
    private final Stack<Integer> stateStack;

    public PpHighlightingLexerAdapter(@NotNull PpTokenTypes tokenTypes, @NotNull Lexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)tokenTypes, (String)"tokenTypes");
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        super(tokenTypes, baseLexer);
        this.stateStack = new Stack();
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.stateStack.clear();
        super.start(buffer, startOffset, endOffset, initialState);
    }

    public int getState() {
        return super.getState() + this.stateStack.size();
    }

    private final void storeState(Lexer baseLexer) {
        this.stateStack.push(baseLexer.getState());
    }

    private final void applyState(Lexer baseLexer) {
        if (this.stateStack.empty()) {
            return;
        }
        Integer n = this.stateStack.peek();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"peek(...)");
        this.restoreState(baseLexer, ((Number)n).intValue());
    }

    private final void popState(Lexer baseLexer) {
        if (this.stateStack.empty()) {
            return;
        }
        Integer n = this.stateStack.pop();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"pop(...)");
        this.restoreState(baseLexer, ((Number)n).intValue());
    }

    @Override
    protected void processMarker(@NotNull Lexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        List<PpToken> tokens = this.tokenizeStatement(baseLexer);
        this.addStatementsTokens(baseLexer.getTokenStart(), tokens);
        PpStatement statement = this.parseStatement(tokens);
        if (statement instanceof PpIfStatement) {
            this.storeState(baseLexer);
        } else if (statement instanceof PpElifStatement) {
            this.applyState(baseLexer);
        } else if (statement.getType() == PpStatementType.Endif) {
            this.popState(baseLexer);
        }
        baseLexer.advance();
    }
}

