/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.pp.lang.lexer;

import com.intellij.dts.pp.lang.PpTokenTypes;
import com.intellij.dts.pp.lang.lexer.IfState;
import com.intellij.dts.pp.lang.lexer.PpLexerAdapterBase;
import com.intellij.dts.pp.lang.psi.PpElifStatement;
import com.intellij.dts.pp.lang.psi.PpIfStatement;
import com.intellij.dts.pp.lang.psi.PpStatement;
import com.intellij.dts.pp.lang.psi.PpStatementKt;
import com.intellij.dts.pp.lang.psi.PpStatementType;
import com.intellij.dts.pp.lang.psi.PpToken;
import com.intellij.lexer.Lexer;
import com.intellij.psi.TokenType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/dts/pp/lang/lexer/PpParserLexerAdapter;", "Lcom/intellij/dts/pp/lang/lexer/PpLexerAdapterBase;", "tokenTypes", "Lcom/intellij/dts/pp/lang/PpTokenTypes;", "baseLexer", "Lcom/intellij/lexer/Lexer;", "<init>", "(Lcom/intellij/dts/pp/lang/PpTokenTypes;Lcom/intellij/lexer/Lexer;)V", "defines", "", "", "ifState", "Lcom/intellij/dts/pp/lang/lexer/IfState;", "start", "", "buffer", "", "startOffset", "", "endOffset", "initialState", "processMarker", "addInactiveSection", "processInactiveSection", "intellij.dts.pp"})
@SourceDebugExtension(value={"SMAP\nPpParserLexerAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PpParserLexerAdapter.kt\ncom/intellij/dts/pp/lang/lexer/PpParserLexerAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public class PpParserLexerAdapter
extends PpLexerAdapterBase {
    @NotNull
    private final List<String> defines;
    @NotNull
    private final IfState ifState;

    public PpParserLexerAdapter(@NotNull PpTokenTypes tokenTypes, @NotNull Lexer baseLexer) {
        Intrinsics.checkNotNullParameter((Object)tokenTypes, (String)"tokenTypes");
        Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
        super(tokenTypes, baseLexer);
        this.defines = new ArrayList();
        this.ifState = new IfState();
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        boolean bl2 = bl = startOffset == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        super.start(buffer, startOffset, endOffset, initialState);
    }

    @Override
    protected void processMarker(@NotNull Lexer baseLexer) {
        block2: {
            PpStatement statement;
            block5: {
                block4: {
                    block3: {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)baseLexer, (String)"baseLexer");
                            List<PpToken> tokens = this.tokenizeStatement(baseLexer);
                            this.addStatementsTokens(baseLexer.getTokenStart(), tokens);
                            baseLexer.advance();
                            statement = this.parseStatement(tokens);
                            if (!(statement instanceof PpIfStatement) || this.ifState.beginIf(((PpIfStatement)statement).evaluate(this.defines))) break block1;
                            this.processInactiveSection(baseLexer);
                            break block2;
                        }
                        if (!(statement instanceof PpElifStatement) || this.ifState.elseIf(((PpElifStatement)statement).evaluate(this.defines))) break block3;
                        this.processInactiveSection(baseLexer);
                        break block2;
                    }
                    if (statement.getType() != PpStatementType.Endif) break block4;
                    this.ifState.endIf();
                    break block2;
                }
                if (statement.getType() != PpStatementType.Define) break block5;
                PpToken ppToken = PpStatementKt.getIdentifier(statement);
                if (ppToken == null) break block2;
                PpToken it = ppToken;
                boolean bl = false;
                this.defines.add(((Object)it.getText()).toString());
                break block2;
            }
            if (statement.getType() != PpStatementType.Undef) break block2;
            PpToken ppToken = PpStatementKt.getIdentifier(statement);
            if (ppToken != null) {
                PpToken it = ppToken;
                boolean bl = false;
                this.defines.remove(((Object)it.getText()).toString());
            }
        }
    }

    private final void addInactiveSection(Lexer baseLexer, int endOffset) {
        this.addToken(endOffset, this.getTokenTypes().getInactive());
        if (endOffset != baseLexer.getTokenStart()) {
            this.addToken(baseLexer.getTokenStart(), TokenType.WHITE_SPACE);
        }
    }

    private final void processInactiveSection(Lexer baseLexer) {
        int baseLexerState = baseLexer.getState();
        List<PpToken> tokens = null;
        int nestedIfs = 0;
        int inactiveEnd = baseLexer.getTokenEnd();
        while (true) {
            if (baseLexer.getTokenType() != null && !Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)this.getTokenTypes().getStatementMarker())) {
                if (!Intrinsics.areEqual((Object)baseLexer.getTokenType(), (Object)TokenType.WHITE_SPACE)) {
                    inactiveEnd = baseLexer.getTokenEnd();
                }
                baseLexer.advance();
                continue;
            }
            if (baseLexer.getTokenType() == null) {
                this.addInactiveSection(baseLexer, inactiveEnd);
                return;
            }
            tokens = this.tokenizeStatement(baseLexer);
            PpStatement statement = this.parseStatement(tokens);
            if (statement instanceof PpIfStatement) {
                ++nestedIfs;
            } else {
                if (nestedIfs == 0 && statement.getType() == PpStatementType.Endif) break;
                if (nestedIfs >= 1 && statement.getType() == PpStatementType.Endif) {
                    --nestedIfs;
                } else if (nestedIfs == 0 && statement instanceof PpElifStatement) {
                    this.addInactiveSection(baseLexer, inactiveEnd);
                    this.restoreState(baseLexer, baseLexerState);
                    return;
                }
            }
            inactiveEnd = baseLexer.getTokenEnd();
            baseLexer.advance();
        }
        this.addInactiveSection(baseLexer, inactiveEnd);
        this.addStatementsTokens(baseLexer.getTokenStart(), tokens);
        this.restoreState(baseLexer, baseLexerState);
        baseLexer.advance();
    }
}

