/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.settings;

import com.intellij.dts.DtsBundle;
import com.intellij.dts.util.Either;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0014\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0015J0\u0010\u0016\u001a\u001d\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u0019\u0012\u0004\u0012\u00028\u00010\u0017j\b\u0012\u0004\u0012\u00028\u0001`\u001a2\u0006\u0010\u001b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001cJ:\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00028\u00002!\u0010\u001e\u001a\u001d\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u0019\u0012\u0004\u0012\u00028\u00010\u0017j\b\u0012\u0004\u0012\u00028\u0001`\u001aH\u0014\u00a2\u0006\u0002\u0010\u001fJ0\u0010 \u001a\u001d\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u0019\u0012\u0004\u0012\u00028\u00010\u0017j\b\u0012\u0004\u0012\u00028\u0001`\u001a2\u0006\u0010\u001e\u001a\u00028\u0001H\u0004\u00a2\u0006\u0002\u0010\u001cJ:\u0010!\u001a\u001d\u0012\t\u0012\u00070\u0018\u00a2\u0006\u0002\b\u0019\u0012\u0004\u0012\u00028\u00010\u0017j\b\u0012\u0004\u0012\u00028\u0001`\u001a2\u0015\u0010\"\u001a\u00110\u0018\u00a2\u0006\f\b#\u0012\b\b$\u0012\u0004\b\b(%H\u0004J\b\u0010&\u001a\u00020'H\u0004J\u0006\u0010(\u001a\u00020\fJ\u0012\u0010)\u001a\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006/"}, d2={"Lcom/intellij/dts/settings/DtsSettingsInputStatus;", "State", "T", "", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "listeners", "", "Lkotlin/Function1;", "Lcom/intellij/openapi/ui/ValidationInfo;", "", "alarm", "Lcom/intellij/util/Alarm;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "readState", "()Ljava/lang/Object;", "performCheck", "Lcom/intellij/dts/util/Either;", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/dts/settings/Result;", "state", "(Ljava/lang/Object;)Lcom/intellij/dts/util/Either;", "evaluate", "result", "(Ljava/lang/Object;Lcom/intellij/dts/util/Either;)Lcom/intellij/openapi/ui/ValidationInfo;", "success", "error", "key", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.DtsBundle", "cancel", "", "check", "notify", "info", "installOn", "component", "Ljavax/swing/JComponent;", "enableAndCheck", "intellij.dts"})
public abstract class DtsSettingsInputStatus<State, T> {
    @Nullable
    private final Disposable disposable;
    @NotNull
    private final List<Function1<ValidationInfo, Unit>> listeners;
    @NotNull
    private final Alarm alarm;
    private boolean isEnabled;

    public DtsSettingsInputStatus(@Nullable Disposable disposable) {
        this.disposable = disposable;
        this.listeners = new ArrayList();
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
        this.isEnabled = true;
    }

    protected final boolean isEnabled() {
        return this.isEnabled;
    }

    protected final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    protected abstract State readState();

    @NotNull
    protected abstract Either<String, T> performCheck(State var1);

    @Nullable
    protected ValidationInfo evaluate(State state, @NotNull Either<String, ? extends T> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return (ValidationInfo)result.fold(DtsSettingsInputStatus::evaluate$lambda$0, DtsSettingsInputStatus::evaluate$lambda$1);
    }

    @NotNull
    protected final Either<String, T> success(T result) {
        return new Either.Right<T>(result);
    }

    @NotNull
    protected final Either<String, T> error(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new Either.Left<String>(DtsBundle.Companion.message(key, new Object[0]));
    }

    @NotNull
    protected final Void cancel() {
        throw new CancellationException();
    }

    public final void check() {
        this.alarm.cancelAllRequests();
        State state = this.readState();
        this.alarm.addRequest(() -> DtsSettingsInputStatus.check$lambda$4(this, state), 300);
    }

    private final void notify(ValidationInfo info) {
        if (!this.isEnabled) {
            return;
        }
        for (Function1<ValidationInfo, Unit> listener2 : this.listeners) {
            listener2.invoke((Object)info);
        }
    }

    public final void installOn(@NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Disposable disposable = this.disposable;
        if (disposable == null) {
            return;
        }
        Disposable disposable2 = disposable;
        ComponentValidator validator = new ComponentValidator(disposable2).installOn(component);
        this.listeners.add((Function1<ValidationInfo, Unit>)((Function1)arg_0 -> DtsSettingsInputStatus.installOn$lambda$5(validator, component, arg_0)));
    }

    public final void enableAndCheck() {
        this.isEnabled = true;
        this.check();
    }

    private static final ValidationInfo evaluate$lambda$0(String left) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        return new ValidationInfo(left);
    }

    private static final ValidationInfo evaluate$lambda$1(Object it) {
        return null;
    }

    private static final void check$lambda$4$lambda$2(DtsSettingsInputStatus this$0) {
        this$0.notify(null);
    }

    private static final void check$lambda$4$lambda$3(DtsSettingsInputStatus this$0, Object $state, Either $result) {
        this$0.notify(this$0.evaluate($state, $result));
    }

    private static final void check$lambda$4(DtsSettingsInputStatus this$0, Object $state) {
        Either either;
        try {
            either = this$0.performCheck($state);
        }
        catch (CancellationException e) {
            UIUtil.invokeLaterIfNeeded(() -> DtsSettingsInputStatus.check$lambda$4$lambda$2(this$0));
            return;
        }
        Either result = either;
        UIUtil.invokeLaterIfNeeded(() -> DtsSettingsInputStatus.check$lambda$4$lambda$3(this$0, $state, result));
    }

    private static final Unit installOn$lambda$5(ComponentValidator $validator, JComponent $component, ValidationInfo info) {
        ValidationInfo validationInfo = info;
        $validator.updateInfo((ValidationInfo)(validationInfo != null ? validationInfo.forComponent($component) : null));
        return Unit.INSTANCE;
    }
}

