/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.zephyr.binding;

import com.intellij.codeWithMe.ClientId;
import com.intellij.dts.zephyr.binding.BindingSource;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrBindingLoaderKt;
import com.intellij.dts.zephyr.binding.DtsZephyrBindingParserKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\fH\u0087@\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\tR \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/dts/zephyr/binding/DtsZephyrBundledBindings;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "bindings", "Lkotlinx/coroutines/Deferred;", "", "", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBinding;", "awaitInit", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSource", "Lcom/intellij/dts/zephyr/binding/BindingSource;", "getBinding", "name", "Companion", "intellij.dts"})
public final class DtsZephyrBundledBindings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Deferred<? extends Map<String, DtsZephyrBinding>> bindings;
    @NotNull
    public static final String DEFAULT_BINDING = "default";
    @NotNull
    public static final String FALLBACK_BINDING = "fallback";
    @NotNull
    private static final List<String> NODE_BINDINGS;
    @NotNull
    private static final String BUNDLED_BINDINGS_PATH = "bindings";
    @NotNull
    private static final Logger logger;

    public DtsZephyrBundledBindings(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.bindings = BuildersKt.async$default((CoroutineScope)scope, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends DtsZephyrBinding>>, Object>(this, null){
            int label;
            final /* synthetic */ DtsZephyrBundledBindings this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object = this.this$0.getSource();
                        if (object != null) {
                            BindingSource p0 = object;
                            boolean bl = false;
                            Map<String, DtsZephyrBinding> map = DtsZephyrBindingParserKt.parseBundledBindings(p0);
                            object = map;
                            if (map != null) return object;
                        }
                        object = MapsKt.emptyMap();
                        return object;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, DtsZephyrBinding>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @TestOnly
    @Nullable
    public final Object awaitInit(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.bindings.join($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @RequiresBackgroundThread
    @Nullable
    public final BindingSource getSource() {
        ThreadingAssertions.assertBackgroundThread();
        ClassLoader classLoader = DtsZephyrBundledBindings.class.getClassLoader();
        URL url = classLoader.getResource(BUNDLED_BINDINGS_PATH);
        if (url == null) {
            logger.error("failed to load bundled bindings folder url");
            return null;
        }
        VirtualFile dir = VfsUtil.findFileByURL((URL)url);
        if (dir == null) {
            logger.error("failed to load bundled bindings folder");
            return null;
        }
        return new BindingSource(DtsZephyrBindingLoaderKt.loadBundledBindings(dir), null);
    }

    @Nullable
    public final DtsZephyrBinding getBinding(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.bindings.isCompleted()) {
            this.bindings.start();
            return null;
        }
        return (DtsZephyrBinding)((Map)this.bindings.getCompleted()).get(name);
    }

    @JvmStatic
    @NotNull
    public static final DtsZephyrBundledBindings getInstance() {
        return Companion.getInstance();
    }

    static {
        Object[] objectArray = new String[]{"aliases", "chosen", "cpus", "memory", "reserved-memory"};
        NODE_BINDINGS = CollectionsKt.listOf((Object[])objectArray);
        Logger logger = Logger.getInstance(DtsZephyrBundledBindings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DtsZephyrBundledBindings.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dts/zephyr/binding/DtsZephyrBundledBindings$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/dts/zephyr/binding/DtsZephyrBundledBindings;", "DEFAULT_BINDING", "", "FALLBACK_BINDING", "NODE_BINDINGS", "", "getNODE_BINDINGS", "()Ljava/util/List;", "BUNDLED_BINDINGS_PATH", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.dts"})
    @SourceDebugExtension(value={"SMAP\nDtsZephyrBundledBindings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsZephyrBundledBindings.kt\ncom/intellij/dts/zephyr/binding/DtsZephyrBundledBindings$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,67:1\n40#2,3:68\n*S KotlinDebug\n*F\n+ 1 DtsZephyrBundledBindings.kt\ncom/intellij/dts/zephyr/binding/DtsZephyrBundledBindings$Companion\n*L\n16#1:68,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DtsZephyrBundledBindings getInstance() {
            boolean $i$f$service = false;
            Class<DtsZephyrBundledBindings> serviceClass$iv = DtsZephyrBundledBindings.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DtsZephyrBundledBindings)object;
        }

        @NotNull
        public final List<String> getNODE_BINDINGS() {
            return NODE_BINDINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

