/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.styledComponents;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/styledComponents/StyledComponentsClassNamesReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "extractReferences", "", "text", "", "references", "", "offset", "", "intellij.styled.components"})
@SourceDebugExtension(value={"SMAP\nStyledComponentsReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyledComponentsReferenceContributor.kt\ncom/intellij/styledComponents/StyledComponentsClassNamesReferenceProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,67:1\n13472#2,2:68\n37#3:70\n36#3,3:71\n*S KotlinDebug\n*F\n+ 1 StyledComponentsReferenceContributor.kt\ncom/intellij/styledComponents/StyledComponentsClassNamesReferenceProvider\n*L\n45#1:68,2\n55#1:70\n55#1:71,3\n*E\n"})
final class StyledComponentsClassNamesReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(element instanceof JSLiteralExpression)) {
            return new PsiReference[0];
        }
        ArrayList references = new ArrayList();
        if (((JSLiteralExpression)element).getExpressionKind(false) == JSLiteralExpressionKind.TEMPLATE_WITH_ARGS) {
            JSStringTemplateExpression templateExpression = (JSStringTemplateExpression)element;
            String text = templateExpression.getText();
            TextRange[] textRangeArray = templateExpression.getStringRanges();
            Intrinsics.checkNotNullExpressionValue((Object)textRangeArray, (String)"getStringRanges(...)");
            Object[] $this$forEach$iv = textRangeArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TextRange it = (TextRange)element$iv;
                boolean bl = false;
                String string = it.substring(text);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.extractReferences(string, references, element, it.getStartOffset());
            }
        } else {
            String string = ((JSLiteralExpression)element).getStringValue();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.extractReferences(it, references, element, 1);
            }
        }
        Collection $this$toTypedArray$iv = references;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    public final void extractReferences(@NotNull String text, @NotNull List<PsiReference> references, @NotNull PsiElement element, int offset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(references, (String)"references");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        CssResolveUtil.consumeClassNames((String)text, (PsiElement)element, (arg_0, arg_1) -> StyledComponentsClassNamesReferenceProvider.extractReferences$lambda$3((arg_0, arg_1) -> StyledComponentsClassNamesReferenceProvider.extractReferences$lambda$2(references, offset, element, arg_0, arg_1), arg_0, arg_1));
    }

    private static final Unit extractReferences$lambda$2(List $references, int $offset, PsiElement $element, String string, TextRange range) {
        TextRange textRange = range.shiftRight($offset);
        $references.add(new CssClassOrIdReference($element, textRange){

            public boolean isId() {
                return false;
            }
        });
        return Unit.INSTANCE;
    }

    private static final void extractReferences$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

