/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLValueData {
    private static final Pattern HEX_VALUE_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)\\b");
    private static final String NIL_PATTERN_STRING = "0x0+";
    private static final Pattern NULL_POINTER_PATTERN = Pattern.compile("0x0+");
    @NotNull
    private final String myValue;
    @Nullable
    private final String myDescription;
    private final boolean myHasLongerDescription;
    private final boolean myMayHaveChildren;
    private final boolean myIsSynthetic;
    @Nullable
    @Nls
    private final String myWarning;
    private final boolean myIsRichDescription;

    public LLValueData(@NotNull String value, @Nullable String description, boolean hasLongerDescription, boolean mayHaveChildren, boolean isSynthetic) {
        if (value == null) {
            LLValueData.$$$reportNull$$$0(0);
        }
        this(value, description, hasLongerDescription, mayHaveChildren, isSynthetic, null, false);
    }

    @ApiStatus.Experimental
    public LLValueData(@NotNull String value, @Nullable String description, boolean hasLongerDescription, boolean mayHaveChildren, boolean isSynthetic, @Nullable @Nls String warning, boolean isRichDescription) {
        if (value == null) {
            LLValueData.$$$reportNull$$$0(1);
        }
        this.myValue = value;
        this.myDescription = description;
        this.myHasLongerDescription = hasLongerDescription;
        this.myMayHaveChildren = mayHaveChildren;
        this.myIsSynthetic = isSynthetic;
        this.myWarning = warning;
        this.myIsRichDescription = isRichDescription;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            LLValueData.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getDescription() {
        return this.myDescription;
    }

    public boolean hasLongerDescription() {
        return this.myHasLongerDescription;
    }

    @NotNull
    public String getPresentableValue() {
        String string = this.myDescription != null ? this.myDescription : this.myValue;
        if (string == null) {
            LLValueData.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean mayHaveChildren() {
        return this.myMayHaveChildren;
    }

    public boolean isSynthetic() {
        return this.myIsSynthetic;
    }

    public boolean isPointer() {
        return this.getPointerOrNull() != null;
    }

    public boolean isValidPointer() {
        String pointer = this.getPointerOrNull();
        return pointer != null && !NULL_POINTER_PATTERN.matcher(pointer).matches();
    }

    public boolean isNullPointer() {
        return LLValueData.isNullPointer(this.getPointerOrNull());
    }

    private static boolean isNullPointer(@Nullable String pointer) {
        return pointer != null && NULL_POINTER_PATTERN.matcher(pointer).matches();
    }

    @NotNull
    public String getPointer() throws DebuggerCommandException {
        String result = this.getPointerOrNull();
        if (result == null) {
            throw new DebuggerCommandException("Value is not a valid pointer: " + this.myValue);
        }
        String string = result;
        if (string == null) {
            LLValueData.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getPointerOrNull() {
        return LLValueData.getPointer(this.myValue);
    }

    @Nullable
    public static String getPointer(@Nullable String value) {
        if (value == null) {
            return null;
        }
        List matches = StringUtil.findMatches((String)value, (Pattern)HEX_VALUE_PATTERN);
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        return null;
    }

    @Nullable
    public String getPresentablePointer() {
        String pointer = this.getPointerOrNull();
        if (pointer == null) {
            return null;
        }
        return LLValueData.getPresentablePointer(pointer);
    }

    @NotNull
    public static String getPresentablePointer(@NotNull String pointer) {
        int i;
        if (pointer == null) {
            LLValueData.$$$reportNull$$$0(5);
        }
        if (LLValueData.isNullPointer((String)pointer)) {
            return "0x0";
        }
        for (i = 2; i < ((String)pointer).length() && ((String)pointer).charAt(i) == '0'; ++i) {
        }
        if (i > 2) {
            pointer = "0x" + ((String)pointer).substring(i);
        }
        String string = pointer;
        if (string == null) {
            LLValueData.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Address getPointerAddress() {
        String pointer = this.getPointerOrNull();
        if (pointer == null) {
            return null;
        }
        if (LLValueData.isNullPointer(pointer)) {
            return Address.NULL;
        }
        try {
            return Address.parseHexString(pointer);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @NotNull
    public Pair<String, String> splitNumberAndData() {
        String description = this.myDescription != null ? this.myDescription : this.myValue;
        int spaceIndex = description.indexOf(32);
        if (spaceIndex >= 0) {
            String numPart = description.substring(0, spaceIndex);
            Pair pair = LLValueData.isNum(numPart) ? Pair.create((Object)numPart, (Object)description.substring(spaceIndex + 1).trim()) : Pair.create(null, (Object)description);
            if (pair == null) {
                LLValueData.$$$reportNull$$$0(7);
            }
            return pair;
        }
        Pair pair = LLValueData.isNum(description) ? Pair.create((Object)description, (Object)"") : Pair.create(null, (Object)description);
        if (pair == null) {
            LLValueData.$$$reportNull$$$0(8);
        }
        return pair;
    }

    public boolean isTrue() {
        return !this.isFalse();
    }

    public boolean isFalse() {
        String[] s;
        for (String s1 : s = new String[]{NIL_PATTERN_STRING, "0+", "false", "NO", "'\\\\0'", "0 [LUu]?'.*'"}) {
            if (!Pattern.compile(s1).matcher(this.myValue).matches()) continue;
            return true;
        }
        return false;
    }

    public long intValue() throws DebuggerCommandException {
        try {
            String pointer = this.getPointerOrNull();
            if (pointer != null) {
                return DebuggerDriver.parseAddressSafe(pointer).unsignedLongValue();
            }
            return new BigInteger(this.myValue).longValue();
        }
        catch (NumberFormatException e) {
            throw new DebuggerCommandException("Value is not a valid integer: " + this.myValue);
        }
    }

    @Nullable
    @Nls
    public String getWarning() {
        return this.myWarning;
    }

    public String toString() {
        return (this.myIsSynthetic ? "[synthetic]" : "") + this.myValue + "(" + this.myDescription + ")" + (this.myMayHaveChildren ? ",has children" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLValueData valueData = (LLValueData)o;
        if (this.myMayHaveChildren != valueData.myMayHaveChildren) {
            return false;
        }
        if (this.myIsSynthetic != valueData.myIsSynthetic) {
            return false;
        }
        if (!this.myValue.equals(valueData.myValue)) {
            return false;
        }
        if (this.myDescription != null ? !this.myDescription.equals(valueData.myDescription) : valueData.myDescription != null) {
            return false;
        }
        return Objects.equals(this.myWarning, valueData.myWarning);
    }

    public int hashCode() {
        int result = this.myValue.hashCode();
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myMayHaveChildren ? 1 : 0);
        result = 31 * result + (this.myIsSynthetic ? 1 : 0);
        result = 31 * result + (this.myWarning != null ? this.myWarning.hashCode() : 0);
        return result;
    }

    private static boolean isNum(@NotNull String s) {
        if (s == null) {
            LLValueData.$$$reportNull$$$0(9);
        }
        try {
            new BigInteger(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @ApiStatus.Experimental
    public boolean isRichDescription() {
        return this.myIsRichDescription;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/LLValueData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/LLValueData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePointer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "splitNumberAndData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePointer";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isNum";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

