/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.lang.LanguageExtension;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.impl.CssTermImpl;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssApiBaseInspection;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssInspectionFilter {
    public static final LanguageExtension<CssInspectionFilter> INSTANCE = new LanguageExtension("com.intellij.css.cssInspectionFilter");
    private static final Set<String> deprecatedValues = Set.of("gray");

    public abstract boolean isSupported(@NotNull Class<? extends CssApiBaseInspection> var1, @NotNull PsiElement var2);

    public boolean isValueShouldBeValidatedWithCssScheme(@Nullable CssTermList value) {
        CssValueOwner valueOwner;
        PsiElement firstChildren;
        if (value != null && PsiTreeUtil.hasErrorElements((PsiElement)value)) {
            return false;
        }
        OuterLanguageElement outerLanguageElement = (OuterLanguageElement)PsiTreeUtil.findChildOfType((PsiElement)value, OuterLanguageElement.class);
        if (outerLanguageElement != null) {
            return false;
        }
        if (value != null && (firstChildren = value.getFirstChild()) instanceof CssTermImpl && ((CssTermImpl)firstChildren).getTermType() == CssTermTypes.NUMBER_WITH_UNKNOWN_UNIT) {
            return false;
        }
        if (value != null) {
            List injectedPsiFiles;
            InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)value.getProject());
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)value.getProject()).getInjectionHost((PsiElement)value);
            if (host != null && (injectedPsiFiles = injectionManager.getInjectedPsiFiles((PsiElement)host)) != null && !injectedPsiFiles.isEmpty()) {
                for (Pair pair : injectedPsiFiles) {
                    if (!((TextRange)pair.second).contains(value.getTextRange())) continue;
                    return true;
                }
                return false;
            }
        }
        if ((valueOwner = (CssValueOwner)PsiTreeUtil.getParentOfType((PsiElement)value, CssValueOwner.class)) != null && PsiTreeUtil.nextVisibleLeaf((PsiElement)valueOwner) instanceof OuterLanguageElement) {
            return false;
        }
        Collection functions = PsiTreeUtil.findChildrenOfType((PsiElement)value, CssFunction.class);
        for (CssFunction function : functions) {
            if ((function.getName().equals("var") || !CssDescriptorsUtil.getFunctionDescriptors(function.getName(), value).isEmpty()) && (function.getFunctionNameElement() == null || !deprecatedValues.contains(function.getFunctionNameElement().getText()))) continue;
            return false;
        }
        return true;
    }
}

