/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.execution.CidrBuildConfigurationWithSources;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeConfiguration
implements Serializable,
CidrBuildConfigurationWithSources {
    @NotNull
    private volatile CMakeTarget myTarget;
    private final int myProfileId;
    @NotNull
    private final String myProfileName;
    @NotNull
    private final String myBuildType;
    @NotNull
    private final Map<OCLanguageKind, CMakeConfigurationSettings> myPerLanguageSettings;
    @NotNull
    private final Map<File, CMakeFileSettings> mySources;
    @Nullable
    private final File myProductFile;
    @NotNull
    private final File myConfigurationGenerationDir;
    @NotNull
    private final File myConfigurationAndTargetGenerationDir;
    @NotNull
    private final File myBuildWorkingDir;
    @NotNull
    private final TargetType myTargetType;
    @NotNull
    private final Generator myGenerator;
    @NotNull
    private final List<String> myLinkerFlags;
    @NotNull
    private final MacroContext myMacroContext;
    private final boolean myIsElevated;

    public CMakeConfiguration(int profileId, @NotNull String profileName, @NotNull String buildType, @NotNull File configurationGenerationDir, @NotNull File configurationAndTargetGenerationDir, @NotNull Map<OCLanguageKind, CMakeConfigurationSettings> perLanguageSettings, @NotNull List<String> linkerFlags, @NotNull Map<File, CMakeFileSettings> sources, @Nullable File productFile, @NotNull File buildWorkingDir, @NotNull TargetType targetType, @NotNull Generator generator, @NotNull MacroContext macroContext, boolean isElevated) {
        if (profileName == null) {
            CMakeConfiguration.$$$reportNull$$$0(0);
        }
        if (buildType == null) {
            CMakeConfiguration.$$$reportNull$$$0(1);
        }
        if (configurationGenerationDir == null) {
            CMakeConfiguration.$$$reportNull$$$0(2);
        }
        if (configurationAndTargetGenerationDir == null) {
            CMakeConfiguration.$$$reportNull$$$0(3);
        }
        if (perLanguageSettings == null) {
            CMakeConfiguration.$$$reportNull$$$0(4);
        }
        if (linkerFlags == null) {
            CMakeConfiguration.$$$reportNull$$$0(5);
        }
        if (sources == null) {
            CMakeConfiguration.$$$reportNull$$$0(6);
        }
        if (buildWorkingDir == null) {
            CMakeConfiguration.$$$reportNull$$$0(7);
        }
        if (targetType == null) {
            CMakeConfiguration.$$$reportNull$$$0(8);
        }
        if (generator == null) {
            CMakeConfiguration.$$$reportNull$$$0(9);
        }
        if (macroContext == null) {
            CMakeConfiguration.$$$reportNull$$$0(10);
        }
        this.myProfileId = profileId;
        this.myProfileName = profileName;
        this.myBuildType = buildType;
        this.myConfigurationGenerationDir = configurationGenerationDir;
        this.myConfigurationAndTargetGenerationDir = configurationAndTargetGenerationDir;
        this.myPerLanguageSettings = Collections.unmodifiableMap(perLanguageSettings);
        this.myLinkerFlags = Collections.unmodifiableList(linkerFlags);
        this.mySources = Collections.unmodifiableMap(sources);
        this.myProductFile = productFile;
        this.myBuildWorkingDir = buildWorkingDir;
        this.myTargetType = targetType;
        this.myGenerator = generator;
        this.myMacroContext = macroContext;
        this.myIsElevated = isElevated;
    }

    void initTarget(@NotNull CMakeTarget target) {
        if (target == null) {
            CMakeConfiguration.$$$reportNull$$$0(11);
        }
        CPPLog.LOG.assertTrue(this.myTarget == null, (Object)"myTarget already initialized");
        this.myTarget = target;
    }

    public int getProfileId() {
        return this.myProfileId;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.myProfileName;
        if (string == null) {
            CMakeConfiguration.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getProfileName() {
        String string = this.myProfileName;
        if (string == null) {
            CMakeConfiguration.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getBuildType() {
        String string = this.myBuildType;
        if (string == null) {
            CMakeConfiguration.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public File getConfigurationGenerationDir() {
        File file = this.myConfigurationGenerationDir;
        if (file == null) {
            CMakeConfiguration.$$$reportNull$$$0(15);
        }
        return file;
    }

    @NotNull
    public File getConfigurationAndTargetGenerationDir() {
        File file = this.myConfigurationAndTargetGenerationDir;
        if (file == null) {
            CMakeConfiguration.$$$reportNull$$$0(16);
        }
        return file;
    }

    @Nullable
    public File getProductFile() {
        return this.myProductFile;
    }

    @NotNull
    public Collection<OCLanguageKind> getSupportedLanguages() {
        Set<OCLanguageKind> set = this.myPerLanguageSettings.keySet();
        if (set == null) {
            CMakeConfiguration.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    public Map<OCLanguageKind, CMakeConfigurationSettings> getPerLanguageSettingsMap() {
        Map<OCLanguageKind, CMakeConfigurationSettings> map = this.myPerLanguageSettings;
        if (map == null) {
            CMakeConfiguration.$$$reportNull$$$0(18);
        }
        return map;
    }

    @Nullable
    public CMakeConfigurationSettings getSettings(@Nullable OCLanguageKind languageKind) {
        return languageKind == null ? null : this.myPerLanguageSettings.get(languageKind);
    }

    @NotNull
    public List<String> getLinkerFlags() {
        List<String> list2 = this.myLinkerFlags;
        if (list2 == null) {
            CMakeConfiguration.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    public Collection<File> getSources() {
        Set<File> set = this.mySources.keySet();
        if (set == null) {
            CMakeConfiguration.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    Map<File, CMakeFileSettings> getSourcesMap() {
        Map<File, CMakeFileSettings> map = this.mySources;
        if (map == null) {
            CMakeConfiguration.$$$reportNull$$$0(21);
        }
        return map;
    }

    @Nullable
    public CMakeFileSettings getFileSettings(@Nullable File source) {
        return source == null ? null : this.mySources.get(source);
    }

    @NotNull
    public List<String> getCombinedCompilerFlags(@NotNull OCLanguageKind languageKind, @Nullable File source) {
        if (languageKind == null) {
            CMakeConfiguration.$$$reportNull$$$0(22);
        }
        CMakeConfigurationSettings config = this.getSettings(languageKind);
        CMakeFileSettings fileSettings = this.getFileSettings(source);
        ArrayList<String> result2 = new ArrayList<String>();
        if (fileSettings != null) {
            result2.addAll(fileSettings.getLeadingFlags());
        }
        if (config != null) {
            result2.addAll(config.getDefines());
        }
        if (fileSettings != null) {
            result2.addAll(fileSettings.getDefines());
        }
        if (config != null) {
            result2.addAll(config.getFlags());
        }
        if (fileSettings != null) {
            result2.addAll(fileSettings.getTrailingFlags());
        }
        List<String> list2 = Collections.unmodifiableList(result2);
        if (list2 == null) {
            CMakeConfiguration.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    public MacroContext getMacroContext() {
        MacroContext macroContext = this.myMacroContext;
        if (macroContext == null) {
            CMakeConfiguration.$$$reportNull$$$0(24);
        }
        return macroContext;
    }

    @NonNls
    public String toString() {
        return this.myProfileId + "-" + this.myProfileName + " [" + this.mySources.size() + " sources]";
    }

    @NotNull
    public CMakeTarget getTarget() {
        CMakeTarget cMakeTarget = this.myTarget;
        if (cMakeTarget == null) {
            CMakeConfiguration.$$$reportNull$$$0(25);
        }
        return cMakeTarget;
    }

    @NotNull
    public File getBuildWorkingDir() {
        File file = this.myBuildWorkingDir;
        if (file == null) {
            CMakeConfiguration.$$$reportNull$$$0(26);
        }
        return file;
    }

    @NotNull
    public TargetType getTargetType() {
        TargetType targetType = this.myTargetType;
        if (targetType == null) {
            CMakeConfiguration.$$$reportNull$$$0(27);
        }
        return targetType;
    }

    @NotNull
    public Generator getGenerator() {
        Generator generator = this.myGenerator;
        if (generator == null) {
            CMakeConfiguration.$$$reportNull$$$0(28);
        }
        return generator;
    }

    public boolean isElevated() {
        return this.myIsElevated;
    }

    @NotNull
    public CMakeConfiguration withIsElevated(boolean isElevated) {
        return new CMakeConfiguration(this.myProfileId, this.myProfileName, this.myBuildType, this.myConfigurationGenerationDir, this.myConfigurationAndTargetGenerationDir, this.myPerLanguageSettings, this.myLinkerFlags, this.mySources, this.myProductFile, this.myBuildWorkingDir, this.myTargetType, this.myGenerator, this.myMacroContext, isElevated);
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return new ProjectModelExternalSource(){

            @NotNull
            public String getDisplayName() {
                String string = CLionCMakeBundle.message("cmake", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getId() {
                return "CMake";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration$1", "getDisplayName"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationGenerationDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationAndTargetGenerationDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "perLanguageSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkerFlags";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildWorkingDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationGenerationDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationAndTargetGenerationDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPerLanguageSettingsMap";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkerFlags";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesMap";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedCompilerFlags";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroContext";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildWorkingDir";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetType";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initTarget";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedCompilerFlags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    public static enum TargetType {
        EXECUTABLE,
        STATIC_LIBRARY,
        MODULE_LIBRARY,
        SHARED_LIBRARY,
        OBJECT_LIBRARY,
        INTERFACE_LIBRARY,
        UTILITY;

        private static final Map<String, TargetType> ourSearchMap;

        @NotNull
        public static TargetType fromCodeBlocksTypeNumeral(@Nullable String val) {
            int intVal = StringUtil.parseInt((String)val, (int)0);
            TargetType targetType = switch (intVal) {
                case 0, 1 -> EXECUTABLE;
                case 2 -> STATIC_LIBRARY;
                case 3 -> SHARED_LIBRARY;
                default -> UTILITY;
            };
            if (targetType == null) {
                TargetType.$$$reportNull$$$0(0);
            }
            return targetType;
        }

        @NotNull
        public static TargetType fromString(String typeName) {
            TargetType type = ourSearchMap.get(typeName);
            TargetType targetType = type == null ? UTILITY : type;
            if (targetType == null) {
                TargetType.$$$reportNull$$$0(1);
            }
            return targetType;
        }

        static {
            ourSearchMap = new HashMap<String, TargetType>();
            for (TargetType type : TargetType.values()) {
                ourSearchMap.put(type.name(), type);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration$TargetType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromCodeBlocksTypeNumeral";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Generator
    implements Serializable {
        @NotNull
        public final CMakeGeneratorSpec generatorSpec;
        public final boolean isUsingAPI;

        public Generator(@NotNull CMakeGeneratorSpec generatorSpec, boolean api) {
            if (generatorSpec == null) {
                Generator.$$$reportNull$$$0(0);
            }
            this.generatorSpec = generatorSpec;
            this.isUsingAPI = api;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatorSpec", "com/jetbrains/cidr/cpp/cmake/model/CMakeConfiguration$Generator", "<init>"));
        }
    }

    public static class MacroContext
    implements Serializable {
        @Nullable
        private final String myEnvProductPath;
        @Nullable
        private final String myEnvBuildWorkingDir;
        @Nullable
        private final String myEnvConfigurationGenerationDir;

        public MacroContext(@Nullable String envProductPath, @Nullable String envBuildWorkingDir, @Nullable String envConfigurationGenerationDir) {
            this.myEnvProductPath = envProductPath;
            this.myEnvBuildWorkingDir = envBuildWorkingDir;
            this.myEnvConfigurationGenerationDir = envConfigurationGenerationDir;
        }

        @Nullable
        public String getEnvProductPath() {
            return this.myEnvProductPath;
        }

        @Nullable
        public String getEnvBuildWorkingDir() {
            return this.myEnvBuildWorkingDir;
        }

        @Nullable
        public String getEnvConfigurationGenerationDir() {
            return this.myEnvConfigurationGenerationDir;
        }
    }
}

