/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCompiler;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeConfigurationSettings
implements Serializable {
    @NotNull
    private final CMakeCompiler myCompiler;
    @Nullable
    private final File myCompilerExecutable;
    @NotNull
    private final List<String> myFlags;
    @NotNull
    private final List<String> myDefines;

    public CMakeConfigurationSettings(@NotNull CMakeCompiler compiler, @Nullable File compilerExecutable, @NotNull List<String> flags, @NotNull List<String> defines) {
        if (compiler == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(0);
        }
        if (flags == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(1);
        }
        if (defines == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(2);
        }
        this.myCompiler = compiler;
        this.myCompilerExecutable = compilerExecutable;
        this.myFlags = Collections.unmodifiableList(flags);
        this.myDefines = Collections.unmodifiableList(defines);
    }

    @NotNull
    public CMakeCompiler getCompiler() {
        CMakeCompiler cMakeCompiler = this.myCompiler;
        if (cMakeCompiler == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(3);
        }
        return cMakeCompiler;
    }

    @Nullable
    public File getCompilerExecutable() {
        return this.myCompilerExecutable;
    }

    @NotNull
    public List<String> getFlags() {
        List<String> list2 = this.myFlags;
        if (list2 == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public List<String> getDefines() {
        List<String> list2 = this.myDefines;
        if (list2 == null) {
            CMakeConfigurationSettings.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NonNls
    public String toString() {
        return "ConfigurationSettings: {compilers='" + String.valueOf(this.myCompiler) + "'@'" + String.valueOf(this.myCompiler) + "', flags='" + String.valueOf(this.myFlags) + "', defines='" + String.valueOf(this.myDefines) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CMakeConfigurationSettings settings = (CMakeConfigurationSettings)o;
        if (!this.myCompiler.equals(settings.myCompiler)) {
            return false;
        }
        if (!FileUtil.filesEqual((File)this.myCompilerExecutable, (File)settings.myCompilerExecutable)) {
            return false;
        }
        if (!this.myFlags.equals(settings.myFlags)) {
            return false;
        }
        return this.myDefines.equals(settings.myDefines);
    }

    public int hashCode() {
        int result2 = this.myCompiler.hashCode();
        result2 = 31 * result2 + FileUtil.fileHashCode((File)this.myCompilerExecutable);
        result2 = 31 * result2 + this.myFlags.hashCode();
        result2 = 31 * result2 + this.myDefines.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeConfigurationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeConfigurationSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompiler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

