/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeCoroutinesHelper;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeRunnerStep;
import com.jetbrains.cidr.cpp.cmake.MachinePath;
import com.jetbrains.cidr.cpp.cmake.model.CMakeApiProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorCommonInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileTargetInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTargetInfoComparator;
import com.jetbrains.cidr.cpp.cmake.model.CommonInfoV1;
import com.jetbrains.cidr.cpp.cmake.model.CommonInfoV2;
import com.jetbrains.cidr.cpp.cmake.model.InterceptingListener;
import com.jetbrains.cidr.cpp.cmake.presets.CMakePresetLoader;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeStatisticsCollector;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CMakeGenerator {
    public static final Map<@NlsSafe String, OCLanguageKind> PREDEFINED_EXTENSION_TO_LANGUAGE_MAP = new HashMap<String, OCLanguageKind>();
    private static final String GITIGNORE = ".gitignore";
    private static final String GITIGNORE_CONTENT = "# This file is autogenerated by CLion. If you change or delete it, it won't be recreated unless the whole directory is removed.\n*\n";
    private final ExecutorService myTasksExecutorService;
    protected static List<String> ourEmulateCMakeExecutionErrorInProfiles;
    @Nullable
    private static List<Pair<String, String>> ourEmulateProductNotFoundForTargetAndProfile;
    private static final AtomicLong ourTotalGenerationTime;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final File myProjectDir;
    @NotNull
    private final List<CMakeGeneratorParameters> myParameters;
    @Nullable
    private final String myPreferredEncoding;
    @NotNull
    private final Charset myDefaultCharset;

    public boolean shouldEmulateProductNotFoundForTargetAndProfile(Pair<String, String> pair) {
        return ourEmulateProductNotFoundForTargetAndProfile != null && ourEmulateProductNotFoundForTargetAndProfile.contains(pair);
    }

    ExecutorService getTasksExecutorService() {
        return this.myTasksExecutorService;
    }

    private static CMakeProfileGenerationResult createProfileGenerationResult(@NotNull CMakeGenerator generator, @NotNull CMakeGeneratorParameters parameters2, @Nullable CMakeModel previousModel) {
        if (generator == null) {
            CMakeGenerator.$$$reportNull$$$0(0);
        }
        if (parameters2 == null) {
            CMakeGenerator.$$$reportNull$$$0(1);
        }
        ToolVersion cmakeVersion = parameters2.getCmakeVersion();
        boolean shouldUseAPI = parameters2.getShouldUseAPI();
        CPPLog.LOG.info("Using " + (shouldUseAPI ? "CMake file-based API" : "legacy CMake generator") + " for profile " + parameters2.getProfileName() + ", generation directory: " + parameters2.getGenerationDir().getName() + ". CMake version: " + String.valueOf(cmakeVersion));
        return shouldUseAPI ? new CMakeApiProfileGenerationResult(generator, parameters2, previousModel) : new CMakeFileProfileGenerationResult(generator, parameters2, previousModel);
    }

    @TestOnly
    public static void setEmulateCMakeExecutionErrorInTests(String ... emulateInProfiles) {
        ourEmulateCMakeExecutionErrorInProfiles = emulateInProfiles == null || emulateInProfiles.length == 0 ? null : Arrays.asList(emulateInProfiles);
    }

    @SafeVarargs
    @TestOnly
    public static void setEmulateProductNotFoundInTests(Pair<String, String> ... targetAndProfiles) {
        ourEmulateProductNotFoundForTargetAndProfile = targetAndProfiles == null || targetAndProfiles.length == 0 ? null : Arrays.asList(targetAndProfiles);
    }

    public CMakeGenerator(@NotNull Project project, @NotNull File projectDir, @NotNull List<CMakeGeneratorParameters> parameters2, @Nullable String preferredEncoding, @NotNull Charset defaultCharset) {
        if (project == null) {
            CMakeGenerator.$$$reportNull$$$0(2);
        }
        if (projectDir == null) {
            CMakeGenerator.$$$reportNull$$$0(3);
        }
        if (parameters2 == null) {
            CMakeGenerator.$$$reportNull$$$0(4);
        }
        if (defaultCharset == null) {
            CMakeGenerator.$$$reportNull$$$0(5);
        }
        this.myTasksExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CMakeGenerator Task Pool", (int)Runtime.getRuntime().availableProcessors());
        this.myProject = project;
        this.myProjectDir = new File(FileUtil.toCanonicalPath((String)projectDir.getPath()));
        this.myParameters = parameters2;
        this.myPreferredEncoding = preferredEncoding;
        this.myDefaultCharset = defaultCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CMakeModel generate(@Nullable CMakeModel previousModel, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CMakeGenerator.$$$reportNull$$$0(6);
        }
        long before = System.currentTimeMillis();
        CMakeModel cMakeModel = this.doGenerate(previousModel, indicator);
        CMakeModel cMakeModel2 = cMakeModel;
        if (cMakeModel2 == null) {
            CMakeGenerator.$$$reportNull$$$0(7);
        }
        return cMakeModel2;
        finally {
            long after = System.currentTimeMillis();
            long time = after - before;
            ourTotalGenerationTime.addAndGet(time);
            CPPLog.LOG.info("CMake generation took " + StringUtil.formatDuration((long)time) + "; total time during this session: " + StringUtil.formatDuration((long)ourTotalGenerationTime.get()));
        }
    }

    private CMakeModel doGenerate(@Nullable CMakeModel previousModel, @NotNull ProgressIndicator indicator) {
        int i;
        int maxThreads;
        if (indicator == null) {
            CMakeGenerator.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        CMakeGeneratorCommonInfo commonInfo = Registry.is((String)"cmake.optimize.generator.collections") ? new CommonInfoV2() : new CommonInfoV1();
        commonInfo.addDependencyFile(CMakeGeneratorUtils.getCMakeListsFile(this.myProjectDir));
        List<Path> files = ((CMakePresetLoader)this.myProject.getService(CMakePresetLoader.class)).getPresetFiles();
        for (Path file : files) {
            commonInfo.addDependencyFile(file.toFile());
        }
        int n = maxThreads = AdvancedSettings.getBoolean((String)"cmake.reload.profiles.sequentially") ? 1 : Registry.get((String)"cmake.parallel.generation").asInteger();
        if (maxThreads < 1) {
            maxThreads = Runtime.getRuntime().availableProcessors();
        }
        ExecutorService executor = maxThreads > 1 ? AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CMakeGenerator Pool", (int)(maxThreads - 1)) : ConcurrencyUtil.newSameThreadExecutorService();
        ExecutorCompletionService completionService = new ExecutorCompletionService(executor);
        Condition isInSourceGeneration = each -> FileUtil.filesEqual((File)this.myProjectDir, (File)each.getGenerationDir());
        boolean hasInSourceCache = new File(this.myProjectDir, "CMakeCache.txt").exists();
        boolean hasInSourceGenerationParameters = ContainerUtil.find(this.myParameters, (Condition)isInSourceGeneration) != null;
        Map alreadyUsedGenerationDirs = FileCollectionFactory.createCanonicalFileMap();
        HashMap<File, InterceptingListener> cmakeListenerForDirectory = new HashMap<File, InterceptingListener>();
        ConcurrentHashMap cmakeCompletionFutureForDirectory = new ConcurrentHashMap();
        ArrayList<Object> submitted = new ArrayList<Object>(this.myParameters.size());
        ArrayList<Callable<CMakeProfileGenerationResult>> callables = new ArrayList<Callable<CMakeProfileGenerationResult>>();
        for (i = 0; i < this.myParameters.size(); ++i) {
            CMakeGeneratorParameters dirIsAlreadyUsedBy;
            CMakeGeneratorParameters each2 = this.myParameters.get(i);
            if ((hasInSourceGenerationParameters || hasInSourceCache) && !isInSourceGeneration.value((Object)each2)) {
                if (hasInSourceGenerationParameters) {
                    @NlsContexts.DetailedDescription String reason = hasInSourceCache ? CLionCMakeBundle.message("text.cmakecache.txt.found.in.project.dir.only.in.source.generation.will.be.performed", new Object[0]) : CLionCMakeBundle.message("cmake.text.only.in.source.generation.will.be.performed", new Object[0]);
                    each2.getListener().message(CMakeMessage.fatalError(CLionCMakeBundle.message("cmake.text.cannot.generate.into", each2.getProfileName(), each2.getGenerationDir(), reason), CMakeGeneratorUtils.getCMakeListsFile(this.myProjectDir)));
                    continue;
                }
                hasInSourceGenerationParameters = true;
                each2 = each2.withGenerationDir(this.myProjectDir);
            }
            if ((dirIsAlreadyUsedBy = (CMakeGeneratorParameters)alreadyUsedGenerationDirs.get(each2.getGenerationDir())) == null) {
                alreadyUsedGenerationDirs.put(each2.getGenerationDir(), each2);
                InterceptingListener interceptingListener = new InterceptingListener(each2.getListener());
                cmakeListenerForDirectory.put(each2.getGenerationDir(), interceptingListener);
                each2 = each2.withListener(interceptingListener);
            } else if (CMakeGenerator.allowSharing(each2, dirIsAlreadyUsedBy)) {
                each2 = each2.withShouldSkipCMake(true);
            }
            try {
                this.prepareGenerationDirectory(each2, dirIsAlreadyUsedBy == null ? null : dirIsAlreadyUsedBy.getProfileName());
            }
            catch (CMakeException e) {
                CMakeStatisticsCollector.PREPARE_FAILED.log(this.myProject);
                each2.getListener().message(CMakeMessage.fromException(e, CMakeGeneratorUtils.getCMakeListsFile(this.myProjectDir)));
                continue;
            }
            if (!each2.getShouldSkipCMake()) {
                cmakeCompletionFutureForDirectory.put(each2.getGenerationDir(), new CompletableFuture());
            } else {
                InterceptingListener runningListener = (InterceptingListener)cmakeListenerForDirectory.get(each2.getGenerationDir());
                if (runningListener != null) {
                    runningListener.bind(each2.getListener());
                }
            }
            CMakeGeneratorParameters finalParams = each2;
            Callable<CMakeProfileGenerationResult> callable = () -> {
                CMakeProfileGenerationResult result2 = CMakeGenerator.createProfileGenerationResult(this, finalParams, previousModel);
                CompletableFuture completionFuture = (CompletableFuture)cmakeCompletionFutureForDirectory.get(finalParams.getGenerationDir());
                if (!finalParams.getShouldSkipCMake()) {
                    ProgressManager.getInstance().runProcess(() -> result2.doGenerate(commonInfo, () -> {
                        if (completionFuture != null) {
                            completionFuture.complete(null);
                        }
                    }), (ProgressIndicator)new SensitiveProgressWrapper(indicator));
                } else {
                    ProgressManager.getInstance().runProcess(() -> {
                        if (completionFuture != null) {
                            completionFuture.whenComplete((a, b) -> result2.doGenerate(commonInfo, null));
                        }
                    }, (ProgressIndicator)new SensitiveProgressWrapper(indicator));
                }
                return result2;
            };
            callables.add(callable);
        }
        for (i = 0; i < callables.size(); ++i) {
            boolean isLast;
            boolean bl = isLast = i == callables.size() - 1;
            if (isLast) {
                FutureResult result3 = new FutureResult();
                try {
                    result3.set((Object)((CMakeProfileGenerationResult)((Callable)callables.get(i)).call()));
                }
                catch (Throwable e) {
                    result3.setException(e);
                }
                submitted.add(result3);
                continue;
            }
            submitted.add(completionService.submit((Callable)callables.get(i)));
        }
        ArrayList<CMakeProfileGenerationResult> profileGenerationResults = new ArrayList<CMakeProfileGenerationResult>();
        String projectName = null;
        ProgressManager.checkCanceled();
        ProcessCanceledException pce = null;
        for (Future future : submitted) {
            CMakeProfileGenerationResult result4 = null;
            try {
                result4 = (CMakeProfileGenerationResult)future.get();
            }
            catch (InterruptedException e) {
                pce = new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ProcessCanceledException) {
                    pce = (ProcessCanceledException)e.getCause();
                }
                CPPLog.LOG.error((Throwable)e);
            }
            if (result4 == null) continue;
            profileGenerationResults.add(result4);
            projectName = result4.getProjectName();
        }
        if (pce != null) {
            throw pce;
        }
        ProgressManager.checkCanceled();
        CMakeStatisticsCollector.PROFILES_LOADED.log(this.myProject, (Object)submitted.size(), (Object)Math.toIntExact(profileGenerationResults.stream().filter(result2 -> !result2.hasGenerationError()).count()));
        projectName = StringUtil.notNullize(projectName, (String)"Project");
        List<CMakeTarget> targets = this.convertToTargets(projectName, profileGenerationResults);
        long l = System.currentTimeMillis();
        commonInfo.adjustDependencyByResources();
        for (CMakeTarget eachTarget : targets) {
            for (CMakeConfiguration eachConfig : eachTarget.getBuildConfigurations()) {
                commonInfo.removeResources(eachConfig.getSources());
            }
        }
        CPPLog.LOG.info("Time spent to remove sources and dependency files " + (System.currentTimeMillis() - l) + " ms");
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.forEach((ext, kind) -> commonInfo.addExtension((String)ext, (OCLanguageKind)kind));
        CMakeGenerator.prepareEnvironmentStateBuilders(profileGenerationResults);
        List list2 = ContainerUtil.map(profileGenerationResults, it -> new CMakeModelConfigurationData(it.parameters.getHolder(), it.environmentStateBuilder.build(), it.cacheIOFile, it.cacheIOFileEncoding, it.getRegisteredBuildTypes()));
        commonInfo.compact();
        return new CMakeModel(projectName, commonInfo.getCmakeDependencyFiles(), commonInfo.getHeaderAndResourceFiles(), targets, commonInfo.getExtensions(), list2);
    }

    private static boolean allowSharing(CMakeGeneratorParameters each, CMakeGeneratorParameters dirIsAlreadyUsedBy) {
        return Registry.is((String)"cmake.allow.directory.sharing") && dirIsAlreadyUsedBy.getGeneratorSpec().equals(each.getGeneratorSpec()) && !CMakeGeneratorType.isSingleConfigurationGenerator(each.getGeneratorSpec().getGeneratorType()) && dirIsAlreadyUsedBy.getAdditionalOptions().equals(each.getAdditionalOptions()) && dirIsAlreadyUsedBy.getAdditionalEnvironment().equals(each.getAdditionalEnvironment()) && dirIsAlreadyUsedBy.getPassSystemEnvironment() == each.getPassSystemEnvironment() && dirIsAlreadyUsedBy.getEnvironment().getToolchain().equals((Object)each.getEnvironment().getToolchain());
    }

    @NotNull
    private List<CMakeTarget> convertToTargets(@NotNull String projectName, @NotNull List<CMakeProfileGenerationResult> generationResults) {
        if (projectName == null) {
            CMakeGenerator.$$$reportNull$$$0(9);
        }
        if (generationResults == null) {
            CMakeGenerator.$$$reportNull$$$0(10);
        }
        Map targetsWithConfigs = CMakeGeneratorUtils.createOrderedTargetKeysMap();
        for (CMakeProfileGenerationResult eachGenerationResult : generationResults) {
            Collection<? extends CMakeProfileTargetInfo> infos = eachGenerationResult.getTargetInfos();
            ArrayList<? extends CMakeProfileTargetInfo> sortedInfos = new ArrayList<CMakeProfileTargetInfo>(infos);
            sortedInfos.sort(new CMakeTargetInfoComparator(this.getCMakeListsFile()));
            for (CMakeProfileTargetInfo cMakeProfileTargetInfo : sortedInfos) {
                Pair targetInfoAndConfigs = targetsWithConfigs.computeIfAbsent(cMakeProfileTargetInfo.targetName, k -> new Pair((Object)eachTarget, new ArrayList(generationResults.size())));
                CMakeConfiguration.MacroContext macroContext = new CMakeConfiguration.MacroContext(CMakeGeneratorUtils.toEnvFile(cMakeProfileTargetInfo.environment, cMakeProfileTargetInfo.productFile), CMakeGeneratorUtils.toEnvFile(cMakeProfileTargetInfo.environment, cMakeProfileTargetInfo.buildWorkingDir), CMakeGeneratorUtils.toEnvFile(cMakeProfileTargetInfo.environment, cMakeProfileTargetInfo.generatedDir));
                ((List)targetInfoAndConfigs.second).add(new CMakeConfiguration(eachGenerationResult.parameters.getProfileId(), eachGenerationResult.parameters.getProfileName(), cMakeProfileTargetInfo.buildType, cMakeProfileTargetInfo.generatedDir, cMakeProfileTargetInfo.targetDir, cMakeProfileTargetInfo.perLanguageSettings, cMakeProfileTargetInfo.linkerFlags == null ? Collections.emptyList() : cMakeProfileTargetInfo.linkerFlags, cMakeProfileTargetInfo.sources, cMakeProfileTargetInfo.productFile, cMakeProfileTargetInfo.buildWorkingDir, cMakeProfileTargetInfo.targetType, cMakeProfileTargetInfo.generator, macroContext, false));
            }
        }
        ArrayList sortedTargetsWithConfigs = new ArrayList(targetsWithConfigs.values());
        sortedTargetsWithConfigs.sort(new Comparator<Pair<CMakeProfileTargetInfo, List<CMakeConfiguration>>>(){
            final CMakeTargetInfoComparator myBaseComparator;
            {
                this.myBaseComparator = new CMakeTargetInfoComparator(CMakeGenerator.this.getCMakeListsFile());
            }

            @Override
            public int compare(Pair<CMakeProfileTargetInfo, List<CMakeConfiguration>> o1, Pair<CMakeProfileTargetInfo, List<CMakeConfiguration>> o2) {
                return this.myBaseComparator.compare((CMakeProfileTargetInfo)o1.first, (CMakeProfileTargetInfo)o2.first);
            }
        });
        ArrayList<CMakeTarget> result2 = new ArrayList<CMakeTarget>(sortedTargetsWithConfigs.size());
        for (Pair eachTargetWithConfigs : sortedTargetsWithConfigs) {
            CMakeTarget target = new CMakeTarget(projectName, ((CMakeProfileTargetInfo)eachTargetWithConfigs.first).targetName, (List)eachTargetWithConfigs.second);
            for (CMakeConfiguration eachConfiguration : (List)eachTargetWithConfigs.second) {
                eachConfiguration.initTarget(target);
            }
            result2.add(target);
        }
        ArrayList<CMakeTarget> arrayList = result2;
        if (arrayList == null) {
            CMakeGenerator.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void prepareEnvironmentStateBuilders(@NotNull List<CMakeProfileGenerationResult> results) {
        if (results == null) {
            CMakeGenerator.$$$reportNull$$$0(12);
        }
        @Nullable Ref xcodeSelectPath = null;
        for (CMakeProfileGenerationResult result2 : results) {
            for (CMakeProfileTargetInfo cMakeProfileTargetInfo : result2.getTargetInfos()) {
                for (CMakeConfigurationSettings languageSettings : cMakeProfileTargetInfo.perLanguageSettings.values()) {
                    OCCompilerKind compilerKind = languageSettings.getCompiler().getCompilerKind();
                    File compilerExecutable = languageSettings.getCompilerExecutable();
                    if (compilerKind.equals(UnknownCompilerKind.INSTANCE) || compilerExecutable == null) continue;
                    result2.environmentStateBuilder.withCompiler(compilerExecutable.getPath());
                }
            }
            boolean isXcode = result2.environmentStateBuilder.checkIsXcode(result2.parameters.getEnvironment(), result2.parameters.getGeneratorSpec().getGenerator());
            result2.environmentStateBuilder.withIsXcode(isXcode);
            if (!isXcode) continue;
            if (xcodeSelectPath == null) {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                result2.environmentStateBuilder.queryXcodeSelect(result2.parameters.getEnvironment(), progressIndicator);
                xcodeSelectPath = new Ref((Object)result2.environmentStateBuilder.getXcodeSelectPath());
            } else {
                result2.environmentStateBuilder.withXcodeSelect((String)xcodeSelectPath.get());
            }
            ProgressManager.checkCanceled();
        }
    }

    private void prepareGenerationDirectory(@NotNull CMakeGeneratorParameters parameters2, @Nullable String dirIsAlreadyUsed) throws CMakeException {
        Path cacheFilePath2;
        if (parameters2 == null) {
            CMakeGenerator.$$$reportNull$$$0(13);
        }
        Function<@Nls String, @Nls String> formatMessage = text -> CLionCMakeBundle.message("cmake.cannot.generate.into.0.1.please.either.delete.it.manually.or.select.another.generation.directory", parameters2.getGenerationDir(), text);
        HostMachine host = parameters2.getEnvironment().getHostMachine();
        Path generationDir = host.getPath(parameters2.getGenerationDir().getPath(), new String[0]);
        if (dirIsAlreadyUsed != null && !parameters2.getShouldSkipCMake()) {
            throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("cmake.this.directory.is.already.used.for.0.profile", dirIsAlreadyUsed)));
        }
        try {
            Path gitIgnoreFile;
            if (CMakeGeneratorUtils.createPathIfDoesNotExist(generationDir, true) && !Files.exists(gitIgnoreFile = generationDir.resolve(GITIGNORE), new LinkOption[0])) {
                Files.writeString(gitIgnoreFile, (CharSequence)GITIGNORE_CONTENT, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new CMakeException(e.getMessage());
        }
        boolean cleanGeneratedFiles = false;
        boolean errorOnIncompatibleGeneratedFiles = true;
        @NonNls String currentToolchainAndOptions = parameters2.getEnvironment().calcToolchainHash() + "\nOptions:" + StringUtil.join(parameters2.getAdditionalOptions(), (String)"\u0000");
        Path envFile = CMakeGeneratorUtils.getCMakeFilesIDEFile(generationDir, "environment.txt");
        try {
            String prev = Files.readString(envFile);
            if (currentToolchainAndOptions.equals(prev)) {
                errorOnIncompatibleGeneratedFiles = false;
            } else {
                cleanGeneratedFiles = true;
                CPPLog.LOG.info("CMake will be regenerated due to environment change.\nNew environment: " + currentToolchainAndOptions + "\nOld environment: " + prev);
            }
        }
        catch (IOException prev) {
            // empty catch block
        }
        if (!cleanGeneratedFiles && Files.exists(cacheFilePath2 = generationDir.resolve("CMakeCache.txt"), new LinkOption[0])) {
            File cacheFile;
            try {
                cacheFile = host.resolvePath(cacheFilePath2);
            }
            catch (IOException e) {
                throw new CMakeException(CLionCMakeBundle.message("cannot.resolve.path", cacheFilePath2), e);
            }
            try {
                File previousProjectDir;
                CMakeCacheFile cache;
                try {
                    cache = new CMakeCacheFile(cacheFile, this.encodingForFile(cacheFile));
                }
                catch (CMakeException e) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("cannot.read.file", cacheFile.getName())), e);
                }
                String previousProjectDirValue = cache.getVariableValue("CMAKE_HOME_DIRECTORY");
                File file = previousProjectDir = previousProjectDirValue == null ? null : CMakeGeneratorUtils.toLocalFile(parameters2.getEnvironment(), previousProjectDirValue);
                if (previousProjectDir == null) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("it.is.already.used.for.unknown.project", new Object[0])));
                }
                if (!FileUtil.filesEqual((File)this.myProjectDir, (File)previousProjectDir)) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("it.is.already.used.for.project", previousProjectDir)));
                }
                CMakeGeneratorSpec previousGenerator = CMakeGeneratorSpec.readGeneratorFromCMakeCache(cache);
                if (previousGenerator == null || previousGenerator.getGenerator() instanceof CMakeGeneratorType.UNKNOWN) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("it.was.created.with.unknown.generator", new Object[0])));
                }
                CMakeGeneratorSpec generator = parameters2.getGeneratorSpec();
                if (!(previousGenerator.getGenerator() instanceof CMakeGeneratorType.UNKNOWN) && !previousGenerator.isCompatibleWith(generator) && generator != CMakeGeneratorSpec.NONE) {
                    throw new CMakeException(formatMessage.apply(CLionCMakeBundle.message("it.was.created.with.incompatible.generator", previousGenerator)));
                }
            }
            catch (CMakeException e) {
                if (errorOnIncompatibleGeneratedFiles) {
                    throw e;
                }
                cleanGeneratedFiles = true;
                CPPLog.LOG.info("CMake will be regenerated due to incompatible generated files: " + e.getMessage());
            }
        }
        if (cleanGeneratedFiles) {
            try {
                CMakeCoroutinesHelper.cleanGeneratedCMakeFilesWithRmTry(this.myProject, new MachinePath(host, generationDir));
            }
            catch (IOException cacheFilePath2) {
                // empty catch block
            }
        }
        try {
            Files.writeString(NioFiles.createParentDirectories((Path)envFile), (CharSequence)currentToolchainAndOptions, new OpenOption[0]);
        }
        catch (Exception e) {
            String message = CLionCMakeBundle.message("cannot.save.file", envFile);
            throw new CMakeException(SystemUtil.patchMessage((String)message, (Path)envFile, (String)e.getMessage()), e);
        }
    }

    @NotNull
    File getCMakeListsFile() {
        File file = CMakeGeneratorUtils.getCMakeListsFile(this.myProjectDir);
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(14);
        }
        return file;
    }

    public abstract @NotNull CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CMakeGeneratorParameters var1, @NotNull List<String> var2) throws CMakeException;

    @NotNull
    protected CMakeRunnerStep.Parameters executeRunnerSteps(@NotNull CMakeRunnerStep.Parameters parameters2) throws CMakeException {
        if (parameters2 == null) {
            CMakeGenerator.$$$reportNull$$$0(15);
        }
        CMakeRunnerStep.Parameters newParameters = parameters2;
        for (CMakeRunnerStep eachStep : CMakeRunnerStep.EP_NAME.getExtensionList()) {
            newParameters = eachStep.modifyParameters(this.myProject, newParameters);
        }
        for (CMakeRunnerStep eachStep : CMakeRunnerStep.EP_NAME.getExtensionList()) {
            try {
                eachStep.beforeGeneration(this.myProject, newParameters);
            }
            catch (CMakeException e) {
                throw e;
            }
            catch (Throwable e) {
                CPPLog.LOG.warn("Extension thrown exception: " + String.valueOf(eachStep), e);
            }
        }
        CMakeRunnerStep.Parameters parameters3 = newParameters;
        if (parameters3 == null) {
            CMakeGenerator.$$$reportNull$$$0(16);
        }
        return parameters3;
    }

    @NotNull
    String encodingForFile(@NotNull File file) {
        String string;
        if (file == null) {
            CMakeGenerator.$$$reportNull$$$0(17);
        }
        if (this.myPreferredEncoding != null) {
            String string2 = this.myPreferredEncoding;
            if (string2 == null) {
                CMakeGenerator.$$$reportNull$$$0(18);
            }
            return string2;
        }
        int shortLength = (int)file.length();
        if (shortLength <= 0) {
            String string3 = this.myDefaultCharset.name();
            if (string3 == null) {
                CMakeGenerator.$$$reportNull$$$0(19);
            }
            return string3;
        }
        try {
            Charset guessedCharset = CharsetToolkit.guessEncoding((File)file, (int)shortLength, (Charset)this.myDefaultCharset);
            string = (guessedCharset == null ? this.myDefaultCharset : guessedCharset).name();
        }
        catch (IOException e) {
            String string4 = this.myDefaultCharset.name();
            if (string4 == null) {
                CMakeGenerator.$$$reportNull$$$0(21);
            }
            return string4;
        }
        if (string == null) {
            CMakeGenerator.$$$reportNull$$$0(20);
        }
        return string;
    }

    static {
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put("m", (OCLanguageKind)CLanguageKind.OBJ_C);
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put("M", (OCLanguageKind)CLanguageKind.OBJ_CPP);
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put("mm", (OCLanguageKind)CLanguageKind.OBJ_CPP);
        PREDEFINED_EXTENSION_TO_LANGUAGE_MAP.put("mxx", (OCLanguageKind)CLanguageKind.CPP);
        ourEmulateCMakeExecutionErrorInProfiles = null;
        ourEmulateProductNotFoundForTargetAndProfile = null;
        ourTotalGenerationTime = new AtomicLong(0L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 14, 16, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 4: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationResults";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToTargets";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeListsFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "executeRunnerSteps";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "encodingForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProfileGenerationResult";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doGenerate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertToTargets";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironmentStateBuilders";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareGenerationDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executeRunnerSteps";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "encodingForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 14, 16, 18, 19, 20, 21 -> new IllegalStateException(string);
        };
    }

    static class EmulatedCMakeException
    extends CMakeException {
        EmulatedCMakeException(String message) {
            super(message);
        }
    }
}

