/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProjectsAwareKt;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceReloadTask;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProjectsAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "workspace", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;", "<init>", "(Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;)V", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "settingsFiles", "", "", "getSettingsFiles", "()Ljava/util/Set;", "subscribe", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "reloadProject", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "Companion", "intellij.clion.cmake"})
public final class CMakeProjectsAware
implements ExternalSystemProjectAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMakeWorkspace workspace;
    @NotNull
    private final ExternalSystemProjectId projectId;
    @NotNull
    private final Set<String> settingsFiles;

    public CMakeProjectsAware(@NotNull CMakeWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)((Object)workspace), (String)"workspace");
        this.workspace = workspace;
        this.projectId = new ExternalSystemProjectId(CMakeProjectsAwareKt.getCMAKE_ID(), ((Object)this.workspace.getProjectPath()).toString());
        this.settingsFiles = SetsKt.emptySet();
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    @NotNull
    public Set<String> getSettingsFiles() {
        return this.settingsFiles;
    }

    public void subscribe(@NotNull ExternalSystemProjectListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MessageBusConnection messageBusConnection = this.workspace.getProject().getMessageBus().connect(parentDisposable);
        Topic<CMakeWorkspaceListener> topic = CMakeWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new CMakeWorkspaceListener(listener2){
            final /* synthetic */ ExternalSystemProjectListener $listener;
            {
                this.$listener = $listener;
            }

            public void reloadingStarted() {
                this.$listener.onProjectReloadStart();
            }

            public void reloadingFinished(boolean canceled) {
                this.$listener.onProjectReloadFinish(canceled ? ExternalSystemRefreshStatus.CANCEL : ExternalSystemRefreshStatus.SUCCESS);
            }
        });
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.workspace.isInitialized() && context.isExplicitReload()) {
            this.workspace.scheduleReload(CMakeWorkspaceReloadTask.Companion.force().withExplicit(true));
        }
    }

    @JvmStatic
    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @TestOnly
    public static final void setDisabled(@NotNull Disposable disposable) {
        Companion.setDisabled(disposable);
    }

    @JvmStatic
    public static final void initialize(@NotNull CMakeWorkspace workspace, @NotNull Disposable parentDisposable) {
        Companion.initialize(workspace, parentDisposable);
    }

    @JvmStatic
    public static final void notify(@NotNull Project project) {
        Companion.notify(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProjectsAware$Companion;", "", "<init>", "()V", "isEnabled", "", "setDisabled", "", "disposable", "Lcom/intellij/openapi/Disposable;", "initialize", "workspace", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;", "parentDisposable", "notify", "project", "Lcom/intellij/openapi/project/Project;", "runTask", "block", "Lkotlin/Function1;", "intellij.clion.cmake"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isEnabled() {
            return AdvancedSettings.Companion.getBoolean("cmake.floating.toolbar.reload.notification");
        }

        @JvmStatic
        @TestOnly
        public final void setDisabled(@NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            AdvancedSettings advancedSettings = AdvancedSettings.Companion.getInstance();
            Intrinsics.checkNotNull((Object)advancedSettings, (String)"null cannot be cast to non-null type com.intellij.openapi.options.advanced.AdvancedSettingsImpl");
            ((AdvancedSettingsImpl)advancedSettings).setSetting("cmake.floating.toolbar.reload.notification", (Object)false, disposable);
        }

        @JvmStatic
        public final void initialize(@NotNull CMakeWorkspace workspace, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)((Object)workspace), (String)"workspace");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            if (!this.isEnabled()) {
                return;
            }
            CMakeProjectsAware projectAware = new CMakeProjectsAware(workspace);
            Project project = workspace.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project);
            projectTracker.register((ExternalSystemProjectAware)projectAware, parentDisposable);
            projectTracker.activate(projectAware.getProjectId());
        }

        @JvmStatic
        public final void notify(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.runTask(project, (Function1<? super CMakeWorkspace, Unit>)((Function1)Companion::notify$lambda$0));
        }

        private final void runTask(Project project, Function1<? super CMakeWorkspace, Unit> block) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.runTask$lambda$1(project, block), project.getDisposed());
        }

        private static final Unit notify$lambda$0(CMakeWorkspace workspace) {
            Intrinsics.checkNotNullParameter((Object)((Object)workspace), (String)"workspace");
            CMakeProjectsAware projectAware = new CMakeProjectsAware(workspace);
            Project project = workspace.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project);
            projectTracker.markDirty(projectAware.getProjectId());
            projectTracker.scheduleChangeProcessing();
            return Unit.INSTANCE;
        }

        private static final void runTask$lambda$1(Project $project, Function1 $block) {
            if (!Companion.isEnabled()) {
                return;
            }
            CMakeWorkspace workspace = CMakeWorkspace.Companion.getInstance($project);
            if (!workspace.isInitialized()) {
                return;
            }
            $block.invoke((Object)workspace);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

