/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build.runners;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskRunner;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeExplicitTargetConfiguration;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeBuildTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeCleanTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeCompileTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.runners.CMakeInstallTaskRunner;
import com.jetbrains.cidr.cpp.execution.build.tasks.CLionInstallTask;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTask;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J7\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0014\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CMakeProjectTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "<init>", "()V", "buildSystemId", "", "getBuildSystemId", "()Ljava/lang/String;", "canRun", "", "project", "Lcom/intellij/openapi/project/Project;", "projectTask", "Lcom/intellij/task/ProjectTask;", "run", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/task/ProjectTaskRunner$Result;", "context", "Lcom/intellij/task/ProjectTaskContext;", "tasks", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/task/ProjectTaskContext;[Lcom/intellij/task/ProjectTask;)Lorg/jetbrains/concurrency/Promise;", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "task", "Companion", "intellij.clion.cmake"})
@SourceDebugExtension(value={"SMAP\nCMakeProjectTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeProjectTaskRunner.kt\ncom/jetbrains/cidr/cpp/execution/build/runners/CMakeProjectTaskRunner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,75:1\n12434#2,2:76\n*S KotlinDebug\n*F\n+ 1 CMakeProjectTaskRunner.kt\ncom/jetbrains/cidr/cpp/execution/build/runners/CMakeProjectTaskRunner\n*L\n42#1:76,2\n*E\n"})
public final class CMakeProjectTaskRunner
extends CidrProjectTaskRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String buildSystemId;
    @NotNull
    public static final String ID = "CMake";

    public CMakeProjectTaskRunner() {
        this.buildSystemId = ID;
    }

    @NotNull
    public String getBuildSystemId() {
        return this.buildSystemId;
    }

    public boolean canRun(@NotNull Project project, @NotNull ProjectTask projectTask) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
        CMakeWorkspace workspace = CMakeWorkspace.Companion.getInstance(project);
        return workspace.isInitialized() && this.canRun(projectTask) && (projectTask instanceof ModuleBuildTask ? Intrinsics.areEqual((Object)((ModuleBuildTask)projectTask).getModule(), (Object)workspace.getModule()) : true);
    }

    @NotNull
    public Promise<ProjectTaskRunner.Result> run(@NotNull Project project, @NotNull ProjectTaskContext context, ProjectTask ... tasks) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        return TrustedProjects.isProjectTrusted((Project)project) ? super.run(project, context, Arrays.copyOf(tasks, tasks.length)) : Promises.rejectedPromise((String)"Project is not trusted");
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
            Function1 isConfiguration = CMakeProjectTaskRunner::canRun$lambda$0;
            ProjectTask projectTask2 = projectTask;
            if (projectTask2 instanceof ModuleFilesBuildTask) {
                VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)projectTask).getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                if (((Object[])virtualFileArray).length == 0) {
                    bl = false;
                } else {
                    VirtualFile[] virtualFileArray2 = ((ModuleFilesBuildTask)projectTask).getFiles();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getFiles(...)");
                    Object[] $this$all$iv = virtualFileArray2;
                    boolean $i$f$all = false;
                    for (Object element$iv : $this$all$iv) {
                        VirtualFile it = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        if (!it.isDirectory() && (OCFileTypeHelpers.isSourceFile((String)it.getName()) || OCFileTypeHelpers.isHeaderFile((String)it.getName()))) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            } else {
                if (projectTask2 instanceof ModuleBuildTask) {
                    return true;
                }
                if (projectTask2 instanceof CLionInstallTask) {
                    CidrBuildConfiguration cidrBuildConfiguration = ((CLionInstallTask)projectTask).getBuildConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)cidrBuildConfiguration, (String)"getBuildConfiguration(...)");
                    return (Boolean)isConfiguration.invoke((Object)cidrBuildConfiguration);
                }
                if (projectTask2 instanceof CidrCleanTask) {
                    CidrBuildConfiguration cidrBuildConfiguration = ((CidrCleanTask)projectTask).getBuildConfiguration();
                    Intrinsics.checkNotNullExpressionValue((Object)cidrBuildConfiguration, (String)"getBuildConfiguration(...)");
                    return (Boolean)isConfiguration.invoke((Object)cidrBuildConfiguration);
                }
                if (projectTask2 instanceof ProjectModelBuildTask) {
                    ProjectModelBuildableElement projectModelBuildableElement = ((ProjectModelBuildTask)projectTask).getBuildableElement();
                    Intrinsics.checkNotNullExpressionValue((Object)projectModelBuildableElement, (String)"getBuildableElement(...)");
                    return (Boolean)isConfiguration.invoke((Object)projectModelBuildableElement);
                }
                return false;
            }
        }
        return bl;
    }

    @Nullable
    public CidrTaskRunner runnerForTask(@NotNull ProjectTask task2, @NotNull Project project) {
        CidrTaskRunner cidrTaskRunner;
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectTask projectTask = task2;
        if (projectTask instanceof ModuleFilesBuildTask) {
            cidrTaskRunner = (CidrTaskRunner)new CMakeCompileTaskRunner();
        } else if (projectTask instanceof ModuleBuildTask) {
            cidrTaskRunner = CMakeBuildTaskRunner.INSTANCE;
        } else if (projectTask instanceof ProjectModelBuildTask) {
            cidrTaskRunner = CMakeBuildTaskRunner.INSTANCE;
        } else if (projectTask instanceof CLionInstallTask) {
            cidrTaskRunner = CMakeInstallTaskRunner.INSTANCE;
        } else if (projectTask instanceof CidrCleanTask) {
            cidrTaskRunner = CMakeCleanTaskRunner.INSTANCE;
        } else {
            CPPLog.LOG.error("Unexpected project task type: " + task2.getPresentableName());
            return null;
        }
        return cidrTaskRunner;
    }

    private static final boolean canRun$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof CMakeConfiguration || it instanceof CMakeExplicitTargetConfiguration;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/runners/CMakeProjectTaskRunner$Companion;", "", "<init>", "()V", "ID", "", "intellij.clion.cmake"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

