/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.PredefinedVariables;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugConsoleFilterProvider;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugProcess;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeListRunConfiguration;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeRunProfileState
extends CommandLineState {
    static final Key<CPPEnvironment> CPP_ENVIRONMENT_KEY = Key.create((String)"CMakeRunProfileState.CPPEnvironment");
    @Nullable
    private Integer myDebugPort;
    @Nullable
    private String myDebugToken;
    @Nullable
    private File myDebugTokenFile;
    @Nullable
    private String myDebugPipePath;
    @NotNull
    private CMakeExecutableTool.CMakeDebugProtocol myDebugProtocol = CMakeExecutableTool.CMakeDebugProtocol.NONE;
    private String myCMakeProfileName;

    public CMakeRunProfileState(ExecutionEnvironment environment) {
        super(environment);
    }

    @NotNull
    protected ProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler oSProcessHandler;
        try {
            CPPToolchains.Toolchain toolchain;
            Project project = this.getEnvironment().getProject();
            CMakeWorkspace cmakeWorkspace = CMakeWorkspace.getInstance(project);
            CMakeListRunConfiguration config = (CMakeListRunConfiguration)((Object)ObjectUtils.tryCast((Object)this.getEnvironment().getRunProfile(), CMakeListRunConfiguration.class));
            if (config == null) {
                throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.unexpected.run.configuration.type", new Object[0]));
            }
            ExecutionTarget target = this.getEnvironment().getExecutionTarget();
            if (!(target instanceof CMakeBuildProfileExecutionTarget)) {
                throw new ExecutionException(ProgramRunnerUtil.getCannotRunOnErrorMessage((RunProfile)this.getEnvironment().getRunProfile(), (ExecutionTarget)target));
            }
            CMakeBuildProfileExecutionTarget cmakeTarget = (CMakeBuildProfileExecutionTarget)target;
            String cmakeProfileName = cmakeTarget.getProfileName();
            CMakeProfileInfo cmakeProfileInfo = cmakeWorkspace.getCMakeProfileInfoByName(cmakeProfileName);
            if (cmakeProfileInfo == null) {
                throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.cmake.profile.not.found", cmakeProfileName));
            }
            this.myCMakeProfileName = cmakeProfileInfo.getProfile().getName();
            CPPEnvironment environment = cmakeProfileInfo.getEnvironment();
            CPPToolchains.Toolchain toolchain2 = toolchain = environment != null ? environment.getToolchain() : null;
            if (toolchain == null) {
                throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.toolchain.not.found", new Object[0]));
            }
            if (!CMakeRunProfileState.isSupportedToolchain(toolchain)) {
                throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.toolchain.not.supported", new Object[0]));
            }
            CMakeExecutableTool tool = environment.getCMake();
            if (tool == null) {
                throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.failed.to.create.cmake.tool", new Object[0]));
            }
            GeneralCommandLine cmd = this.getCMakeCommandLine(project, cmakeWorkspace, tool, cmakeProfileInfo, environment);
            environment.prepare(cmd, CidrToolEnvironment.PrepareFor.BUILD);
            cmd.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
            if (StringUtil.isNotEmpty((String)toolchain.getEnvironment())) {
                environment.applyEnvironmentFromFile(toolchain.getEnvironment(), cmd);
            }
            OSProcessHandler processHandler = new OSProcessHandler(cmd){

                @NotNull
                protected BaseOutputReader.Options readerOptions() {
                    BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                    if (options == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return options;
                }

                public void notifyTextAvailable(@NotNull String text, @NotNull Key outputType) {
                    if (text == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    super.notifyTextAvailable(text, outputType);
                    CMakeDebugProcess.LOG.debug("CMake output: " + text);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunProfileState$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "readerOptions";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunProfileState$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "notifyTextAvailable";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1, 2 -> new IllegalArgumentException(string);
                    };
                }
            };
            processHandler.putUserData(CPP_ENVIRONMENT_KEY, (Object)environment);
            oSProcessHandler = processHandler;
        }
        catch (ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            CMakeDebugProcess.LOG.warn("Failed to start cmake", (Throwable)e);
            throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.failed.to.start.cmake", new Object[0]), (Throwable)e);
        }
        if (oSProcessHandler == null) {
            CMakeRunProfileState.$$$reportNull$$$0(0);
        }
        return oSProcessHandler;
    }

    @NotNull
    private GeneralCommandLine getCMakeCommandLine(@NotNull Project project, @NotNull CMakeWorkspace cmakeWorkspace, @NotNull CMakeExecutableTool tool, @NotNull CMakeProfileInfo cmakeProfileInfo, @NotNull CPPEnvironment environment) throws ExecutionException {
        List cmakeParams;
        CMakeGeneratorParameters generatorParameters;
        if (project == null) {
            CMakeRunProfileState.$$$reportNull$$$0(1);
        }
        if (cmakeWorkspace == null) {
            CMakeRunProfileState.$$$reportNull$$$0(2);
        }
        if (tool == null) {
            CMakeRunProfileState.$$$reportNull$$$0(3);
        }
        if (cmakeProfileInfo == null) {
            CMakeRunProfileState.$$$reportNull$$$0(4);
        }
        if (environment == null) {
            CMakeRunProfileState.$$$reportNull$$$0(5);
        }
        if ((generatorParameters = CMakeGeneratorParameters.calculateFromProfileInfo(project, cmakeProfileInfo, 0)) != null) {
            String buildTypeOption;
            boolean hasUserSpecifiedGenerator = CMakeGeneratorUtils.hasUserSpecifiedGenerator(generatorParameters.getAdditionalOptions()) || cmakeProfileInfo.getProfile().getNoGenerator();
            ParametersList cmakeParamList = new ParametersList();
            if (!hasUserSpecifiedGenerator) {
                cmakeParamList.add("-G");
                cmakeParamList.add(generatorParameters.getGeneratorSpec().asCommandLineOption());
            }
            if (StringUtil.isNotEmpty((String)(buildTypeOption = CMakeGeneratorUtils.getBuildTypeOption(generatorParameters.getBuildType())))) {
                cmakeParamList.addParametersString(buildTypeOption);
            }
            cmakeParamList.addAll(generatorParameters.getAdditionalOptions());
            cmakeParams = cmakeParamList.getList();
        } else {
            cmakeParams = new ArrayList();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(tool.getExecutablePath());
        if ("Debug".equals(this.getEnvironment().getExecutor().getId())) {
            if (this.myDebugProtocol == CMakeExecutableTool.CMakeDebugProtocol.NONE) {
                throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.debug.is.not.supported", new Object[0]));
            }
            if (this.myDebugProtocol == CMakeExecutableTool.CMakeDebugProtocol.DAP) {
                if (this.myDebugPipePath == null) {
                    throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.debug.pipe.missing", new Object[0]));
                }
                params.add("--debugger");
                params.add("--debugger-pipe=" + this.myDebugPipePath);
            } else if (this.myDebugProtocol == CMakeExecutableTool.CMakeDebugProtocol.SYSPROGS) {
                if (this.myDebugPort == null) {
                    throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.debug.port.missing", new Object[0]));
                }
                if (this.myDebugToken == null || this.myDebugTokenFile == null) {
                    throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.debug.token.missing", new Object[0]));
                }
                params.add("--debug-server-port");
                params.add(String.valueOf(this.myDebugPort));
                params.add("--debug-token-path");
                params.add(environment.toEnvPath(this.myDebugTokenFile.getAbsolutePath()));
            }
        }
        params.add("-S");
        params.add(environment.toEnvPath(cmakeWorkspace.getProjectPath().toAbsolutePath().toString()));
        params.add("-B");
        params.add(environment.toEnvPath(cmakeProfileInfo.getGenerationDir().getAbsolutePath()));
        params.addAll(cmakeParams);
        GeneralCommandLine cmd = new GeneralCommandLine(params);
        if (generatorParameters != null) {
            if (generatorParameters.getPassSystemEnvironment()) {
                cmd.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
            }
            cmd.withEnvironment(generatorParameters.getAdditionalEnvironment());
        }
        for (String variable : PredefinedVariables.getIDEVariables()) {
            cmd.withEnvironment(variable, "TRUE");
        }
        cmd.setWorkDirectory(cmakeProfileInfo.getGenerationDir());
        GeneralCommandLine generalCommandLine = cmd;
        if (generalCommandLine == null) {
            CMakeRunProfileState.$$$reportNull$$$0(6);
        }
        return generalCommandLine;
    }

    public TextConsoleBuilder getConsoleBuilder() {
        TextConsoleBuilder result2 = super.getConsoleBuilder();
        result2.addFilter((Filter)new CMakeDebugConsoleFilterProvider.CMakeDebuggerFilter(this.getEnvironment().getProject(), this.myCMakeProfileName));
        return result2;
    }

    @Nullable
    public Integer getDebugPort() {
        return this.myDebugPort;
    }

    public void setDebugPort(@Nullable Integer debugPort) {
        this.myDebugPort = debugPort;
    }

    @Nullable
    public String getDebugToken() {
        return this.myDebugToken;
    }

    public void setDebugToken(@Nullable String debugToken) {
        this.myDebugToken = debugToken;
    }

    @Nullable
    public File getDebugTokenFile() {
        return this.myDebugTokenFile;
    }

    public void setDebugTokenFile(@Nullable File debugTokenFile) {
        this.myDebugTokenFile = debugTokenFile;
    }

    @Nullable
    public String getDebugPipePath() {
        return this.myDebugPipePath;
    }

    public void setDebugPipePath(@Nullable String debugPipePath) {
        this.myDebugPipePath = debugPipePath;
    }

    @NotNull
    public CMakeExecutableTool.CMakeDebugProtocol getDebugProtocol() {
        CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol = this.myDebugProtocol;
        if (cMakeDebugProtocol == null) {
            CMakeRunProfileState.$$$reportNull$$$0(7);
        }
        return cMakeDebugProtocol;
    }

    public void setDebugProtocol(@NotNull CMakeExecutableTool.CMakeDebugProtocol debugProtocol) {
        if (debugProtocol == null) {
            CMakeRunProfileState.$$$reportNull$$$0(8);
        }
        this.myDebugProtocol = debugProtocol;
    }

    public static boolean isSupportedToolchain(@NotNull CPPToolchains.Toolchain toolchain) {
        CPPToolSet.Kind toolsetKind;
        if (toolchain == null) {
            CMakeRunProfileState.$$$reportNull$$$0(9);
        }
        return !(toolsetKind = toolchain.getToolSetKind()).isRemoteLike();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunProfileState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeWorkspace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeProfileInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProtocol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeRunProfileState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeCommandLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDebugProtocol";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedToolchain";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

