/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.workspace.compiler.resolver.locators;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.CppCMakeCompilerDotCmakeLocator;
import com.jetbrains.cidr.cpp.workspace.compiler.resolver.CppCMakeLanguageId;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/locators/CppExactVersionBasedLocator;", "Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeCompilerDotCmakeLocator;", "cmakeVersion", "", "<init>", "(Ljava/lang/String;)V", "locate", "Ljava/nio/file/Path;", "projectDirectory", "languageId", "Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/CppCMakeLanguageId;", "Companion", "intellij.clion.cmake"})
public final class CppExactVersionBasedLocator
implements CppCMakeCompilerDotCmakeLocator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String cmakeVersion;
    @NotNull
    private static final Logger LOGGER;

    public CppExactVersionBasedLocator(@NotNull String cmakeVersion) {
        Intrinsics.checkNotNullParameter((Object)cmakeVersion, (String)"cmakeVersion");
        this.cmakeVersion = cmakeVersion;
        if (!(((CharSequence)this.cmakeVersion).length() > 0)) {
            boolean bl = false;
            String string = "CMake version is empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @Nullable
    public Path locate(@NotNull Path projectDirectory, @NotNull CppCMakeLanguageId languageId) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)((Object)languageId), (String)"languageId");
        try {
            Path compilerInformationHome = projectDirectory.resolve("CMakeFiles").resolve(this.cmakeVersion);
            if (!Files.isDirectory(compilerInformationHome, new LinkOption[0])) {
                return null;
            }
            Path compilerInformation = compilerInformationHome.resolve(languageId.getCmakeOutputFileName());
            if (!Files.isRegularFile(compilerInformation, new LinkOption[0]) || Files.size(compilerInformation) == 0L) {
                return null;
            }
            return compilerInformation;
        }
        catch (IOException ioe) {
            String string = ioe.getMessage();
            if (string == null) {
                string = ioe.toString();
            }
            LOGGER.error(string, (Throwable)ioe);
            return null;
        }
    }

    static {
        Logger logger = Logger.getInstance(CppExactVersionBasedLocator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/workspace/compiler/resolver/locators/CppExactVersionBasedLocator$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.clion.cmake"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

