/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion.contributors.providers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.CMakeLanguage;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.completion.contributors.providers.AbstractCMakeCompletionProvider;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cmake.settings.Case;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCMakeCaseSensitiveCompletionProvider
extends AbstractCMakeCompletionProvider {
    protected final List<String> myVariants;
    private final boolean myBoldCompletion;
    private final boolean myPutCaretInsideParentheses;

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords) {
        this(completionWords, false);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords, boolean boldCompletion) {
        this(completionWords, boldCompletion, true);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this(Arrays.asList(completionWords), boldCompletion, putCaretInsideParentheses);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(IElementType[] completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this(ContainerUtil.map((Object[])completionWords, type -> type.toString()), boldCompletion, putCaretInsideParentheses);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(List<String> completionWords) {
        this(completionWords, false, true);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(List<String> completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this.myVariants = completionWords;
        this.myBoldCompletion = boldCompletion;
        this.myPutCaretInsideParentheses = putCaretInsideParentheses;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(2);
        }
        CMakeCodeStyleSettings settings = (CMakeCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)parameters2.getOriginalFile(), CMakeCodeStyleSettings.class);
        Case keywordCase = Case.resolveByValue(AbstractCMakeCaseSensitiveCompletionProvider.getCaseVariableValue(settings));
        String stringToComplete = parameters2.getPosition().getText().replace("IntellijIdeaRulezzz", "");
        result2.restartCompletionOnAnyPrefixChange();
        CommonCodeStyleSettings commonSettings = CodeStyle.getLanguageSettings((PsiFile)parameters2.getOriginalFile(), (Language)CMakeLanguage.INSTANCE);
        result2.caseInsensitive().addAllElements((Iterable)ContainerUtil.map(this.myVariants, s -> CMakeCompletionUtils.createStandardCommandItem(AbstractCMakeCaseSensitiveCompletionProvider.getRightCase(stringToComplete, s, keywordCase), this.myBoldCompletion, this.myPutCaretInsideParentheses, Collections.emptyList(), commonSettings)));
    }

    @NotNull
    private static String getRightCase(@NotNull String strToComplete, @NotNull String variant, Case caseSetting) {
        if (strToComplete == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(3);
        }
        if (variant == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(4);
        }
        String string = switch (caseSetting) {
            default -> throw new IncompatibleClassChangeError();
            case Case.TO_UPPER -> StringUtil.toUpperCase((String)variant);
            case Case.TO_LOWER -> StringUtil.toLowerCase((String)variant);
            case Case.DO_NOT_CHANGE -> {
                if (!strToComplete.isEmpty() && StringUtil.startsWithIgnoreCase((String)variant, (String)strToComplete)) {
                    if (variant.startsWith(strToComplete)) {
                        yield variant;
                    }
                    if (AbstractCMakeCaseSensitiveCompletionProvider.checkCase(strToComplete, CharCase.UPPER, true)) {
                        yield StringUtil.toUpperCase((String)variant);
                    }
                    if (AbstractCMakeCaseSensitiveCompletionProvider.checkCase(strToComplete, CharCase.LOWER, true)) {
                        yield StringUtil.toLowerCase((String)variant);
                    }
                    yield variant;
                }
                yield variant;
            }
        };
        if (string == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean checkCase(@NotNull String str, CharCase charCase, boolean skipNonAlpha) {
        if (str == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!(!Character.isAlphabetic(str.charAt(i)) || Character.isDigit(str.charAt(i)) ? !skipNonAlpha : charCase == CharCase.LOWER && Character.isUpperCase(str.charAt(i)) || charCase == CharCase.UPPER && Character.isLowerCase(str.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private static int getCaseVariableValue(@NotNull CMakeCodeStyleSettings settings) {
        if (settings == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(7);
        }
        return settings.FORCE_COMMANDS_CASE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strToComplete";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/completion/contributors/providers/AbstractCMakeCaseSensitiveCompletionProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/completion/contributors/providers/AbstractCMakeCaseSensitiveCompletionProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRightCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRightCase";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkCase";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCaseVariableValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    static enum CharCase {
        LOWER,
        UPPER;

    }
}

