/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cmake.CMakeBundle;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u00012\u00020\u0002:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cmake/highlighting/CMakeArgumentWarningAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Companion", "intellij.cmake.psi"})
public final class CMakeArgumentWarningAnnotator
implements Annotator,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> usedCMakeNames;

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiElement command;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof CMakeArgument) || ((CMakeArgument)element).getCMakeLiteral() == null) {
            return;
        }
        PsiElement psiElement = ((CMakeArgument)element).getParent();
        Object object = command = psiElement != null ? psiElement.getParent() : null;
        if (!(command instanceof CMakeCommand)) {
            return;
        }
        String commandName = CMakePsiUtils.findCommandName((CMakeElement)command);
        if (Intrinsics.areEqual((Object)commandName, (Object)"add_executable") && Intrinsics.areEqual((Object)((CMakeCommand)command).getFirstArgument(), (Object)element)) {
            CMakeLiteral cMakeLiteral = ((CMakeArgument)element).getCMakeLiteral();
            if (usedCMakeNames.contains(StringUtil.toLowerCase((String)(cMakeLiteral != null ? cMakeLiteral.getText() : null)))) {
                Object[] objectArray = new Object[1];
                CMakeLiteral cMakeLiteral2 = ((CMakeArgument)element).getCMakeLiteral();
                objectArray[0] = cMakeLiteral2 != null ? cMakeLiteral2.getText() : null;
                holder.newAnnotation(HighlightSeverity.WARNING, CMakeBundle.message("cmake.command.arguments.mismatched.target", objectArray)).create();
            }
        }
    }

    static {
        Object[] objectArray = new String[]{".cmake", "cmakefiles", "testing", "ninja_deps", "ninja_log", "build.ninja", "cmake_install.cmake", "cmakecache.txt"};
        usedCMakeNames = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cmake/highlighting/CMakeArgumentWarningAnnotator$Companion;", "", "<init>", "()V", "usedCMakeNames", "", "", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

