/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.langSwitcher;

import com.intellij.clion.langSwitcher.CLionABTestLauncher;
import com.intellij.clion.langSwitcher.CLionABUsageCollector;
import com.intellij.clion.langSwitcher.CLionBackendEngineCounterCollector;
import com.intellij.clion.langSwitcher.CLionLangSwitcherBundle;
import com.intellij.clion.langSwitcher.CLionLanguagePluginKind;
import com.intellij.clion.langSwitcher.CLionLanguagePluginSwitcherService;
import com.intellij.clion.langSwitcher.CLionLanguagePluginSwitcherServiceKt;
import com.intellij.clion.langSwitcher.CLionPluginKindSwitcherBrokenInstallation;
import com.intellij.clion.langSwitcher.CLionPluginKindSwitcherNoVmOptions;
import com.intellij.clion.langSwitcher.CLionPluginKindSwitcherNotAllowedInDevBuild;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.InvalidateCacheService;
import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.idea.AppMode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.options.advanced.AdvancedSettingType;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.RegistryManager;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0002J,\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u001a\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001c0\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/clion/langSwitcher/CLionLanguagePluginSwitcherService;", "", "serviceCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "setUpAdvancedSettingsListener", "", "initialPlugin", "Lcom/intellij/clion/langSwitcher/CLionLanguagePluginKind;", "checkLanguagePluginState", "reportABTestIfNecessary", "syncSettingsIfNecessary", "setUpDisabledPluginsListener", "switchPlugin", "useRadler", "", "changeVMOptions", "suppressedSetId", "", "setOption", "file", "Ljava/nio/file/Path;", "prefix", "newValue", "setOptions", "_options", "", "Lcom/intellij/openapi/util/Pair;", "Companion", "intellij.clion.langSwitcher"})
@SourceDebugExtension(value={"SMAP\nCLionLanguagePluginSwitcherService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionLanguagePluginSwitcherService.kt\ncom/intellij/clion/langSwitcher/CLionLanguagePluginSwitcherService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,316:1\n83#2,2:317\n85#2:320\n1#3:319\n106#4:321\n78#4,22:322\n*S KotlinDebug\n*F\n+ 1 CLionLanguagePluginSwitcherService.kt\ncom/intellij/clion/langSwitcher/CLionLanguagePluginSwitcherService\n*L\n106#1:317,2\n106#1:320\n229#1:321\n229#1:322,22\n*E\n"})
public final class CLionLanguagePluginSwitcherService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope serviceCoroutineScope;
    @JvmField
    @NotNull
    public static final String CLION_USE_RADLER_ADVANCED_OPTION = "clion.use.radler";

    public CLionLanguagePluginSwitcherService(@NotNull CoroutineScope serviceCoroutineScope) {
        Intrinsics.checkNotNullParameter((Object)serviceCoroutineScope, (String)"serviceCoroutineScope");
        this.serviceCoroutineScope = serviceCoroutineScope;
        CLionLanguagePluginKind initialPlugin = CLionLanguagePluginKind.Companion.current();
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("Using " + initialPlugin.name() + " C/C++ language engine");
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("A/B test is " + (CLionABTestLauncher.INSTANCE.enabled() ? "on" : "off"));
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("isRemoteDevHost = " + AppMode.isRemoteDevHost());
        this.reportABTestIfNecessary();
        CLionBackendEngineCounterCollector.INSTANCE.logBackendState();
        this.syncSettingsIfNecessary(initialPlugin);
        this.checkLanguagePluginState(initialPlugin);
        this.setUpDisabledPluginsListener();
        this.setUpAdvancedSettingsListener(initialPlugin);
    }

    private final void setUpAdvancedSettingsListener(CLionLanguagePluginKind initialPlugin) {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(initialPlugin, this){
            final /* synthetic */ CLionLanguagePluginKind $initialPlugin;
            final /* synthetic */ CLionLanguagePluginSwitcherService this$0;
            {
                this.$initialPlugin = $initialPlugin;
                this.this$0 = $receiver;
            }

            public void advancedSettingChanged(String id, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                if (Intrinsics.areEqual((Object)id, (Object)CLionLanguagePluginSwitcherService.CLION_USE_RADLER_ADVANCED_OPTION)) {
                    if (AppMode.isDevServer()) {
                        boolean initialUseRadler;
                        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().warn("Switcher between language engines is not supported in dev mode!");
                        boolean bl = initialUseRadler = this.$initialPlugin == CLionLanguagePluginKind.Radler;
                        if (initialUseRadler != (Boolean)newValue) {
                            CLionLanguagePluginKind otherPlugin = CLionLanguagePluginKind.Companion.current().getOther();
                            Notifications.Bus.notify((Notification)new CLionPluginKindSwitcherNotAllowedInDevBuild(otherPlugin.getDevBuildRunConfiguration()), null);
                            AdvancedSettings.Companion.getInstance().setSetting(CLionLanguagePluginSwitcherService.CLION_USE_RADLER_ADVANCED_OPTION, (Object)initialUseRadler, AdvancedSettingType.Bool);
                        }
                    } else {
                        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("Switching to " + ((Boolean)newValue != false ? "Nova" : "Classic") + " language engine...");
                        CLionLanguagePluginSwitcherService.access$switchPlugin(this.this$0, (Boolean)newValue);
                    }
                }
            }
        });
    }

    private final void checkLanguagePluginState(CLionLanguagePluginKind initialPlugin) {
        String languagePluginError = CLionLanguagePluginSwitcherServiceKt.access$checkLanguagePluginEnabled(initialPlugin);
        if (languagePluginError != null) {
            String string = CLionLangSwitcherBundle.message("clion.plugin.switcher.repair.ide", new Object[0]);
            NotificationAction repairAction2 = new NotificationAction(initialPlugin, string){
                final /* synthetic */ CLionLanguagePluginKind $initialPlugin;
                {
                    this.$initialPlugin = $initialPlugin;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e, Notification notification) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    notification.expire();
                    CLionLanguagePluginSwitcherServiceKt.access$filterSavedDisabledPlugins(this.$initialPlugin);
                    ApplicationManager.getApplication().invokeLater(checkLanguagePluginState.repairAction.1::actionPerformed$lambda$0, ModalityState.nonModal());
                }

                private static final void actionPerformed$lambda$0() {
                    RegistryBooleanOptionDescriptor.suggestRestart(null);
                }
            };
            CLionPluginKindSwitcherBrokenInstallation notification = new CLionPluginKindSwitcherBrokenInstallation(languagePluginError);
            notification.addAction((AnAction)repairAction2);
            Notifications.Bus.notify((Notification)notification, null);
        }
    }

    private final void reportABTestIfNecessary() {
        Object object;
        Logger $this$runAndLogException$iv = CLionLanguagePluginSwitcherServiceKt.access$getLOG$p();
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Path markerFile = CLionABTestLauncher.INSTANCE.getMarkerFilePath();
            if (!ConfigImportHelper.isFirstSession()) {
                Files.deleteIfExists(markerFile);
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(markerFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    Object v2;
                    block7: {
                        List<String> list = Files.readAllLines(markerFile, Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                        String selectedPluginName = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first(list)))).toString();
                        Iterable iterable = (Iterable)CLionLanguagePluginKind.getEntries();
                        for (Object t : iterable) {
                            CLionLanguagePluginKind it = (CLionLanguagePluginKind)((Object)t);
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.name(), (Object)selectedPluginName)) continue;
                            v2 = t;
                            break block7;
                        }
                        v2 = null;
                    }
                    CLionLanguagePluginKind cLionLanguagePluginKind = v2;
                    if (cLionLanguagePluginKind != null) {
                        CLionLanguagePluginKind selectedPlugin = cLionLanguagePluginKind;
                        CLionABUsageCollector.INSTANCE.logUsage(selectedPlugin);
                        Files.deleteIfExists(markerFile);
                    }
                }
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private final void syncSettingsIfNecessary(CLionLanguagePluginKind initialPlugin) {
        boolean initialUseRadler = initialPlugin == CLionLanguagePluginKind.Radler;
        BuildersKt.launch$default((CoroutineScope)this.serviceCoroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(initialUseRadler, null){
            Object L$0;
            int label;
            final /* synthetic */ boolean $initialUseRadler;
            {
                this.$initialUseRadler = $initialUseRadler;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = RegistryManager.Companion.getInstanceAsync((Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        instanceAsync = (RegistryManager)v0;
                        this.L$0 = instanceAsync;
                        this.label = 2;
                        v1 = instanceAsync.awaitRegistryLoad((Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        instanceAsync = (RegistryManager)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        instanceAsync.get("cache.folding.model.on.disk").setValue(this.$initialUseRadler == false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (initialUseRadler != AdvancedSettings.Companion.getBoolean(CLION_USE_RADLER_ADVANCED_OPTION)) {
            AdvancedSettings.Companion.getInstance().setSetting(CLION_USE_RADLER_ADVANCED_OPTION, (Object)initialUseRadler, AdvancedSettingType.Bool);
            CLionBackendEngineCounterCollector.INSTANCE.logSwitch(initialPlugin);
        }
    }

    private final void setUpDisabledPluginsListener() {
        DisabledPluginsState.Companion.addDisablePluginListener(CLionLanguagePluginSwitcherService::setUpDisabledPluginsListener$lambda$2);
    }

    private final void switchPlugin(boolean useRadler) {
        CLionLanguagePluginKind newPluginKind;
        CLionLanguagePluginKind cLionLanguagePluginKind = newPluginKind = useRadler ? CLionLanguagePluginKind.Radler : CLionLanguagePluginKind.Classic;
        if (!this.changeVMOptions(newPluginKind.getSuppressedSetId())) {
            Notifications.Bus.notify((Notification)new CLionPluginKindSwitcherNoVmOptions(), null);
            return;
        }
        CLionBackendEngineCounterCollector.INSTANCE.logSwitch(newPluginKind);
        CLionLanguagePluginSwitcherServiceKt.access$filterSavedDisabledPlugins(newPluginKind);
        boolean showRestartDialog = CLionLanguagePluginSwitcherServiceKt.getSHOW_RESTART_DIALOG_ON_SWITCH();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ApplicationEx app = (ApplicationEx)application;
        Runnable invalidateCachesAndRestart = () -> CLionLanguagePluginSwitcherService.switchPlugin$lambda$5(showRestartDialog, app);
        app.invokeLater(invalidateCachesAndRestart, ModalityState.nonModal());
    }

    private final boolean changeVMOptions(String suppressedSetId) {
        Path userOptionsFile;
        boolean wasOptionSet = false;
        boolean isRemoteMode = AppMode.isRemoteDevHost();
        Path path = VMOptions.getUserOptionsFile();
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("changing VM options, isRemoteDevHost = " + isRemoteMode + ", platform vmoptions file = " + VMOptions.getPlatformOptionsFile() + ", user vmoptions file = " + (path != null ? (Comparable)path : (Comparable)((Object)"<no file>")));
        if (isRemoteMode) {
            CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("setting -Didea.suppressed.plugins.set.selector=" + suppressedSetId + " to " + VMOptions.getPlatformOptionsFile());
            Path path2 = VMOptions.getPlatformOptionsFile();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPlatformOptionsFile(...)");
            this.setOption(path2, "-Didea.suppressed.plugins.set.selector=", suppressedSetId);
            wasOptionSet = true;
        }
        if ((userOptionsFile = VMOptions.getUserOptionsFile()) == null) {
            CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("skipping setting of -Didea.suppressed.plugins.set.selector=" + suppressedSetId + " to user vmoptions file because there is no such file");
            return wasOptionSet;
        }
        CLionLanguagePluginSwitcherServiceKt.access$getLOG$p().info("setting -Didea.suppressed.plugins.set.selector=" + suppressedSetId + " to " + userOptionsFile);
        this.setOption(userOptionsFile, "-Didea.suppressed.plugins.set.selector=", suppressedSetId);
        return true;
    }

    private final void setOption(Path file, String prefix, String newValue) {
        this.setOptions(file, CollectionsKt.listOf((Object)new Pair((Object)prefix, (Object)newValue)));
    }

    private final void setOptions(Path file, List<? extends Pair<String, String>> _options) {
        List lines = Files.exists(file, new LinkOption[0]) ? (List)new ArrayList(Files.readAllLines(file, VMOptions.getFileCharset())) : (List)new ArrayList();
        List options = new ArrayList(_options);
        boolean modified = false;
        ListIterator<CallSite> il = lines.listIterator(lines.size());
        block0: while (il.hasPrevious()) {
            String $this$trim$iv = (String)il.previous();
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Iterator io = options.iterator();
            while (io.hasNext()) {
                Pair option = (Pair)io.next();
                Object object = option.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
                if (!StringsKt.startsWith$default((String)line, (String)((String)object), (boolean)false, (int)2, null)) continue;
                if (option.second == null) {
                    il.remove();
                    modified = true;
                    continue block0;
                }
                String newLine = "" + option.first + option.second;
                if (!Intrinsics.areEqual((Object)newLine, (Object)line)) {
                    il.set((CallSite)((Object)newLine));
                    modified = true;
                }
                io.remove();
                continue block0;
            }
        }
        for (Pair option : options) {
            if (option.second == null) continue;
            lines.add("" + option.first + option.second);
            modified = true;
        }
        if (modified) {
            NioFiles.createDirectories((Path)file.getParent());
            Files.write(file, (Iterable<? extends CharSequence>)lines, VMOptions.getFileCharset(), new OpenOption[0]);
        }
    }

    private static final void setUpDisabledPluginsListener$lambda$2() {
        CLionLanguagePluginKind currentPluginKind = CLionLanguagePluginKind.Companion.current();
        CLionLanguagePluginSwitcherServiceKt.access$filterSavedDisabledPlugins(currentPluginKind);
    }

    private static final boolean switchPlugin$lambda$5$lambda$3(CachesInvalidator it) {
        return it.getDescription() == null;
    }

    private static final boolean switchPlugin$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void switchPlugin$lambda$5(boolean $showRestartDialog, ApplicationEx $app) {
        InvalidateCacheService.invalidateCaches(arg_0 -> CLionLanguagePluginSwitcherService.switchPlugin$lambda$5$lambda$4(CLionLanguagePluginSwitcherService::switchPlugin$lambda$5$lambda$3, arg_0));
        if ($showRestartDialog) {
            RegistryBooleanOptionDescriptor.suggestRestart(null);
        } else {
            $app.restart(true);
        }
    }

    public static final /* synthetic */ void access$switchPlugin(CLionLanguagePluginSwitcherService $this, boolean useRadler) {
        $this.switchPlugin(useRadler);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/clion/langSwitcher/CLionLanguagePluginSwitcherService$Companion;", "", "<init>", "()V", "CLION_USE_RADLER_ADVANCED_OPTION", "", "intellij.clion.langSwitcher"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

