/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsPanel;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CPPToolchainsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
Disposable {
    public static final Topic<Listener> TOPIC = Topic.create((String)"Toolchain editor topic", Listener.class);
    private static final String HAD_INITIAL_CONFIG = "clion.initialConfigPerformed";
    @NonNls
    public static final String ID = "CPPToolchains";
    private CPPToolchainsPanel myPanel;
    private int myPreselectedToolchain;

    @NotNull
    public String getId() {
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return CPPToolchainsConfigurable.getName();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.cl.toolchains";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new CPPToolchainsPanel(this, this.myPreselectedToolchain);
            this.myPanel.autoRecheckWithApplication();
            CPPToolchainsConfigurable.markHadInitialConfiguration();
        }
        return this.myPanel;
    }

    public static void markHadInitialConfiguration() {
        PropertiesComponent.getInstance().setValue(HAD_INITIAL_CONFIG, true);
    }

    public static boolean hadInitialConfiguration() {
        return PropertiesComponent.getInstance().getBoolean(HAD_INITIAL_CONFIG);
    }

    @Nullable
    public CPPToolchainsPanel getPanelIfInitialized() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myPanel.isModified(CPPToolchains.getInstance());
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply(CPPToolchains.getInstance(), false);
    }

    public void reset() {
        if (this.myPanel != null) {
            this.myPanel.reset(CPPToolchains.getInstance());
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
        this.myPanel = null;
    }

    public void dispose() {
    }

    public void setPreselectedToolchain(int preselectedToolchain) {
        this.myPreselectedToolchain = preselectedToolchain;
    }

    private void setPreselectedToolchainName(@Nullable String toolchainName) {
        if (toolchainName == null) {
            return;
        }
        List<CPPToolchains.Toolchain> toolchains = CPPToolchains.getInstance().getToolchains();
        for (int i = 0; i < toolchains.size(); ++i) {
            if (!toolchains.get(i).getName().equals(toolchainName)) continue;
            this.myPreselectedToolchain = i;
            return;
        }
    }

    public void setSelectedToolchain(@Nullable String toolchainName) {
        if (this.myPanel != null) {
            this.myPanel.selectToolchain(toolchainName);
        } else {
            this.setPreselectedToolchainName(toolchainName);
        }
    }

    @NlsContexts.ConfigurableName
    public static String getName() {
        return ToolchainsBundle.message("cpp.toolchains", new Object[0]);
    }

    public static interface Listener {
        public void toolchainsChanged(@NotNull List<CPPToolchains.Toolchain> var1, @NotNull List<Pair<String, String>> var2);

        public void toolchainRenamed(int var1, @NotNull String var2);

        public void toolchainsApplied() throws ConfigurationException;
    }
}

