/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.PathMapper;
import com.jetbrains.cidr.cpp.toolchains.RemoteHostService;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelper;
import com.jetbrains.cidr.cpp.toolchains.wsl.CLionWSLHost;
import com.jetbrains.cidr.system.HostData;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.cidr.system.PathMapperWrapper;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHost;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.toolchains.SettingsHandler;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLDistribution;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J8\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/HostFactory;", "", "<init>", "()V", "createLocalHost", "Lcom/jetbrains/cidr/system/LocalHost;", "createWslHost", "Lcom/jetbrains/cidr/cpp/toolchains/wsl/CLionWSLHost;", "toolSet", "Lcom/jetbrains/cidr/cpp/toolchains/WSL;", "createOrGetRemoteHost", "Lcom/jetbrains/cidr/system/RemoteHost;", "hostData", "Lcom/jetbrains/cidr/system/HostData;", "toolchainName", "", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/io/File;", "cacheDirectory", "Ljava/nio/file/Path;", "createOrGetDockerHost", "Lcom/jetbrains/cidr/system/HostMachine;", "dockerHandler", "Lcom/jetbrains/cidr/toolchains/SettingsHandler;", "intellij.clion.toolchains"})
public final class HostFactory {
    @NotNull
    public static final HostFactory INSTANCE = new HostFactory();

    private HostFactory() {
    }

    @JvmStatic
    @NotNull
    public static final LocalHost createLocalHost() {
        LocalHost localHost = LocalHost.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)localHost, (String)"INSTANCE");
        return localHost;
    }

    @JvmStatic
    @NotNull
    public static final CLionWSLHost createWslHost(@NotNull WSL toolSet) {
        Intrinsics.checkNotNullParameter((Object)toolSet, (String)"toolSet");
        CidrWSLDistribution cidrWSLDistribution = toolSet.getDelegate();
        Intrinsics.checkNotNullExpressionValue((Object)cidrWSLDistribution, (String)"getDelegate(...)");
        return new CLionWSLHost(cidrWSLDistribution);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RemoteHost createOrGetRemoteHost(@NotNull HostData hostData, @NotNull String toolchainName, @Nullable Project project, @Nullable File projectDir, @Nullable Path cacheDirectory) {
        RemoteHost remoteHost;
        Intrinsics.checkNotNullParameter((Object)hostData, (String)"hostData");
        Intrinsics.checkNotNullParameter((Object)toolchainName, (String)"toolchainName");
        String hostId = hostData.getId();
        SshConfig sshConfig = hostData.getSshConfig();
        Intrinsics.checkNotNullExpressionValue((Object)sshConfig, (String)"getSshConfig(...)");
        SshConfig sshConfig2 = sshConfig;
        if (hostId != null && !RemoteDeploymentHelper.isDeploymentConfigAvailable(hostId)) {
            RemoteDeploymentHelper.updateRemoteHost(hostId, toolchainName, sshConfig2);
        }
        OSType osType = OSType.LINUX;
        PathMapper pathMapper = RemoteDeploymentHelper.getOrCreatePathMapper(hostId, sshConfig2, project, projectDir);
        Intrinsics.checkNotNullExpressionValue((Object)pathMapper, (String)"getOrCreatePathMapper(...)");
        PathMapper mapper = pathMapper;
        PathMapper pathMapper2 = PathMapperWrapper.wrapOnWindows((PathMapper)mapper);
        if (Registry.Companion.is("clion.remote.cache.hosts")) {
            RemoteHostService remoteHostService = RemoteHostService.Companion.getInstance();
            Intrinsics.checkNotNull((Object)pathMapper2);
            remoteHost = remoteHostService.computeIfAbsent(project, hostData, projectDir, pathMapper2, (Function0<? extends RemoteHost>)((Function0)() -> HostFactory.createOrGetRemoteHost$lambda$0(hostId, sshConfig2, osType, pathMapper2, project, cacheDirectory)));
        } else {
            remoteHost = new RemoteHost(hostId, sshConfig2, osType, pathMapper2, project, cacheDirectory);
        }
        return remoteHost;
    }

    public static /* synthetic */ RemoteHost createOrGetRemoteHost$default(HostData hostData, String string, Project project, File file, Path path, int n, Object object) {
        if ((n & 0x10) != 0) {
            path = null;
        }
        return HostFactory.createOrGetRemoteHost(hostData, string, project, file, path);
    }

    @JvmStatic
    @NotNull
    public static final HostMachine createOrGetDockerHost(@NotNull SettingsHandler dockerHandler, @NotNull String toolchainName, @Nullable Project project, @Nullable File projectDir) {
        VirtualFile guess;
        Intrinsics.checkNotNullParameter((Object)dockerHandler, (String)"dockerHandler");
        Intrinsics.checkNotNullParameter((Object)toolchainName, (String)"toolchainName");
        File dir = projectDir;
        if (dir == null && project != null && (guess = ProjectUtil.guessProjectDir((Project)project)) != null) {
            dir = guess.toNioPath().toFile();
        }
        HostMachine hostMachine = DockerHelper.getInstance().createOrGetHostMachine(dockerHandler, dir, toolchainName, project);
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"createOrGetHostMachine(...)");
        return hostMachine;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RemoteHost createOrGetRemoteHost(@NotNull HostData hostData, @NotNull String toolchainName, @Nullable Project project, @Nullable File projectDir) {
        Intrinsics.checkNotNullParameter((Object)hostData, (String)"hostData");
        Intrinsics.checkNotNullParameter((Object)toolchainName, (String)"toolchainName");
        return HostFactory.createOrGetRemoteHost$default(hostData, toolchainName, project, projectDir, null, 16, null);
    }

    private static final RemoteHost createOrGetRemoteHost$lambda$0(String $hostId, SshConfig $sshConfig, OSType $osType, PathMapper $pathMapper, Project $project, Path $cacheDirectory) {
        return new RemoteHost($hostId, $sshConfig, $osType, $pathMapper, $project, $cacheDirectory);
    }
}

