/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.SystemUtil;
import com.jetbrains.cidr.system.downloading.Downloader;
import com.jetbrains.cidr.system.downloading.RemoteFSCacheDownloadService;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoteFSCache {
    @NotNull
    private final File myCacheDirectory;
    @NotNull
    private final PathMapper myPathMapper;
    @NotNull
    private final Downloader myDownloader;
    @NotNull
    private final HostMachine myHost;
    @NotNull
    private final PathMappingSettings myCacheMapper;
    @NotNull
    private static final String INVALIDATED_MARKER = new String(".clion.cache.invalidated");
    private static final String INVALIDATED_POSTFIX = new String(".nonvalid");
    @NotNull
    private final RemoteFSCacheDownloadService myDownloadService;
    @NotNull
    private final @NotNull SLRUMap<@NotNull String, @NotNull String> mySymlinkCache;

    public RemoteFSCache(@NotNull File directory, @NotNull PathMapper mapper, @NotNull Downloader downloader, @NotNull HostMachine host) {
        if (directory == null) {
            RemoteFSCache.$$$reportNull$$$0(0);
        }
        if (mapper == null) {
            RemoteFSCache.$$$reportNull$$$0(1);
        }
        if (downloader == null) {
            RemoteFSCache.$$$reportNull$$$0(2);
        }
        if (host == null) {
            RemoteFSCache.$$$reportNull$$$0(3);
        }
        this.myDownloadService = (RemoteFSCacheDownloadService)ApplicationManager.getApplication().getService(RemoteFSCacheDownloadService.class);
        this.mySymlinkCache = new SLRUMap(10000, 10000);
        this.myCacheDirectory = directory;
        this.myPathMapper = mapper;
        this.myDownloader = downloader;
        this.myHost = host;
        this.myCacheMapper = new PathMappingSettings(Collections.singletonList(new PathMappingSettings.PathMapping(this.myCacheDirectory.getAbsolutePath(), "/")));
        this.handlePossibleCacheInvalidation();
        FileUtil.createDirectory((File)this.myCacheDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePossibleCacheInvalidation() {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        Path cacheDirectoryPath = this.myCacheDirectory.toPath();
        Path invalidatedMarker = cacheDirectoryPath.resolve(INVALIDATED_MARKER);
        if (Files.exists(invalidatedMarker, new LinkOption[0])) {
            try {
                Path invalidatedCachePath = cacheDirectoryPath.resolveSibling(cacheDirectoryPath.getFileName().toString() + INVALIDATED_POSTFIX);
                Files.move(cacheDirectoryPath, invalidatedCachePath, new CopyOption[0]);
                FileUtil.asyncDelete((File)invalidatedCachePath.toFile());
            }
            catch (IOException e) {
                RemoteHostUtil.LOG.warn("Failed to move invalidated cache", (Throwable)e);
                try {
                    FileUtilRt.deleteRecursively((Path)cacheDirectoryPath);
                }
                catch (IOException ex) {
                    RemoteHostUtil.LOG.warn("Failed to delete invalidated cache, bailing out", (Throwable)e);
                }
            }
            finally {
                if (Files.exists(invalidatedMarker, new LinkOption[0])) {
                    try {
                        Files.delete(invalidatedMarker);
                    }
                    catch (IOException e) {
                        RemoteHostUtil.LOG.warn("Failed to delete invalidation marker, bailing out", (Throwable)e);
                    }
                }
            }
        }
    }

    PathMapper getCacheMapper() {
        return this.myCacheMapper;
    }

    @NotNull
    public File getCacheDirectory() {
        File file = this.myCacheDirectory;
        if (file == null) {
            RemoteFSCache.$$$reportNull$$$0(4);
        }
        return file;
    }

    public void invalidateCache() {
        FileUtil.asyncDelete((File)this.myCacheDirectory);
        this.myDownloadService.invalidate();
    }

    public void markInvalidated() {
        FileUtilRt.createIfNotExists((File)this.myCacheDirectory.toPath().resolve(INVALIDATED_MARKER).toFile());
    }

    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> remotePaths) {
        if (remotePaths == null) {
            RemoteFSCache.$$$reportNull$$$0(5);
        }
        long start = System.currentTimeMillis();
        List<String> result = this.optimiseAndResolveAndCache(remotePaths);
        if (RemoteHostUtil.LOG.isTraceEnabled()) {
            RemoteHostUtil.LOG.trace("RemoteHost: resolveAndCache took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - start)));
        }
        List<String> list = result;
        if (list == null) {
            RemoteFSCache.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<String> optimiseAndResolveAndCache(@NotNull List<String> remotePaths) {
        if (remotePaths == null) {
            RemoteFSCache.$$$reportNull$$$0(7);
        }
        if (remotePaths.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RemoteFSCache.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<String> paths = SystemUtil.removeRedundant(remotePaths);
        for (String path : paths) {
            this.resolveAndCache(path);
        }
        ArrayList<String> result = new ArrayList<String>(remotePaths.size());
        for (String remotePath : remotePaths) {
            String localPath = this.myPathMapper.canReplaceRemote(remotePath) ? this.myPathMapper.convertToLocal(remotePath) : String.valueOf(RemoteFSCacheDownloadService.toLocalPath(remotePath, this.myCacheDirectory));
            result.add(localPath);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LocalFileSystem.getInstance().refreshIoFiles((Iterable)ContainerUtil.map(result, p -> new File((String)p)));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            RemoteFSCache.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private void resolveAndCache(@NotNull @NlsSafe String remotePath) {
        Optional<Path> cachedPath;
        if (remotePath == null) {
            RemoteFSCache.$$$reportNull$$$0(10);
        }
        if ((cachedPath = this.myDownloadService.get(this.myHost, remotePath)) != null) {
            return;
        }
        if (this.myPathMapper.canReplaceRemote(remotePath)) {
            return;
        }
        this.myDownloadService.download(remotePath, this.myHost, this.myDownloader, this.myCacheDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public @NotNull String @NotNull [] toCanonicalPathAndResolveSymlink(@NotNull List<@NonNls String> paths) {
        int i;
        if (paths == null) {
            RemoteFSCache.$$$reportNull$$$0(11);
        }
        String[] result = new String[paths.size()];
        LinkedHashMap<Integer, String> nonResolvedPaths = new LinkedHashMap<Integer, String>();
        SLRUMap<String, String> sLRUMap = this.mySymlinkCache;
        synchronized (sLRUMap) {
            for (i = 0; i < paths.size(); ++i) {
                String path = paths.get(i);
                String cachedPath = (String)this.mySymlinkCache.get((Object)path);
                if (cachedPath != null) {
                    result[i] = cachedPath;
                    continue;
                }
                nonResolvedPaths.put(i, path);
            }
        }
        if (nonResolvedPaths.isEmpty()) {
            if (result == null) {
                RemoteFSCache.$$$reportNull$$$0(12);
            }
            return result;
        }
        String[] resolvedPaths = RemoteHostUtil.resolveSymlink((HostMachine)this.myHost, (Collection)ContainerUtil.map(nonResolvedPaths.values(), p -> this.myPathMapper.convertToRemote(p)));
        i = 0;
        Set entries = nonResolvedPaths.entrySet();
        assert (resolvedPaths.length == entries.size());
        for (Map.Entry entry : entries) {
            String resolvedPath;
            int idx = (Integer)entry.getKey();
            String unresolvedPath = (String)entry.getValue();
            result[idx] = resolvedPath = resolvedPaths[i];
            SLRUMap<String, String> sLRUMap2 = this.mySymlinkCache;
            synchronized (sLRUMap2) {
                this.mySymlinkCache.put((Object)unresolvedPath, (Object)resolvedPath);
            }
            ++i;
        }
        if (result == null) {
            RemoteFSCache.$$$reportNull$$$0(13);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 8, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteFSCache";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePaths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteFSCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndCache";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "optimiseAndResolveAndCache";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toCanonicalPathAndResolveSymlink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "optimiseAndResolveAndCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPathAndResolveSymlink";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 8, 9, 12, 13 -> new IllegalStateException(string);
        };
    }
}

