/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.system.DecompressorErrorHandler;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class TarUtil {
    @TestOnly
    @NotNull
    public static String tar(@NotNull HostMachine host, @NotNull String directoryPath, boolean syncOnlyTextFiles) throws IOException {
        if (host == null) {
            TarUtil.$$$reportNull$$$0(0);
        }
        if (directoryPath == null) {
            TarUtil.$$$reportNull$$$0(1);
        }
        return TarUtil.tar(host, directoryPath, syncOnlyTextFiles, false, false);
    }

    @NotNull
    public static String tar(@NotNull HostMachine host, @NotNull String directoryPath, boolean syncOnlyTextFiles, boolean usePigz, boolean useAbsolutePaths) throws IOException {
        String string;
        block9: {
            if (host == null) {
                TarUtil.$$$reportNull$$$0(2);
            }
            if (directoryPath == null) {
                TarUtil.$$$reportNull$$$0(3);
            }
            Path fileListPath = null;
            try {
                if (syncOnlyTextFiles) {
                    fileListPath = Files.createTempFile(host.getTempDirectory(), "fileList", "txt", new FileAttribute[0]);
                    fileListPath = RemoteUtil.filterTextFiles(host, directoryPath, fileListPath, useAbsolutePaths, true);
                }
                String archivePath = CidrToolsUtil.generateTempFileName((HostMachine)host) + ".tar.gz";
                boolean isDereferenceEnabled = Registry.is((String)"clion.remote.tar.dereference", (boolean)false);
                TarUtil.tar(host, archivePath, directoryPath, isDereferenceEnabled, fileListPath, usePigz, useAbsolutePaths);
                string = archivePath;
                if (fileListPath == null) break block9;
            }
            catch (ExecutionException e) {
                try {
                    throw e.toIOException();
                }
                catch (Throwable throwable) {
                    if (fileListPath != null) {
                        FileUtil.delete(fileListPath);
                    }
                    throw throwable;
                }
            }
            FileUtil.delete((Path)fileListPath);
        }
        String string2 = string;
        if (string2 == null) {
            TarUtil.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static void tar(@NotNull HostMachine host, @NotNull String archiveName, @NotNull String directoryPath, boolean isDereferenceEnabled, @Nullable Path fileListPath, boolean usePigz, boolean useAbsolutePaths) throws ExecutionException {
        if (host == null) {
            TarUtil.$$$reportNull$$$0(5);
        }
        if (archiveName == null) {
            TarUtil.$$$reportNull$$$0(6);
        }
        if (directoryPath == null) {
            TarUtil.$$$reportNull$$$0(7);
        }
        ProgressManager.checkCanceled();
        CidrToolsUtil.assertUnixOnly((OS)host.getOS());
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: tar: " + directoryPath + " -> " + archiveName);
        }
        GeneralCommandLine command = new GeneralCommandLine(new String[]{"tar"});
        command.addParameter("-c");
        if (usePigz && Registry.is((String)"clion.remote.tar.use.pigz")) {
            command.addParameters(new String[]{"-I", "pigz"});
        } else {
            command.addParameter("-z");
        }
        command.addParameter(isDereferenceEnabled ? "-hPf" : "-Pf");
        command.addParameter(archiveName);
        if (isDereferenceEnabled) {
            command.addParameter("--hard-dereference");
        }
        command.setWorkDirectory(directoryPath);
        if (fileListPath != null) {
            command.addParameter("--files-from=" + String.valueOf(fileListPath));
        } else {
            command.addParameter(useAbsolutePaths ? directoryPath : ".");
        }
        int tarTimeout = Registry.intValue((String)"clion.remote.tar.timeout", (int)240000);
        ProcessOutput output = host.runProcess(command, tarTimeout);
        if (output.isTimeout()) {
            throw new ExecutionException(ToolchainsBundle.message("dialog.message.timeout", directoryPath));
        }
        if (output.getExitCode() != 0) {
            RemoteHostUtil.LOG.warn(directoryPath + ": " + output.getExitCode() + ", " + output.getStderr());
        }
    }

    public static boolean decompress(@NotNull File archive, @NotNull File outputDir) throws IOException {
        if (archive == null) {
            TarUtil.$$$reportNull$$$0(8);
        }
        if (outputDir == null) {
            TarUtil.$$$reportNull$$$0(9);
        }
        try {
            return TarUtil.decompressInternal(archive, outputDir);
        }
        catch (IOException e) {
            throw new IOException(ToolchainsBundle.message("remote.decompressor.error", new Object[0]), e);
        }
    }

    private static boolean decompressInternal(@NotNull File archive, @NotNull File outputDir) throws IOException {
        if (archive == null) {
            TarUtil.$$$reportNull$$$0(10);
        }
        if (outputDir == null) {
            TarUtil.$$$reportNull$$$0(11);
        }
        ArrayList linksForPostProcessing = new ArrayList();
        DecompressorErrorHandler errorHandler = new DecompressorErrorHandler();
        new Decompressor.Tar(archive).overwrite(false).escapingSymlinkPolicy(Decompressor.EscapingSymlinkPolicy.RELATIVIZE_ABSOLUTE).entryFilter(entry -> {
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (indicator != null && indicator.isCanceled()) {
                return false;
            }
            if (SystemInfo.isWindows && entry.linkTarget != null) {
                linksForPostProcessing.add(entry);
                return false;
            }
            return true;
        }).errorHandler((entry, ioException) -> errorHandler.handleError((Decompressor.Entry)entry, (IOException)ioException)).extract(outputDir);
        boolean aborted = errorHandler.abortSelected();
        if (!aborted && SystemInfo.isWindows) {
            for (Decompressor.Entry entry2 : linksForPostProcessing) {
                if (entry2.linkTarget == null) continue;
                String relativeLinkTarget = OSAgnosticPathUtil.isAbsolute((String)entry2.linkTarget) ? entry2.linkTarget.substring(1) : TarUtil.resolveLinkTarget(entry2.name, entry2.linkTarget);
                Path absoluteLinkTarget = outputDir.toPath().resolve(relativeLinkTarget).toAbsolutePath();
                try {
                    Path outputFile = Decompressor.entryFile((Path)outputDir.toPath(), (String)entry2.name);
                    if (Files.isRegularFile(absoluteLinkTarget, new LinkOption[0])) {
                        Path outputParent = outputFile.getParent();
                        if (!Files.exists(outputParent, new LinkOption[0])) {
                            Files.createDirectories(outputParent, new FileAttribute[0]);
                        }
                        Files.copy(absoluteLinkTarget, outputFile, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    TarUtil.createWinJunctionDirectory(outputFile, absoluteLinkTarget.toString());
                }
                catch (ExecutionException | IOException e) {
                    RemoteHostUtil.LOG.error("Cannot extract symbolic link", e);
                    RemoteUtil.NOTIFICATION_GROUP.createNotification(ToolchainsBundle.message("remote.decompressor.error", new Object[0]), ToolchainsBundle.message("remote.decompressor.error.cant.extract.symbolic.link", new Object[0]), NotificationType.WARNING).notify(null);
                }
            }
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteHost: decompression finished -> " + String.valueOf(outputDir));
        }
        return !aborted;
    }

    @NotNull
    private static String resolveLinkTarget(@NotNull String entryName, @NotNull String linkTarget) {
        File entryParent;
        if (entryName == null) {
            TarUtil.$$$reportNull$$$0(12);
        }
        if (linkTarget == null) {
            TarUtil.$$$reportNull$$$0(13);
        }
        if ((entryParent = new File(entryName).getParentFile()) == null) {
            String string = linkTarget;
            if (string == null) {
                TarUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = FileUtil.join((String[])new String[]{entryParent.toString(), linkTarget});
        if (string == null) {
            TarUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public static void createWinJunctionDirectory(@NotNull Path outputFile, String linkTarget) throws IOException, ExecutionException {
        if (outputFile == null) {
            TarUtil.$$$reportNull$$$0(16);
        }
        Path wd = outputFile.getParent();
        Files.createDirectories(wd, new FileAttribute[0]);
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"cmd", "/C", "mklink", "/J", outputFile.toString(), FileUtil.toSystemDependentName((String)linkTarget)});
        cmd.setWorkDirectory(wd.toString());
        ProcessOutput output = new CapturingProcessHandler(cmd).runProcess();
        output.checkSuccess(RemoteHostUtil.LOG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 4: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/TarUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveName";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkTarget";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/TarUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tar";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLinkTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tar";
                break;
            }
            case 4: 
            case 14: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "decompress";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "decompressInternal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveLinkTarget";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createWinJunctionDirectory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 14, 15 -> new IllegalStateException(string);
        };
    }
}

