/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.cli.AsyncCliProcess;
import com.intellij.docker.agent.cli.Cli;
import com.intellij.docker.agent.cli.DockerCli;
import com.intellij.docker.agent.cli.ProcessResult;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeDeserializer;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBase;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.agent.util.ComposeVersion;
import com.intellij.docker.agent.util.DockerComposeData;
import com.intellij.docker.agent.util.DockerComposeUtilsKt;
import com.intellij.docker.agent.util.DockerComposeVersion;
import com.intellij.docker.agent.util.InternalUtilsKt;
import com.intellij.docker.agent.util.Platform;
import com.intellij.docker.agent.util.PodmanComposeVersion;
import com.intellij.docker.agent.util.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u0017H\u0007\u001a(\u0010\u0018\u001a\u00020\u0019*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0087@\u00a2\u0006\u0002\u0010\u001e\u001a\f\u0010 \u001a\u0004\u0018\u00010\u0017*\u00020!\u001a\u0018\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001H\u0002\u001a\u0012\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010&\u001a\u00020\u0001H\u0002\u001a\n\u0010'\u001a\u00020(*\u00020)\u001a\n\u0010'\u001a\u00020(*\u00020*\u001a\u0014\u0010+\u001a\u0004\u0018\u00010\u00012\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0007\u001a4\u0010+\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010-2\u0018\u0010.\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010-H\u0007\u001a)\u0010+\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u001d2\u0010\u0010/\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u001dH\u0007\u00a2\u0006\u0002\u00100\u001a\u001c\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\r2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u001a\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u00103\u001a\u00020\u0001\u001a\u0010\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0016H\u0002\u001a\u000e\u00106\u001a\u00020\u00012\u0006\u00107\u001a\u00020\u0016\u001a\u0018\u00108\u001a\u0004\u0018\u00010\u00162\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\r\u001a8\u0010:\u001a\u0004\u0018\u00010\u00012\b\u0010;\u001a\u0004\u0018\u00010\u00012\u000e\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\r2\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010-\u001a2\u0010:\u001a\u0004\u0018\u00010\u00012\b\u0010;\u001a\u0004\u0018\u00010\u00012\b\u0010<\u001a\u0004\u0018\u00010\u00162\u0014\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010-\u001a\u000e\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020\u0001\u001a\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020\u0001H\u0002\u001a@\u0010A\u001a\u00020B*\u00020\u001b2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00010D2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010\u00012\u0012\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001d\"\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010G\u001a\u0016\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020I0-*\u00020J\u001a\u0010\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015*\u00020J\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0010\u0010\u0010\u001a\u00020\u00018\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0011\u001a\u00020\u00018\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0012\u001a\u00020\u00018\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"COMPOSE_SERVICE_LABEL_KEY", "", "COMPOSE_PROJECT_LABEL_KEY", "COMPOSE_FILES_LABEL_KEY", "COMPOSE_WORKING_DIR_LABEL_KEY", "DOCKER_COMPOSE_VERSION_LABEL_KEY", "PODMAN_COMPOSE_VERSION_LABEL_KEY", "HTTP_URL_SCHEMA", "HTTPS_URL_SCHEMA", "TCP_URL_SCHEMA", "COMMA_REGEX", "Lkotlin/text/Regex;", "DOCKER_COMPOSE_SUPPORTED_FILENAMES", "", "getDOCKER_COMPOSE_SUPPORTED_FILENAMES", "()Ljava/util/List;", "DOCKER_COMPOSE_OVERRIDE_FILENAME", "DEFAULT_DOCKER_COMPOSE_PROJECT_NAME", "COMPOSE_PROJECT_NAME_ENV_VAR", "fixApiUrlSchema", "resolveFiles", "", "Ljava/nio/file/Path;", "Lcom/intellij/docker/agent/util/DockerComposeData;", "execComposeCommand", "", "cli", "Lcom/intellij/docker/agent/cli/DockerCli;", "args", "", "(Lcom/intellij/docker/agent/util/DockerComposeData;Lcom/intellij/docker/agent/cli/DockerCli;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "WSL_MNT_ROOT", "getComposeData", "Lcom/intellij/docker/agent/DockerAgentContainer;", "getComposeFilePath", "originPath", "workingDirPath", "getWindowsPath", "wslPath", "isComposeFilesLabelSupported", "", "Lcom/intellij/docker/agent/util/ComposeVersion;", "Lcom/intellij/docker/agent/util/Version;", "escapeDollarSigns", "string", "", "envs", "command", "([Ljava/lang/String;)[Ljava/lang/String;", "findDockerComposeConfigurationFiles", "configurationPathNames", "configurationPathname", "findDockerComposeConfigurationPath", "folder", "getDockerComposeProjectName", "composeFilePath", "getDockerComposeDefaultWorkDir", "configurationFilePaths", "getEffectiveDockerComposeProjectName", "projectName", "workDir", "isDockerComposeNamedVolumeBind", "bindPath", "isWindowsAbsolutePath", "path", "composeConfig", "Lcom/intellij/docker/agent/compose/beans/v2/DockerComposeConfigurationV2;", "files", "", "workingDir", "options", "(Lcom/intellij/docker/agent/cli/DockerCli;Ljava/util/Collection;Ljava/lang/String;[Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getServices", "Lcom/intellij/docker/agent/compose/beans/DockerComposeServiceBase;", "Lcom/intellij/docker/agent/compose/beans/DockerComposeConfiguration;", "getServiceNames", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\ndockerComposeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 dockerComposeUtils.kt\ncom/intellij/docker/agent/util/DockerComposeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 8 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n+ 9 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,439:1\n1563#2:440\n1634#2,3:441\n1563#2:444\n1634#2,3:445\n774#2:449\n865#2,2:450\n1374#2:452\n1460#2,5:453\n1374#2:498\n1460#2,5:499\n774#2:509\n865#2,2:510\n1374#2:512\n1460#2,5:513\n1#3:448\n1#3:538\n37#4:458\n36#4,3:459\n37#4:471\n36#4,3:472\n37#4:504\n36#4,3:505\n37#4:518\n36#4,3:519\n697#5:462\n730#5,4:463\n11228#6:467\n11563#6,3:468\n106#7:475\n78#7,22:476\n8#8:508\n124#9:522\n54#9,15:523\n71#9:539\n*S KotlinDebug\n*F\n+ 1 dockerComposeUtils.kt\ncom/intellij/docker/agent/util/DockerComposeUtilsKt\n*L\n99#1:440\n99#1:441,3\n100#1:444\n100#1:445,3\n119#1:449\n119#1:450,2\n120#1:452\n120#1:453,5\n393#1:498\n393#1:499,5\n405#1:509\n405#1:510,2\n406#1:512\n406#1:513,5\n421#1:538\n120#1:458\n120#1:459,3\n217#1:471\n217#1:472,3\n393#1:504\n393#1:505,3\n413#1:518\n413#1:519,3\n205#1:462\n205#1:463,4\n217#1:467\n217#1:468,3\n377#1:475\n377#1:476,22\n399#1:508\n421#1:522\n421#1:523,15\n421#1:539\n*E\n"})
public final class DockerComposeUtilsKt {
    @NotNull
    public static final String COMPOSE_SERVICE_LABEL_KEY = "com.docker.compose.service";
    @NotNull
    public static final String COMPOSE_PROJECT_LABEL_KEY = "com.docker.compose.project";
    @NotNull
    public static final String COMPOSE_FILES_LABEL_KEY = "com.docker.compose.project.config_files";
    @NotNull
    public static final String COMPOSE_WORKING_DIR_LABEL_KEY = "com.docker.compose.project.working_dir";
    @NotNull
    public static final String DOCKER_COMPOSE_VERSION_LABEL_KEY = "com.docker.compose.version";
    @NotNull
    public static final String PODMAN_COMPOSE_VERSION_LABEL_KEY = "io.podman.compose.version";
    @NotNull
    private static final String HTTP_URL_SCHEMA = "http://";
    @NotNull
    private static final String HTTPS_URL_SCHEMA = "https://";
    @NotNull
    private static final String TCP_URL_SCHEMA = "tcp://";
    @NotNull
    private static final Regex COMMA_REGEX = new Regex(",");
    @NotNull
    private static final List<String> DOCKER_COMPOSE_SUPPORTED_FILENAMES;
    @NonNls
    @NotNull
    private static final String DOCKER_COMPOSE_OVERRIDE_FILENAME;
    @NonNls
    @NotNull
    private static final String DEFAULT_DOCKER_COMPOSE_PROJECT_NAME;
    @NonNls
    @NotNull
    public static final String COMPOSE_PROJECT_NAME_ENV_VAR = "COMPOSE_PROJECT_NAME";
    @NotNull
    private static final String WSL_MNT_ROOT = "/mnt/";

    @NotNull
    public static final List<String> getDOCKER_COMPOSE_SUPPORTED_FILENAMES() {
        return DOCKER_COMPOSE_SUPPORTED_FILENAMES;
    }

    @NotNull
    public static final String fixApiUrlSchema(@NotNull String $this$fixApiUrlSchema) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$fixApiUrlSchema, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$fixApiUrlSchema, (String)HTTP_URL_SCHEMA, (boolean)false, (int)2, null)) {
            String string = $this$fixApiUrlSchema.substring(7);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = TCP_URL_SCHEMA + string;
        } else if (StringsKt.startsWith$default((String)$this$fixApiUrlSchema, (String)HTTPS_URL_SCHEMA, (boolean)false, (int)2, null)) {
            String string = $this$fixApiUrlSchema.substring(8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = TCP_URL_SCHEMA + string;
        } else {
            object = $this$fixApiUrlSchema;
        }
        return object;
    }

    @ApiStatus.Experimental
    @NotNull
    public static final Set<Path> resolveFiles(@NotNull DockerComposeData $this$resolveFiles) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$resolveFiles, (String)"<this>");
        Iterable $this$map$iv = $this$resolveFiles.getConfigFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DockerComposeUtilsKt.getComposeFilePath(it, $this$resolveFiles.getWorkingDir()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Path.of(it, new String[0]));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @ApiStatus.Experimental
    @Nullable
    public static final Object execComposeCommand(@NotNull DockerComposeData $this$execComposeCommand, @NotNull DockerCli cli, @NotNull String[] args, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof execComposeCommand.1)) ** GOTO lbl-1000
        var19_4 = $completion;
        if ((var19_4.label & -2147483648) != 0) {
            var19_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerComposeUtilsKt.execComposeCommand(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                mainConfigurationFile = (String)CollectionsKt.firstOrNull((Iterable)$this$execComposeCommand.getConfigFiles());
                if (!(mainConfigurationFile != null)) {
                    $i$a$-require-DockerComposeUtilsKt$execComposeCommand$2 = false;
                    $i$a$-require-DockerComposeUtilsKt$execComposeCommand$2 = "Compose configuration files list must not be empty";
                    throw new IllegalArgumentException($i$a$-require-DockerComposeUtilsKt$execComposeCommand$2.toString());
                }
                $continuation.L$0 = $this$execComposeCommand;
                $continuation.L$1 = cli;
                $continuation.L$2 = args;
                $continuation.L$3 = mainConfigurationFile;
                $continuation.label = 1;
                v0 = cli.getPath(mainConfigurationFile, (Continuation<? super Path>)$continuation);
                if (v0 == var20_6) {
                    return var20_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                mainConfigurationFile = (String)$continuation.L$3;
                args = (String[])$continuation.L$2;
                cli = (DockerCli)$continuation.L$1;
                $this$execComposeCommand = (DockerComposeData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                if (!Files.exists((Path)v0, new LinkOption[0])) {
                    $i$a$-require-DockerComposeUtilsKt$execComposeCommand$3 = false;
                    $i$a$-require-DockerComposeUtilsKt$execComposeCommand$3 = "Compose configuration file " + mainConfigurationFile + " does not exist";
                    throw new IllegalArgumentException($i$a$-require-DockerComposeUtilsKt$execComposeCommand$3.toString());
                }
                $i$a$-require-DockerComposeUtilsKt$execComposeCommand$3 = CollectionsKt.drop((Iterable)$this$execComposeCommand.getConfigFiles(), (int)1);
                var17_15 = SetsKt.setOf((Object)mainConfigurationFile);
                $i$f$filter = 0;
                var8_18 = $this$filter$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>();
                $i$f$filterTo = 0;
                var11_23 = $this$filterTo$iv$iv.iterator();
lbl44:
                // 3 sources

                while (var11_23.hasNext()) {
                    element$iv$iv = var11_23.next();
                    it = (String)element$iv$iv;
                    $i$a$-filter-DockerComposeUtilsKt$execComposeCommand$existingConfigurationFiles$1 = 0;
                    $continuation.L$0 = $this$execComposeCommand;
                    $continuation.L$1 = cli;
                    $continuation.L$2 = args;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)mainConfigurationFile);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$filter$iv);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)$this$filterTo$iv$iv);
                    $continuation.L$6 = destination$iv$iv /* !! */ ;
                    $continuation.L$7 = var11_23;
                    $continuation.L$8 = element$iv$iv;
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)it);
                    $continuation.L$10 = var17_15;
                    $continuation.I$0 = $i$f$filter;
                    $continuation.I$1 = $i$f$filterTo;
                    $continuation.I$2 = $i$a$-filter-DockerComposeUtilsKt$execComposeCommand$existingConfigurationFiles$1;
                    $continuation.label = 2;
                    v1 = cli.getPath(it, (Continuation<? super Path>)$continuation);
                    if (v1 == var20_6) {
                        return var20_6;
                    }
                    ** GOTO lbl85
                }
                break;
            }
            case 2: {
                $i$a$-filter-DockerComposeUtilsKt$execComposeCommand$existingConfigurationFiles$1 = $continuation.I$2;
                $i$f$filterTo = $continuation.I$1;
                $i$f$filter = $continuation.I$0;
                var17_15 = (Set)$continuation.L$10;
                it = (String)$continuation.L$9;
                element$iv$iv = $continuation.L$8;
                var11_23 = (Iterator<T>)$continuation.L$7;
                destination$iv$iv /* !! */  = (Collection)$continuation.L$6;
                $this$filterTo$iv$iv = (Iterable)$continuation.L$5;
                $this$filter$iv = (Iterable)$continuation.L$4;
                mainConfigurationFile = (String)$continuation.L$3;
                args = (String[])$continuation.L$2;
                cli = (DockerCli)$continuation.L$1;
                $this$execComposeCommand = (DockerComposeData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl85:
                // 2 sources

                if (!Files.exists((Path)v1, new LinkOption[0])) ** GOTO lbl44
                destination$iv$iv /* !! */ .add(element$iv$iv);
                ** GOTO lbl44
            }
        }
        existingConfigurationFiles = SetsKt.plus((Set)var17_15, (Iterable)((List)destination$iv$iv /* !! */ ));
        $this$flatMap$iv = existingConfigurationFiles;
        $i$f$flatMap = false;
        destination$iv$iv /* !! */  = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-flatMap-DockerComposeUtilsKt$execComposeCommand$fileArgs$1 = false;
            var16_33 = new String[]{"-f", it};
            list$iv$iv = CollectionsKt.listOf((Object[])var16_33);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        fileArgs = thisCollection$iv.toArray(new String[0]);
        v2 = cli;
        var7_17 = new SpreadBuilder(5);
        var7_17.add((Object)"compose");
        var7_17.addSpread((Object)fileArgs);
        var7_17.add((Object)"-p");
        var7_17.add((Object)$this$execComposeCommand.getProject());
        var7_17.addSpread((Object)args);
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$execComposeCommand);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)cli);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)args);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)mainConfigurationFile);
        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)existingConfigurationFiles);
        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)fileArgs);
        $continuation.L$6 = null;
        $continuation.L$7 = null;
        $continuation.L$8 = null;
        $continuation.L$9 = null;
        $continuation.L$10 = null;
        $continuation.label = 3;
        v3 = Cli.execAsync$default(v2, CollectionsKt.listOf((Object[])var7_17.toArray((Object[])new String[var7_17.size()])), null, null, null, null, null, null, null, (Continuation)$continuation, 254, null);
        if (v3 == var20_6) {
            return var20_6;
        }
        ** GOTO lbl140
        {
            case 3: {
                fileArgs = (String[])$continuation.L$5;
                existingConfigurationFiles = (Set)$continuation.L$4;
                mainConfigurationFile = (String)$continuation.L$3;
                args = (String[])$continuation.L$2;
                cli = (DockerCli)$continuation.L$1;
                $this$execComposeCommand = (DockerComposeData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl140:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$execComposeCommand);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)cli);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)args);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)mainConfigurationFile);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)existingConfigurationFiles);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)fileArgs);
                $continuation.label = 4;
                v4 = ((AsyncCliProcess)v3).await($continuation);
                if (v4 == var20_6) {
                    return var20_6;
                }
                ** GOTO lbl160
            }
            case 4: {
                fileArgs = (String[])$continuation.L$5;
                existingConfigurationFiles = (Set)$continuation.L$4;
                mainConfigurationFile = (String)$continuation.L$3;
                args = (String[])$continuation.L$2;
                cli = (DockerCli)$continuation.L$1;
                $this$execComposeCommand = (DockerComposeData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl160:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public static final DockerComposeData getComposeData(@NotNull DockerAgentContainer $this$getComposeData) {
        int n;
        CharSequence charSequence;
        Regex regex;
        String configFilesString;
        Object object;
        String workingDir2;
        Pair pair;
        String service;
        String project;
        Map<String, String> containerLabels;
        block10: {
            Intrinsics.checkNotNullParameter((Object)$this$getComposeData, (String)"<this>");
            containerLabels = $this$getComposeData.getContainerLabels();
            String string = containerLabels.get(COMPOSE_PROJECT_LABEL_KEY);
            if (string == null) {
                return null;
            }
            project = string;
            String string2 = containerLabels.get(COMPOSE_SERVICE_LABEL_KEY);
            if (string2 == null) {
                return null;
            }
            service = string2;
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)DOCKER_COMPOSE_VERSION_LABEL_KEY, (Object)((Object)getComposeData.composeVersion.1.INSTANCE)), TuplesKt.to((Object)PODMAN_COMPOSE_VERSION_LABEL_KEY, (Object)((Object)getComposeData.composeVersion.2.INSTANCE))};
            for (Pair pair2 : (Iterable)CollectionsKt.listOf((Object[])objectArray)) {
                ComposeVersion composeVersion2;
                boolean bl = false;
                String versionLabel = (String)pair2.component1();
                KFunction versionBuilder = (KFunction)pair2.component2();
                if (containerLabels.get(versionLabel) != null) {
                    String version2;
                    boolean bl2 = false;
                    if (Version.Companion.from(version2) != null) {
                        Version it;
                        boolean bl3 = false;
                        composeVersion2 = (ComposeVersion)((Function1)versionBuilder).invoke((Object)it);
                    } else {
                        composeVersion2 = null;
                    }
                } else {
                    composeVersion2 = null;
                }
                if ((pair2 = composeVersion2) == null) continue;
                pair = pair2;
                break block10;
            }
            pair = null;
        }
        if (pair == null) {
            return null;
        }
        Pair composeVersion3 = pair;
        String string = containerLabels.get(COMPOSE_WORKING_DIR_LABEL_KEY);
        if (string == null) {
            string = workingDir2 = "";
        }
        if ((object = (configFilesString = containerLabels.get(COMPOSE_FILES_LABEL_KEY))) == null || (object = (regex = COMMA_REGEX).split(charSequence = (CharSequence)object, n = 0)) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        Object configFiles = object;
        return new DockerComposeData(service, project, workingDir2, (Set<String>)configFiles, (ComposeVersion)composeVersion3);
    }

    private static final String getComposeFilePath(String originPath, String workingDirPath) {
        if (Platform.INSTANCE.isWindows()) {
            if (DockerComposeUtilsKt.isWindowsAbsolutePath(originPath)) {
                return originPath;
            }
            if (StringsKt.startsWith$default((String)originPath, (String)WSL_MNT_ROOT, (boolean)false, (int)2, null)) {
                String string = DockerComposeUtilsKt.getWindowsPath(originPath);
                if (string == null) {
                    string = originPath;
                }
                return string;
            }
            return InternalUtilsKt.toSystemDependentName(workingDirPath + File.separatorChar + originPath);
        }
        return new File(originPath).isAbsolute() ? originPath : InternalUtilsKt.toSystemIndependentName(workingDirPath + File.separatorChar + originPath);
    }

    private static final String getWindowsPath(String wslPath) {
        String string;
        int driveLetterIndex = 5;
        if (driveLetterIndex >= wslPath.length() || !Character.isLetter(wslPath.charAt(driveLetterIndex))) {
            return null;
        }
        int slashIndex = driveLetterIndex + 1;
        if (slashIndex < wslPath.length() && wslPath.charAt(slashIndex) != '/') {
            string = null;
        } else {
            char c = Character.toUpperCase(wslPath.charAt(driveLetterIndex));
            String string2 = wslPath.substring(slashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)(c + ":" + string2), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null), (char)'\\', (char)File.separatorChar, (boolean)false, (int)4, null);
        }
        return string;
    }

    public static final boolean isComposeFilesLabelSupported(@NotNull ComposeVersion $this$isComposeFilesLabelSupported) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isComposeFilesLabelSupported, (String)"<this>");
        ComposeVersion composeVersion2 = $this$isComposeFilesLabelSupported;
        if (composeVersion2 instanceof DockerComposeVersion) {
            bl = DockerComposeUtilsKt.isComposeFilesLabelSupported(((DockerComposeVersion)$this$isComposeFilesLabelSupported).getVersion());
        } else if (composeVersion2 instanceof PodmanComposeVersion) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isComposeFilesLabelSupported(@NotNull Version $this$isComposeFilesLabelSupported) {
        Intrinsics.checkNotNullParameter((Object)$this$isComposeFilesLabelSupported, (String)"<this>");
        return $this$isComposeFilesLabelSupported.compareTo(new Version(1, 25, 0)) >= 0;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String escapeDollarSigns(@Nullable String string) {
        String string2;
        String string3 = string;
        if (string3 != null) {
            CharSequence charSequence = string3;
            Regex regex = new Regex("\\$");
            String string4 = "\\$\\$";
            string2 = regex.replace(charSequence, string4);
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final Map<String, String> escapeDollarSigns(@Nullable Map<String, String> envs) {
        Map map2;
        Sequence sequence = envs;
        if (sequence != null && (sequence = MapsKt.asSequence(sequence)) != null) {
            void $this$associateByTo$iv$iv;
            Sequence $this$associateBy$iv = sequence;
            boolean $i$f$associateBy = false;
            Sequence sequence2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry it = (Map.Entry)element$iv$iv;
                String string = DockerComposeUtilsKt.escapeDollarSigns((String)it.getKey());
                boolean bl2 = false;
                String string2 = DockerComposeUtilsKt.escapeDollarSigns((String)it.getValue());
                map3.put(string, string2);
            }
            map2 = destination$iv$iv;
        } else {
            map2 = null;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static final String[] escapeDollarSigns(@Nullable String[] command) {
        String[] stringArray;
        if (command != null) {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = command;
            boolean $i$f$map = false;
            String[] stringArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DockerComposeUtilsKt.escapeDollarSigns((String)it));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @NotNull
    public static final List<Path> findDockerComposeConfigurationFiles(@NotNull List<String> configurationPathNames) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter(configurationPathNames, (String)"configurationPathNames");
        if (!(!configurationPathNames.isEmpty())) {
            boolean bl = false;
            String string = "Configuration path name list must not be empty";
            throw new IllegalArgumentException(string.toString());
        }
        String mainConfigurationPathname = configurationPathNames.get(0);
        return Files.isDirectory(Paths.get(mainConfigurationPathname, new String[0]), new LinkOption[0]) ? DockerComposeUtilsKt.findDockerComposeConfigurationFiles(mainConfigurationPathname) : SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object)Paths.get(mainConfigurationPathname, new String[0])), (Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)configurationPathNames), (int)1), DockerComposeUtilsKt::findDockerComposeConfigurationFiles$lambda$13), DockerComposeUtilsKt::findDockerComposeConfigurationFiles$lambda$14)));
    }

    @NotNull
    public static final List<Path> findDockerComposeConfigurationFiles(@NotNull String configurationPathname) throws FileNotFoundException {
        List list;
        Intrinsics.checkNotNullParameter((Object)configurationPathname, (String)"configurationPathname");
        Path path = Paths.get(configurationPathname, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Intrinsics.checkNotNull((Object)path);
            Path configurationPath = DockerComposeUtilsKt.findDockerComposeConfigurationPath(path);
            Path overrideConfiguration = configurationPath.resolveSibling(DOCKER_COMPOSE_OVERRIDE_FILENAME);
            if (Files.isRegularFile(overrideConfiguration, new LinkOption[0])) {
                Object[] objectArray = new Path[2];
                objectArray[0] = configurationPath;
                Intrinsics.checkNotNull((Object)overrideConfiguration);
                objectArray[1] = overrideConfiguration;
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)configurationPath);
            }
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            list = CollectionsKt.listOf((Object)path);
        } else {
            throw new FileNotFoundException("Neither folder nor file \"" + path + "\" exists");
        }
        return list;
    }

    private static final Path findDockerComposeConfigurationPath(Path folder) throws FileNotFoundException {
        for (String filename : DOCKER_COMPOSE_SUPPORTED_FILENAMES) {
            Path configurationPath = folder.resolve(filename);
            if (!Files.isRegularFile(configurationPath, new LinkOption[0])) continue;
            Intrinsics.checkNotNull((Object)configurationPath);
            return configurationPath;
        }
        throw new FileNotFoundException(StringsKt.trimIndent((String)("\n      Can't find a suitable configuration file in this directory. \n      Supported filenames: " + CollectionsKt.joinToString$default((Iterable)DOCKER_COMPOSE_SUPPORTED_FILENAMES, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "\n    ")));
    }

    @NotNull
    public static final String getDockerComposeProjectName(@NotNull Path composeFilePath) {
        Intrinsics.checkNotNullParameter((Object)composeFilePath, (String)"composeFilePath");
        Path parent = composeFilePath.toAbsolutePath().getParent();
        return parent == null || parent.getFileName() == null ? DEFAULT_DOCKER_COMPOSE_PROJECT_NAME : ((Object)parent.getFileName()).toString();
    }

    @Nullable
    public static final Path getDockerComposeDefaultWorkDir(@NotNull List<? extends Path> configurationFilePaths) {
        Path path;
        Intrinsics.checkNotNullParameter(configurationFilePaths, (String)"configurationFilePaths");
        Path mainConfigurationFilePath = (Path)CollectionsKt.firstOrNull(configurationFilePaths);
        if (mainConfigurationFilePath == null) {
            path = null;
        } else {
            Path path2;
            try {
                path2 = mainConfigurationFilePath.toAbsolutePath().getParent();
            }
            catch (IOError iOError) {
                path2 = mainConfigurationFilePath.getParent();
            }
            path = path2;
        }
        return path;
    }

    @Nullable
    public static final String getEffectiveDockerComposeProjectName(@Nullable String projectName, @NotNull List<? extends Path> configurationFilePaths, @Nullable Map<String, String> envs) {
        Intrinsics.checkNotNullParameter(configurationFilePaths, (String)"configurationFilePaths");
        return DockerComposeUtilsKt.getEffectiveDockerComposeProjectName(projectName, DockerComposeUtilsKt.getDockerComposeDefaultWorkDir(configurationFilePaths), envs);
    }

    @Nullable
    public static final String getEffectiveDockerComposeProjectName(@Nullable String projectName, @Nullable Path workDir, @Nullable Map<String, String> envs) {
        String composeProjectName;
        if (projectName != null) {
            return projectName;
        }
        Map<String, String> map2 = envs;
        String string = composeProjectName = map2 != null ? map2.get(COMPOSE_PROJECT_NAME_ENV_VAR) : null;
        if (composeProjectName != null) {
            return composeProjectName;
        }
        return workDir == null || workDir.getFileName() == null ? null : ((Object)workDir.getFileName()).toString();
    }

    public static final boolean isDockerComposeNamedVolumeBind(@NotNull String bindPath) {
        String path;
        Intrinsics.checkNotNullParameter((Object)bindPath, (String)"bindPath");
        String $this$trim$iv = bindPath;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        if (((CharSequence)(path = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString())).length() == 0) {
            return false;
        }
        return DockerComposeUtilsKt.isWindowsAbsolutePath(path) ? false : !StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)path, (String)"~", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)path, (String)".", (boolean)false, (int)2, null);
    }

    private static final boolean isWindowsAbsolutePath(String path) {
        return Platform.INSTANCE.isWindows() && !(((CharSequence)path).length() == 0) && new File(path).isAbsolute();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object composeConfig(@NotNull DockerCli $this$composeConfig, @NotNull Collection<String> files, @Nullable String workingDir, @NotNull String[] options, @NotNull Continuation<? super DockerComposeConfigurationV2> $completion) {
        if (!($completion instanceof composeConfig.1)) ** GOTO lbl-1000
        var22_5 = $completion;
        if ((var22_5.label & -2147483648) != 0) {
            var22_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                boolean Z$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DockerComposeUtilsKt.composeConfig(null, null, null, null, (Continuation<? super DockerComposeConfigurationV2>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$flatMap$iv = files;
                $i$f$flatMap = false;
                var8_13 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (String)element$iv$iv;
                    $i$a$-flatMap-DockerComposeUtilsKt$composeConfig$fileArgs$1 = false;
                    var15_36 = new String[]{"-f", it};
                    list$iv$iv = CollectionsKt.listOf((Object[])var15_36);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                fileArgs = thisCollection$iv.toArray(new String[0]);
                $i$f$toTypedArray = new SpreadBuilder(4);
                $i$f$toTypedArray.add((Object)"compose");
                $i$f$toTypedArray.addSpread((Object)fileArgs);
                $i$f$toTypedArray.add((Object)"config");
                $i$f$toTypedArray.add((Object)"--profiles");
                args = CollectionsKt.listOf((Object[])$i$f$toTypedArray.toArray((Object[])new String[$i$f$toTypedArray.size()]));
                $continuation.L$0 = $this$composeConfig;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                $continuation.L$2 = workingDir;
                $continuation.L$3 = options;
                $continuation.L$4 = fileArgs;
                $continuation.L$5 = args;
                $continuation.label = 1;
                v0 = Cli.execAsyncWithResult$default($this$composeConfig, args, null, null, null, null, workingDir, null, null, (Continuation)$continuation, 222, null);
                if (v0 == var23_7) {
                    return var23_7;
                }
                ** GOTO lbl56
            }
            case 1: {
                args = (List)$continuation.L$5;
                fileArgs = (String[])$continuation.L$4;
                options = (String[])$continuation.L$3;
                workingDir = (String)$continuation.L$2;
                files = (Collection)$continuation.L$1;
                $this$composeConfig = (DockerCli)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl56:
                // 2 sources

                $continuation.L$0 = $this$composeConfig;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                $continuation.L$2 = workingDir;
                $continuation.L$3 = options;
                $continuation.L$4 = fileArgs;
                $continuation.L$5 = args;
                $continuation.label = 2;
                v1 = ((AsyncCliProcess)v0).await($continuation);
                if (v1 == var23_7) {
                    return var23_7;
                }
                ** GOTO lbl76
            }
            case 2: {
                args = (List)$continuation.L$5;
                fileArgs = (String[])$continuation.L$4;
                options = (String[])$continuation.L$3;
                workingDir = (String)$continuation.L$2;
                files = (Collection)$continuation.L$1;
                $this$composeConfig = (DockerCli)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl76:
                // 2 sources

                it = destination$iv$iv = (execProfiles = (ProcessResult)v1).getExitCode() == 0;
                $i$a$-also-DockerComposeUtilsKt$composeConfig$useProfiles$1 = false;
                if (!it) {
                    $i$f$logger = false;
                    v2 = LoggerFactory.getLogger(DockerComposeData.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getLogger(...)");
                    v2.warn("The command " + $this$composeConfig.getExePath() + " " + args + " returned non-zero exit code " + execProfiles.getExitCode() + "stderr:\n" + CollectionsKt.joinToString$default((Iterable)execProfiles.getStdErr(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                }
                useProfiles = destination$iv$iv;
                if (useProfiles) {
                    it = execProfiles.getStdOut();
                    $i$f$filter = false;
                    $i$f$logger = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (E element$iv$iv : $this$filterTo$iv$iv) {
                        p0 = (String)element$iv$iv;
                        $i$a$-filter-DockerComposeUtilsKt$composeConfig$additionalArgs$1 = false;
                        v3 = !StringsKt.isBlank((CharSequence)p0);
                        if (!v3) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$flatMap = false;
                    $this$filterTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$flatMapTo = false;
                    for (E element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (String)element$iv$iv;
                        $i$a$-flatMap-DockerComposeUtilsKt$composeConfig$additionalArgs$2 = false;
                        var19_44 = new String[]{"--profile", it};
                        list$iv$iv = CollectionsKt.listOf((Object[])var19_44);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    v4 = (List)destination$iv$iv;
                } else {
                    v4 = CollectionsKt.emptyList();
                }
                additionalArgs = v4;
                v5 = $this$composeConfig;
                $i$f$flatMap = new SpreadBuilder(5);
                $i$f$flatMap.add((Object)"compose");
                $i$f$flatMap.addSpread((Object)fileArgs);
                $this$toTypedArray$iv = additionalArgs;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                $i$f$flatMap.addSpread((Object)thisCollection$iv.toArray(new String[0]));
                $i$f$flatMap.add((Object)"config");
                $i$f$flatMap.addSpread((Object)options);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$composeConfig);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)workingDir);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)options);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)fileArgs);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)args);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)execProfiles);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)additionalArgs);
                $continuation.Z$0 = useProfiles;
                $continuation.label = 3;
                v6 = Cli.execAsyncWithResult$default(v5, CollectionsKt.listOf((Object[])$i$f$flatMap.toArray((Object[])new String[$i$f$flatMap.size()])), null, null, null, null, workingDir, null, null, (Continuation)$continuation, 222, null);
                if (v6 == var23_7) {
                    return var23_7;
                }
                ** GOTO lbl155
            }
            case 3: {
                useProfiles = $continuation.Z$0;
                additionalArgs = (List)$continuation.L$7;
                execProfiles = (ProcessResult)$continuation.L$6;
                args = (List)$continuation.L$5;
                fileArgs = (String[])$continuation.L$4;
                options = (String[])$continuation.L$3;
                workingDir = (String)$continuation.L$2;
                files = (Collection)$continuation.L$1;
                $this$composeConfig = (DockerCli)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl155:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$composeConfig);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)workingDir);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)options);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)fileArgs);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)args);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)execProfiles);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)additionalArgs);
                $continuation.Z$0 = useProfiles;
                $continuation.label = 4;
                v7 = ((AsyncCliProcess)v6).await($continuation);
                if (v7 == var23_7) {
                    return var23_7;
                }
                ** GOTO lbl181
            }
            case 4: {
                useProfiles = $continuation.Z$0;
                additionalArgs = (List)$continuation.L$7;
                execProfiles = (ProcessResult)$continuation.L$6;
                args = (List)$continuation.L$5;
                fileArgs = (String[])$continuation.L$4;
                options = (String[])$continuation.L$3;
                workingDir = (String)$continuation.L$2;
                files = (Collection)$continuation.L$1;
                $this$composeConfig = (DockerCli)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl181:
                // 2 sources

                if ((execConfig = (ProcessResult)v7).getExitCode() != 0) {
                    throw new IOException(CollectionsKt.joinToString$default((Iterable)execConfig.getStdErr(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                }
                $i$f$flatMap = DockerComposeDeserializer.Companion.getMapper();
                src$iv = new StringReader(CollectionsKt.joinToString$default((Iterable)execConfig.getStdOut(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                $i$f$readValue = false;
                $i$f$jacksonTypeRef = false;
                $this$checkTypeMismatch$iv$iv = $this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<DockerComposeConfigurationV2>(){});
                $i$f$checkTypeMismatch = false;
                if (!($this$checkTypeMismatch$iv$iv instanceof DockerComposeConfigurationV2)) {
                    nullability$iv$iv = "(non-null)";
                    v8 = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(DockerComposeConfigurationV2.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                    v9 = $this$checkTypeMismatch$iv$iv;
                    if (v9 != null) {
                        list$iv$iv = v9;
                        var18_43 = v8;
                        $i$a$-let-ExtensionsKt$checkTypeMismatch$1$iv$iv = false;
                        v10 = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                        v8 = var18_43;
                    } else {
                        v10 = null;
                    }
                    var20_46 = v8.append(v10).toString();
                    throw new RuntimeJsonMappingException(var20_46);
                }
                return $this$checkTypeMismatch$iv$iv;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object composeConfig$default(DockerCli dockerCli, Collection collection, String string, String[] stringArray, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return DockerComposeUtilsKt.composeConfig(dockerCli, collection, string, stringArray, (Continuation<? super DockerComposeConfigurationV2>)continuation);
    }

    @NotNull
    public static final Map<String, DockerComposeServiceBase> getServices(@NotNull DockerComposeConfiguration $this$getServices) {
        Intrinsics.checkNotNullParameter((Object)$this$getServices, (String)"<this>");
        Object t = $this$getServices.accept(new DockerComposeConfiguration.Visitor<Map<String, ? extends DockerComposeServiceBase>>(){

            public Map<String, DockerComposeServiceV1> visit(DockerComposeConfigurationV1 configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Map<String, DockerComposeServiceV1> map2 = configuration.getServices();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getServices(...)");
                return map2;
            }

            public Map<String, DockerComposeServiceV2> visit(DockerComposeConfigurationV2 configuration) {
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Map<String, DockerComposeServiceV2> map2 = configuration.getServices();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"getServices(...)");
                return map2;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"accept(...)");
        return (Map)t;
    }

    @NotNull
    public static final Set<String> getServiceNames(@NotNull DockerComposeConfiguration $this$getServiceNames) {
        Intrinsics.checkNotNullParameter((Object)$this$getServiceNames, (String)"<this>");
        return DockerComposeUtilsKt.getServices($this$getServiceNames).keySet();
    }

    private static final Path findDockerComposeConfigurationFiles$lambda$13(String pathname) {
        Intrinsics.checkNotNullParameter((Object)pathname, (String)"pathname");
        return Paths.get(pathname, new String[0]);
    }

    private static final boolean findDockerComposeConfigurationFiles$lambda$14(Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return Files.exists(path, new LinkOption[0]);
    }

    static {
        Object[] objectArray = new String[]{"docker-compose.yml", "docker-compose.yaml"};
        DOCKER_COMPOSE_SUPPORTED_FILENAMES = CollectionsKt.listOf((Object[])objectArray);
        DOCKER_COMPOSE_OVERRIDE_FILENAME = "docker-compose.override.yml";
        DEFAULT_DOCKER_COMPOSE_PROJECT_NAME = "default";
    }
}

