/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp;

import com.intellij.util.system.OS;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrTestCase;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.cpp.CPPTestDataFixture;
import com.jetbrains.cidr.cpp.CPPTestUtil;
import com.jetbrains.cidr.cpp.cmake.CMakeProjectFixture;
import com.jetbrains.cidr.cpp.execution.CMakeExecutionFixture;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.system.HostMachine;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;

public abstract class CPPTestCase
extends CidrTestCase<CMakeProjectFixture, CMakeExecutionFixture, CidrDebuggingFixture<CMakeExecutionFixture>, CidrCodeInsightFixture> {
    @Override
    protected void initApplication() {
        CPPTestUtil.getTestCPPEnvironment();
        super.initApplication();
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CPPTestDataFixture();
    }

    @Override
    @NotNull
    protected CMakeProjectFixture createProjectFixture() {
        return new CMakeProjectFixture(this.myTestDataFixture);
    }

    @NotNull
    public static HostOSAssumption assumeHostOS() {
        return new HostOSAssumption(() -> CPPTestUtil.getTestCPPEnvironment().getHostMachine().getOS());
    }

    @NotNull
    public static ToolSetKindAssumption assumeToolSetKind() {
        return new ToolSetKindAssumption(() -> CPPTestUtil.getTestCPPEnvironment().getToolSet().getKind());
    }

    @NotNull
    public static HostMachineAssumption assumeHostMachine() {
        return new HostMachineAssumption(() -> CPPTestUtil.getTestCPPEnvironment().getHostMachine());
    }

    public static class HostOSAssumption {
        @NotNull
        private final Supplier<OS> myOSTypeSupplier;

        public HostOSAssumption(@NotNull Supplier<OS> osTypeSupplier) {
            if (osTypeSupplier == null) {
                HostOSAssumption.$$$reportNull$$$0(0);
            }
            this.myOSTypeSupplier = osTypeSupplier;
        }

        public void isWindows() {
            Assume.assumeTrue((String)"Windows host only", (this.myOSTypeSupplier.get() == OS.Windows ? 1 : 0) != 0);
        }

        public void isUnix() {
            Assume.assumeTrue((String)"Unix host only", (this.myOSTypeSupplier.get() != OS.Windows ? 1 : 0) != 0);
        }

        public void isLinux() {
            Assume.assumeTrue((String)"Linux host only", (this.myOSTypeSupplier.get() == OS.Linux ? 1 : 0) != 0);
        }

        public void isMac() {
            Assume.assumeTrue((String)"Mac host only", (this.myOSTypeSupplier.get() == OS.macOS ? 1 : 0) != 0);
        }

        public void isNotWindows() {
            Assume.assumeTrue((String)"not for windows host", (this.myOSTypeSupplier.get() != OS.Windows ? 1 : 0) != 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "osTypeSupplier", "com/jetbrains/cidr/cpp/CPPTestCase$HostOSAssumption", "<init>"));
        }
    }

    public static class ToolSetKindAssumption {
        @NotNull
        private final Supplier<? extends CPPToolSet.Kind> myToolSetKindSupplier;

        public ToolSetKindAssumption(@NotNull Supplier<? extends CPPToolSet.Kind> toolSetKindSupplier) {
            if (toolSetKindSupplier == null) {
                ToolSetKindAssumption.$$$reportNull$$$0(0);
            }
            this.myToolSetKindSupplier = toolSetKindSupplier;
        }

        public void isWSL() {
            Assume.assumeTrue((String)"WSL only", (this.myToolSetKindSupplier.get() == CPPToolSet.Kind.WSL ? 1 : 0) != 0);
        }

        public void isCygwin() {
            Assume.assumeTrue((String)"Cygwin only", (this.myToolSetKindSupplier.get() == CPPToolSet.Kind.CYGWIN ? 1 : 0) != 0);
        }

        public void isDocker() {
            Assume.assumeTrue((String)"Docker only", (this.myToolSetKindSupplier.get() == CPPToolSet.Kind.DOCKER ? 1 : 0) != 0);
        }

        public void isMSVC() {
            Assume.assumeTrue((String)"MSVC only", (this.myToolSetKindSupplier.get() == CPPToolSet.Kind.MSVC ? 1 : 0) != 0);
        }

        public void isMinGW() {
            Assume.assumeTrue((String)"MinGW only", (this.myToolSetKindSupplier.get() == CPPToolSet.Kind.MINGW ? 1 : 0) != 0);
        }

        public void isSsh() {
            Assume.assumeTrue((String)"Ssh only", (this.myToolSetKindSupplier.get() == CPPToolSet.Kind.SSH ? 1 : 0) != 0);
        }

        public void isSystemWindows() {
            Assume.assumeTrue((String)"SystemWindows only", (this.myToolSetKindSupplier.get() == CPPToolSet.Kind.SYSTEM_WINDOWS_TOOLSET ? 1 : 0) != 0);
        }

        public void isRemoteLike() {
            Assume.assumeTrue((String)"remote-like only", (boolean)this.myToolSetKindSupplier.get().isRemoteLike());
        }

        public void isNotWSL() {
            Assume.assumeTrue((String)"not for WSL", (this.myToolSetKindSupplier.get() != CPPToolSet.Kind.WSL ? 1 : 0) != 0);
        }

        public void isNotCygwin() {
            Assume.assumeTrue((String)"not for Cygwin", (this.myToolSetKindSupplier.get() != CPPToolSet.Kind.CYGWIN ? 1 : 0) != 0);
        }

        public void isNotDocker() {
            Assume.assumeTrue((String)"not for Docker", (this.myToolSetKindSupplier.get() != CPPToolSet.Kind.DOCKER ? 1 : 0) != 0);
        }

        public void isNotMSVC() {
            Assume.assumeTrue((String)"not for MSVC", (this.myToolSetKindSupplier.get() != CPPToolSet.Kind.MSVC ? 1 : 0) != 0);
        }

        public void isNotMinGW() {
            Assume.assumeTrue((String)"not for MinGW", (this.myToolSetKindSupplier.get() != CPPToolSet.Kind.MINGW ? 1 : 0) != 0);
        }

        public void isNotRemoteLike() {
            Assume.assumeFalse((String)"not for remote-like", (boolean)this.myToolSetKindSupplier.get().isRemoteLike());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolSetKindSupplier", "com/jetbrains/cidr/cpp/CPPTestCase$ToolSetKindAssumption", "<init>"));
        }
    }

    public static class HostMachineAssumption {
        @NotNull
        private final Supplier<? extends HostMachine> myHostMachineSupplier;

        public HostMachineAssumption(@NotNull Supplier<? extends HostMachine> hostMachineSupplier) {
            if (hostMachineSupplier == null) {
                HostMachineAssumption.$$$reportNull$$$0(0);
            }
            this.myHostMachineSupplier = hostMachineSupplier;
        }

        public void isRemote() {
            Assume.assumeTrue((String)"Remote host only", (boolean)this.myHostMachineSupplier.get().isRemote());
        }

        public void isNotRemote() {
            Assume.assumeFalse((String)"not for remote host", (boolean)this.myHostMachineSupplier.get().isRemote());
        }

        public void isNotWSL() {
            Assume.assumeFalse((String)"not for WSL", (boolean)this.myHostMachineSupplier.get().isWsl());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostMachineSupplier", "com/jetbrains/cidr/cpp/CPPTestCase$HostMachineAssumption", "<init>"));
        }
    }
}

