/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard;

import com.intellij.clion.ide.core.projectWizard.CLionProjectSettingsStep;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.TestDialog;
import com.intellij.openapi.ui.TestDialogManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.IoTestUtil;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.cpp.CPPTestCase;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.CLionProjectGenerator;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public abstract class CLionProjectWizardTestCase
extends CPPTestCase {
    protected File myBaseDir;
    protected File myProjectsPath;

    @Override
    public void setUp() throws Exception {
        this.myBaseDir = FileUtil.createTempDirectory((String)"clion_new_projects", null);
        this.myProjectsPath = IoTestUtil.createTestDir(this.myBaseDir, "projects");
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            IoTestUtil.delete(this.myBaseDir);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(this.myBaseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewProject(String userProjectName, CLionProjectGenerator<?> projectGenerator, ThrowableConsumer<Project, Exception> checkingAssertsConsumer, TestDialog testDialog) {
        File projectDir = this.getOrCreateProjectDir(userProjectName);
        TestDialog oldValue = null;
        Project[] createdProject = new Project[]{null};
        try {
            oldValue = TestDialogManager.setTestDialog((TestDialog)testDialog);
            EdtTestUtil.runInEdtAndWait(() -> ApplicationManager.getApplication().runWriteIntentReadAction(() -> {
                AbstractNewProjectStep.AbstractCallback callback = new AbstractNewProjectStep.AbstractCallback();
                Object projectSettings = ((ProjectGeneratorPeer)projectGenerator.createLazyPeer().getValue()).getSettings();
                TestCLionProjectSettingsStep settings = new TestCLionProjectSettingsStep((DirectoryProjectGenerator)projectGenerator, callback);
                settings.setLocation(projectDir.getPath());
                Project defaultProject = ProjectManager.getInstance().getDefaultProject();
                DirectoryProjectGenerator generator = settings.getProjectGenerator();
                createdProject[0] = AbstractNewProjectStep.doGenerateProject((Project)defaultProject, (String)settings.getProjectLocation(), (DirectoryProjectGenerator)generator, (Object)projectSettings);
                return null;
            }));
            try {
                checkingAssertsConsumer.consume((Object)createdProject[0]);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }
        finally {
            if (oldValue != null) {
                TestDialogManager.setTestDialog((TestDialog)oldValue);
            }
            if (createdProject[0] != null) {
                PlatformTestUtil.forceCloseProjectWithoutSaving(createdProject[0]);
            }
        }
    }

    @NotNull
    protected File getOrCreateProjectDir(String userProjectName) {
        File projectDir = new File(this.myProjectsPath, FileUtil.sanitizeFileName((String)userProjectName));
        CLionProjectWizardTestCase.assertTrue((projectDir.mkdirs() || projectDir.exists() ? 1 : 0) != 0);
        File file = projectDir;
        if (file == null) {
            CLionProjectWizardTestCase.$$$reportNull$$$0(0);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/cmake/projectWizard/CLionProjectWizardTestCase", "getOrCreateProjectDir"));
    }

    private static class TestCLionProjectSettingsStep
    extends CLionProjectSettingsStep {
        TestCLionProjectSettingsStep(DirectoryProjectGenerator generator, AbstractNewProjectStep.AbstractCallback callback) {
            super(generator, callback);
            this.myLocationField = new TextFieldWithBrowseButton();
        }
    }
}

