/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.external.system.fixtures;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProjectDescription;
import com.jetbrains.cidr.cpp.CPPProjectFixture;
import com.jetbrains.cidr.cpp.assertions.CPPAssertions;
import com.jetbrains.cidr.cpp.external.system.ExtSysWaitingContext;
import com.jetbrains.cidr.cpp.external.system.fixtures.ExtSysAbstractProjectFixture;
import com.jetbrains.cidr.cpp.external.system.fixtures.ExtSysProjectFixture;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspaceListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.io.File;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.SoftAssertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AssumptionViolatedException;
import org.opentest4j.MultipleFailuresError;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010'\u001a\u00020%H&J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\u001eJ\b\u0010,\u001a\u00020)H\u0016J*\u0010-\u001a\u0004\u0018\u00010\u00022\u0016\u0010.\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u0003000/2\b\u00101\u001a\u0004\u0018\u000102J(\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020$2\b\u00108\u001a\u0004\u0018\u000109H\u0004J\u0010\u0010:\u001a\u00020\u001e2\u0006\u00106\u001a\u00020\u0002H\u0004J4\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020\u001e2\b\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010\u001e2\u0006\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020$H\u0002J2\u0010B\u001a\u00020)2\u0006\u0010<\u001a\u00020\u001e2\b\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010\u001e2\u0006\u0010@\u001a\u00020$2\u0006\u0010A\u001a\u00020$J\b\u0010C\u001a\u00020)H\u0004J\b\u0010D\u001a\u00020\u000fH\u0004J\b\u0010E\u001a\u00020\u0015H\u0004R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR,\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00020$*\u00020%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010&\u00a8\u0006F"}, d2={"Lcom/jetbrains/cidr/cpp/external/system/fixtures/ExtSysAbstractProjectFixture;", "Lcom/jetbrains/cidr/cpp/CPPProjectFixture;", "", "Lcom/jetbrains/cidr/cpp/external/system/fixtures/ExtSysProjectFixture;", "dataFixture", "Lcom/jetbrains/cidr/CidrTestDataFixture;", "<init>", "(Lcom/jetbrains/cidr/CidrTestDataFixture;)V", "externalSystemProjectFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getExternalSystemProjectFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setExternalSystemProjectFile", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "getConnection", "()Lcom/intellij/util/messages/MessageBusConnection;", "setConnection", "(Lcom/intellij/util/messages/MessageBusConnection;)V", "value", "Lcom/jetbrains/cidr/cpp/external/system/ExtSysWaitingContext;", "waitingContext", "getWaitingContext", "()Lcom/jetbrains/cidr/cpp/external/system/ExtSysWaitingContext;", "setWaitingContext", "(Lcom/jetbrains/cidr/cpp/external/system/ExtSysWaitingContext;)V", "additionalModelContext", "", "Lkotlin/Pair;", "", "getAdditionalModelContext", "()Ljava/util/List;", "setAdditionalModelContext", "(Ljava/util/List;)V", "isSupported", "", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "(Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;)Z", "getCidrWorkspace", "setUp", "", "testClassFQN", "testName", "tearDown", "getBuildConfiguration", "runConfiguration", "Lcom/jetbrains/cidr/execution/CidrRunConfiguration;", "Lcom/jetbrains/cidr/execution/CidrBuildTarget;", "executionTarget", "Lcom/intellij/execution/ExecutionTarget;", "doBuildOrCleanConfig", "Lcom/jetbrains/cidr/execution/ExecutionResult;", "Lcom/jetbrains/cidr/execution/build/CidrBuildResult;", "config", "build", "listener", "Lcom/intellij/execution/process/ProcessListener;", "getConfigBuildId", "initProject", "relativeProjectPath", "buildSymbolTables", "Lcom/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$SymbolsProperties$SymbolsKind;", "relativeFilesToCopyPath", "openProject", "expectFailures", "initProjectAndWait", "checkCPPProjectOpenedCorrectly", "createConnection", "createWaitingContext", "intellij.clion.testFramework"})
@SourceDebugExtension(value={"SMAP\nExtSysAbstractProjectFixture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtSysAbstractProjectFixture.kt\ncom/jetbrains/cidr/cpp/external/system/fixtures/ExtSysAbstractProjectFixture\n+ 2 CppSoftAssertions.kt\ncom/jetbrains/cidr/cpp/assertions/CppSoftAssertions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n21#2,3:197\n43#2,2:202\n25#2,5:204\n30#2,5:210\n36#2,10:216\n1869#3,2:200\n1869#3:209\n1870#3:215\n*S KotlinDebug\n*F\n+ 1 ExtSysAbstractProjectFixture.kt\ncom/jetbrains/cidr/cpp/external/system/fixtures/ExtSysAbstractProjectFixture\n*L\n100#1:197,3\n100#1:202,2\n100#1:204,5\n100#1:210,5\n100#1:216,10\n118#1:200,2\n100#1:209\n100#1:215\n*E\n"})
public abstract class ExtSysAbstractProjectFixture
extends CPPProjectFixture
implements ExtSysProjectFixture {
    protected volatile VirtualFile externalSystemProjectFile;
    @Nullable
    private volatile MessageBusConnection connection;
    @Nullable
    private volatile ExtSysWaitingContext waitingContext;
    @NotNull
    private volatile List<Pair<String, String>> additionalModelContext;

    protected ExtSysAbstractProjectFixture(@NotNull CidrTestDataFixture dataFixture) {
        Intrinsics.checkNotNullParameter((Object)dataFixture, (String)"dataFixture");
        super(dataFixture);
        this.additionalModelContext = CollectionsKt.emptyList();
    }

    @NotNull
    protected final VirtualFile getExternalSystemProjectFile() {
        VirtualFile virtualFile = this.externalSystemProjectFile;
        if (virtualFile != null) {
            return virtualFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"externalSystemProjectFile");
        return null;
    }

    protected final void setExternalSystemProjectFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<set-?>");
        this.externalSystemProjectFile = virtualFile;
    }

    @Nullable
    protected final MessageBusConnection getConnection() {
        return this.connection;
    }

    protected final void setConnection(@Nullable MessageBusConnection messageBusConnection) {
        this.connection = messageBusConnection;
    }

    @Override
    @Nullable
    public final ExtSysWaitingContext getWaitingContext() {
        return this.waitingContext;
    }

    protected final void setWaitingContext(@Nullable ExtSysWaitingContext extSysWaitingContext) {
        this.waitingContext = extSysWaitingContext;
    }

    @Override
    @NotNull
    public final List<Pair<String, String>> getAdditionalModelContext() {
        return this.additionalModelContext;
    }

    @Override
    public final void setAdditionalModelContext(@NotNull List<Pair<String, String>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.additionalModelContext = list;
    }

    protected abstract boolean isSupported(@NotNull ExternalWorkspace var1);

    @NotNull
    public abstract ExternalWorkspace getCidrWorkspace();

    @Override
    public final void setUp(@NotNull String testClassFQN, @NotNull String testName) {
        Intrinsics.checkNotNullParameter((Object)testClassFQN, (String)"testClassFQN");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        super.setUp(testClassFQN, testName);
        this.getTaskListener().reset();
        ExternalSystemTaskNotificationListener.EP_NAME.getPoint().registerExtension((Object)this.getTaskListener(), this.getTestRootDisposable());
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.additionalModelContext = CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public final Void getBuildConfiguration(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> runConfiguration, @Nullable ExecutionTarget executionTarget) {
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected final ExecutionResult<CidrBuildResult> doBuildOrCleanConfig(@NotNull Void config, boolean build, @Nullable ProcessListener listener) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected final String getConfigBuildId(@NotNull Void config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initProject(String relativeProjectPath, FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables, String relativeFilesToCopyPath, boolean openProject2, boolean expectFailures) {
        if (buildSymbolTables == null) {
            this.initProject(relativeProjectPath, relativeFilesToCopyPath, openProject2);
        } else {
            this.initProject(new CidrTestProjectDescription(relativeProjectPath, relativeFilesToCopyPath, openProject2), buildSymbolTables);
        }
        if (openProject2) {
            boolean $i$f$assertSoftly = false;
            SoftAssertions $this$assertSoftly_u24lambda_u241$iv = new SoftAssertions();
            boolean bl = false;
            try {
                SoftAssertions $this$initProject_u24lambda_u242 = $this$assertSoftly_u24lambda_u241$iv;
                boolean bl2 = false;
                ((BooleanAssert)$this$initProject_u24lambda_u242.assertThat(this.getTaskListener().isStarted()).describedAs("Task listener started?", new Object[0])).isTrue();
                ((BooleanAssert)$this$initProject_u24lambda_u242.assertThat(this.getTaskListener().isFinished()).describedAs("Task listener finished?", new Object[0])).isTrue();
                ((BooleanAssert)$this$initProject_u24lambda_u242.assertThat(this.getTaskListener().isSucceeded()).describedAs("Task listener succeeded?", new Object[0])).isTrue();
                ((BooleanAssert)$this$initProject_u24lambda_u242.assertThat(this.getTaskListener().isFailed()).describedAs("Task listener failed?", new Object[0])).isFalse();
                ((BooleanAssert)$this$initProject_u24lambda_u242.assertThat(this.getTaskListener().isCancelled()).describedAs("Task listener was cancelled?", new Object[0])).isFalse();
                List taskListenerFailures2 = SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.getTaskListener().getFailures()), (Function1)initProject.1.taskListenerFailures.1.INSTANCE)));
                AbstractListAssert abstractListAssert = $this$initProject_u24lambda_u242.assertThat(taskListenerFailures2).describedAs("Task listener failures", new Object[0]);
                ListAssert $this$initProject_u24lambda_u242_u24lambda_u240 = (ListAssert)abstractListAssert;
                boolean bl3 = false;
                if (expectFailures) {
                    $this$initProject_u24lambda_u242_u24lambda_u240.isNotEmpty();
                } else {
                    $this$initProject_u24lambda_u242_u24lambda_u240.isEmpty();
                }
                Iterable $this$forEach$iv = this.getTaskListener().getErrors();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Throwable error = (Throwable)element$iv;
                    boolean bl4 = false;
                    $this$initProject_u24lambda_u242.fail(ExceptionsKt.stackTraceToString((Throwable)error), error);
                }
            }
            catch (AssumptionViolatedException ave$iv) {
                throw ave$iv;
            }
            catch (MultipleFailuresError mfe$iv) {
                List list = mfe$iv.getFailures();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFailures(...)");
                Iterable $this$forEach$iv$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv : $this$forEach$iv$iv) {
                    Throwable failure$iv = (Throwable)element$iv$iv;
                    boolean bl5 = false;
                    if (failure$iv instanceof AssertionError) {
                        $this$assertSoftly_u24lambda_u241$iv.collectAssertionError((AssertionError)((Object)failure$iv));
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)failure$iv);
                    $this$assertSoftly_u24lambda_u241$iv.fail(ExceptionsKt.stackTraceToString((Throwable)failure$iv), failure$iv);
                }
            }
            catch (AssertionError ae$iv) {
                $this$assertSoftly_u24lambda_u241$iv.collectAssertionError(ae$iv);
            }
            catch (Throwable t$iv) {
                $this$assertSoftly_u24lambda_u241$iv.fail(ExceptionsKt.stackTraceToString((Throwable)t$iv), t$iv);
            }
            finally {
                $this$assertSoftly_u24lambda_u241$iv.assertAll();
            }
        }
    }

    @Override
    public final void initProjectAndWait(@NotNull String relativeProjectPath, @Nullable FileSymbolTablesCache.SymbolsProperties.SymbolsKind buildSymbolTables, @Nullable String relativeFilesToCopyPath, boolean openProject2, boolean expectFailures) {
        Intrinsics.checkNotNullParameter((Object)relativeProjectPath, (String)"relativeProjectPath");
        this.initProject(relativeProjectPath, buildSymbolTables, relativeFilesToCopyPath, openProject2, expectFailures);
        if (openProject2) {
            ExtSysWaitingContext waitingContextSnapshot = CPPAssertions.assertNotNull(this.waitingContext, "Waiting context");
            waitingContextSnapshot.waitForInitialized();
            waitingContextSnapshot.waitForUpdateScheduled();
            waitingContextSnapshot.waitForUpdateStarted();
            waitingContextSnapshot.waitForUpdateFinished();
        }
    }

    @Override
    protected final void checkCPPProjectOpenedCorrectly() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.getCidrWorkspace().isInitialized()).describedAs("CIDR workspace initialized", new Object[0])).isTrue();
    }

    @NotNull
    protected final MessageBusConnection createConnection() {
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection == null) {
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Disposable disposable = this.getTestRootDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getTestRootDisposable(...)");
            messageBusConnection = messageBus.connect(disposable);
        }
        return messageBusConnection;
    }

    @NotNull
    protected final ExtSysWaitingContext createWaitingContext() {
        ExtSysWaitingContext waitingContextSnapshot = this.waitingContext;
        if (waitingContextSnapshot != null) {
            return waitingContextSnapshot;
        }
        MessageBusConnection connectionSnapshot = CPPAssertions.assertNotNull(this.connection, "Connection");
        ExtSysWaitingContext context2 = new ExtSysWaitingContext();
        Topic topic = ExternalWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connectionSnapshot.subscribe(topic, (Object)new ExternalWorkspaceListener(this, context2){
            final /* synthetic */ ExtSysAbstractProjectFixture this$0;
            final /* synthetic */ ExtSysWaitingContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void initialized(ExternalWorkspace workspace, File projectDir) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                if (this.this$0.isSupported(workspace) && Intrinsics.areEqual((Object)workspace.getProject().getBasePath(), (Object)this.this$0.getProjectDirPath())) {
                    this.$context.initialized();
                }
            }

            public void updateScheduled(ExternalWorkspace workspace) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                if (this.this$0.isSupported(workspace) && Intrinsics.areEqual((Object)workspace.getProject().getBasePath(), (Object)this.this$0.getProjectDirPath())) {
                    this.$context.updateScheduled();
                }
            }

            public void updateStarted(ExternalWorkspace workspace) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                if (this.this$0.isSupported(workspace) && Intrinsics.areEqual((Object)workspace.getProject().getBasePath(), (Object)this.this$0.getProjectDirPath())) {
                    this.$context.updateStarted();
                }
            }

            public void updateFinished(ExternalWorkspace workspace) {
                Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
                if (this.this$0.isSupported(workspace) && Intrinsics.areEqual((Object)workspace.getProject().getBasePath(), (Object)this.this$0.getProjectDirPath())) {
                    this.$context.updateFinished();
                }
            }
        });
        return context2;
    }
}

