/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlightingComputer;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public abstract class OCHighlightUsagesCase
extends OCCodeInsightTestCase {
    private static final String REF = "s";

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.ONLY_USED;
        if (symbolsKind == null) {
            OCHighlightUsagesCase.$$$reportNull$$$0(0);
        }
        return symbolsKind;
    }

    protected void assertUsagesCpp(@NotNull String text2) {
        if (text2 == null) {
            OCHighlightUsagesCase.$$$reportNull$$$0(1);
        }
        this.assertUsages(text2, (OCLanguageKind)CLanguageKind.CPP, false, true);
    }

    protected void noUsagesCpp(@NotNull String text2) {
        if (text2 == null) {
            OCHighlightUsagesCase.$$$reportNull$$$0(2);
        }
        this.assertUsages(text2, (OCLanguageKind)CLanguageKind.CPP, true, true);
    }

    protected void assertUsagesC(@NotNull String text2) {
        if (text2 == null) {
            OCHighlightUsagesCase.$$$reportNull$$$0(3);
        }
        this.assertUsages(text2, (OCLanguageKind)CLanguageKind.C, false, true);
    }

    protected void assertUsages(@NotNull String text2, @NotNull OCLanguageKind languageKind, boolean checkNothingToFindAtCursor, boolean withDeclarations) {
        if (text2 == null) {
            OCHighlightUsagesCase.$$$reportNull$$$0(4);
        }
        if (languageKind == null) {
            OCHighlightUsagesCase.$$$reportNull$$$0(5);
        }
        this.assertUsages(text2, languageKind, checkNothingToFindAtCursor, withDeclarations, false);
    }

    protected void assertUsages(@NotNull String text2, @NotNull OCLanguageKind languageKind, boolean checkNothingToFindAtCursor, boolean withDeclarations, boolean withRefMerge) {
        if (text2 == null) {
            OCHighlightUsagesCase.$$$reportNull$$$0(6);
        }
        if (languageKind == null) {
            OCHighlightUsagesCase.$$$reportNull$$$0(7);
        }
        OCFile file = this.configureByText(text2.replaceAll("<s>", "").replace("</s>", ""), languageKind);
        PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)this.getEditor(), (int)TargetElementUtil.getInstance().getReferenceSearchFlags());
        if (targetElement == null && checkNothingToFindAtCursor) {
            return;
        }
        OCHighlightUsagesCase.assertNotNull((String)"Nothing to find at cursor", (Object)targetElement);
        AbstractCollection allUsages = new ArrayList();
        IdentifierHighlightingComputer.getHighlightUsages((PsiElement)targetElement, (PsiElement)file, (boolean)withDeclarations, allUsages, allUsages);
        if (withRefMerge) {
            allUsages = new HashSet(allUsages);
        }
        OCHighlightUsagesCase.assertEquals((String)text2.replace("<caret>", ""), (String)CodeInsightTestFixtureImpl.getTagsFromSegments(file.getText(), allUsages, REF, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/OCHighlightUsagesCase";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/OCHighlightUsagesCase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "assertUsagesCpp";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "noUsagesCpp";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "assertUsagesC";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

