/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import org.jetbrains.annotations.Nullable;

public final class OCHiddenNonVirtualFunctionAnnotator
extends OCAnnotator {
    @Override
    public void visitFunctionDeclaration(OCFunctionDeclaration declaration) {
        OCSymbol symbol = declaration.getSymbol();
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            OCFile file = declaration.getContainingOCFile();
            if (file.isCpp()) {
                this.checkHiddenNonVirtualFunction(declaration, functionSymbol, declaration.getProject());
            }
        }
    }

    private void checkHiddenNonVirtualFunction(OCFunctionDeclaration function, OCFunctionSymbol symbol, Project project) {
        if (symbol.getKind().isConstructorOrDestructor()) {
            return;
        }
        OCFunctionSymbol candidate = OCHiddenNonVirtualFunctionAnnotator.findOverriddenCandidate(symbol, project);
        if (candidate == null) {
            return;
        }
        OCCompilationContext compilationContext = OCCompilationContext.create(function);
        if (symbol.getParent() != null && !candidate.isVirtual() && candidate.getVisibility() != OCVisibility.PRIVATE) {
            OCProblemGroup problemGroup;
            String message = OCInspectionsBundle.message((String)"inspection.message.hides.non.virtual.function", (Object[])new Object[]{symbol.getNameWithKindUppercase(compilationContext), candidate.getParent().getNameWithKindLowercase(compilationContext)});
            HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(OCInspections.HidingNonVirtualFunction.class, null, (PsiElement)function, (HighlightSeverity)HighlightSeverity.WARNING);
            AnnotationHolder holder = this.getHolder();
            OCElementsRange range = function.getHeaderRange();
            if (holder != null && range != null && highlightSeverity != null && (problemGroup = OCHiddenNonVirtualFunctionAnnotator.getProblemGroup(function.getContainingOCFile(), range.getTextRange(), "CIDR", OCInspections.HidingNonVirtualFunction.class)) != null) {
                holder.newAnnotation(HighlightSeverity.WARNING, message).withFix((IntentionAction)new OCMakeFunctionVirtualFix(candidate, false, compilationContext.getProject())).range(range.getTextRange()).problemGroup((ProblemGroup)problemGroup).create();
            }
        }
    }

    @Nullable
    private static OCFunctionSymbol findOverriddenCandidate(OCFunctionSymbol symbol, Project project) {
        final Ref nonVirtualRef = new Ref();
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> virtualFinder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            public boolean process(OCFunctionSymbol symbol) {
                if (symbol.isVirtual()) {
                    return super.process((Object)symbol);
                }
                nonVirtualRef.set((Object)symbol);
                return true;
            }
        };
        new OCFunctionAncestorsQuery(symbol, true, false, project).forEach((Processor)virtualFinder);
        OCFunctionSymbol virtualFunction = (OCFunctionSymbol)virtualFinder.getFoundValue();
        OCFunctionSymbol nonVirtualFunction = (OCFunctionSymbol)nonVirtualRef.get();
        return virtualFunction != null ? virtualFunction : nonVirtualFunction;
    }
}

