/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public final class LiteralJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document doc, @NotNull PsiFile psiFile, int offsetNear, int end) {
        if (doc == null) {
            LiteralJoinLinesHandler.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            LiteralJoinLinesHandler.$$$reportNull$$$0(1);
        }
        CharSequence text = doc.getCharsSequence();
        int start = offsetNear;
        while (text.charAt(start) == ' ' || text.charAt(start) == '\t') {
            --start;
        }
        if (text.charAt(start) == '\"') {
            --start;
        }
        if (start < offsetNear) {
            ++start;
        }
        boolean state = false;
        int startQuoteOffset = -1;
        block5: for (int j = start; j < doc.getTextLength(); ++j) {
            switch (text.charAt(j)) {
                case '\t': 
                case ' ': {
                    continue block5;
                }
                case '\"': {
                    if (!state) {
                        if (OCElementUtil.getElementType(psiFile.findElementAt(j)) != OCLexerTokenTypes.STRING_LITERAL) {
                            return -1;
                        }
                        state = true;
                        startQuoteOffset = j;
                        continue block5;
                    }
                    doc.deleteString(startQuoteOffset, j + 1);
                    return startQuoteOffset;
                }
            }
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "doc";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/LiteralJoinLinesHandler";
        objectArray[2] = "tryJoinLines";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

