/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.folding;

import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.editor.OCFoldingBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class MSPragmaCustomFoldingProvider
extends CustomFoldingProvider {
    private static final Pattern ourStart = Pattern.compile("#\\s*pragma*\\s*region(\\s+.*)?");
    private static final Pattern ourEnd = Pattern.compile("#\\s*pragma*\\s*endregion.*");

    public boolean isCustomRegionStart(@NotNull String elementText) {
        if (elementText == null) {
            MSPragmaCustomFoldingProvider.$$$reportNull$$$0(0);
        }
        return ourStart.matcher(elementText).matches();
    }

    public boolean isCustomRegionEnd(@NotNull String elementText) {
        if (elementText == null) {
            MSPragmaCustomFoldingProvider.$$$reportNull$$$0(1);
        }
        return ourEnd.matcher(elementText).matches();
    }

    public String getPlaceholderText(@NotNull String elementText) {
        String placeholder;
        Matcher matcher;
        if (elementText == null) {
            MSPragmaCustomFoldingProvider.$$$reportNull$$$0(2);
        }
        if ((matcher = ourStart.matcher(elementText)).matches() && (placeholder = matcher.group(1)) != null && !(placeholder = placeholder.trim()).isEmpty()) {
            return placeholder;
        }
        return "...";
    }

    public boolean wrapStartEndMarkerTextInLanguageSpecificComment() {
        return false;
    }

    public boolean isSupportedBy(FoldingBuilder foldingBuilder) {
        return foldingBuilder instanceof OCFoldingBuilder;
    }

    @Nls
    public String getDescription() {
        return OCBundle.message("action.CIDR.Lang.Wrap.By.Pragma.Region", new Object[0]);
    }

    @NonNls
    public String getStartString() {
        return "#pragma region ?";
    }

    @NonNls
    public String getEndString() {
        return "#pragma endregion";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "elementText";
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/folding/MSPragmaCustomFoldingProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomRegionStart";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomRegionEnd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPlaceholderText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

