/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.structureVIew;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBundle;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.structureVIew.OCStructureViewElement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class OCKindSorter
implements Sorter {
    public static final Sorter INSTANCE = new OCKindSorter();

    private OCKindSorter() {
    }

    public Comparator getComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.compare(1.getWeight(o1), 1.getWeight(o2));
            }

            private static int getWeight(Object tro) {
                if (!(tro instanceof OCStructureViewElement)) {
                    return Weights.QNGroup.ordinal();
                }
                PsiElement o = ((OCStructureViewElement)tro).getValue();
                if (o instanceof OCCppNamespace) {
                    return Weights.CppNamespace.ordinal();
                }
                if (o instanceof OCStructLike) {
                    return Weights.StructLike.ordinal();
                }
                if (o instanceof OCClassDeclaration) {
                    return Weights.ClassDeclaration.ordinal();
                }
                if (o instanceof OCFunctionDefinition) {
                    OCFunctionSymbol symbol = ((OCFunctionDefinition)o).getSymbol();
                    if (symbol != null) {
                        if (symbol.isCppConstructor()) {
                            return Weights.Constructor.ordinal();
                        }
                        if (symbol.isCppDestructor()) {
                            return Weights.Destructor.ordinal();
                        }
                    }
                    if (o.getParent() instanceof OCClassDeclaration) {
                        return Weights.ChildInClassDeclaration.ordinal();
                    }
                    return Weights.FunctionDefinition.ordinal();
                }
                if (o instanceof OCMethod) {
                    OCMethodSymbol symbol = (OCMethodSymbol)((OCMethod)o).getSymbol();
                    if (symbol != null && symbol.isConstructorMethod()) {
                        return Weights.Constructor.ordinal();
                    }
                    return Weights.FunctionDefinition.ordinal();
                }
                if (o instanceof OCDeclarator) {
                    OCSymbol symbol = ((OCDeclarator)o).getSymbol();
                    if (symbol != null) {
                        return switch (symbol.getKind()) {
                            case OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION -> Weights.Constructor.ordinal();
                            case OCSymbolKind.FUNCTION_DECLARATION, OCSymbolKind.FUNCTION_PREDECLARATION -> Weights.FunctionDefinition.ordinal();
                            case OCSymbolKind.PROPERTY -> Weights.Property.ordinal();
                            case OCSymbolKind.INSTANCE_VARIABLE, OCSymbolKind.STRUCT_FIELD -> Weights.LocalVariable.ordinal();
                            case OCSymbolKind.TYPEDEF -> Weights.Typedef.ordinal();
                            case OCSymbolKind.GLOBAL_VARIABLE, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION -> Weights.GlobalVariable.ordinal();
                            default -> Weights.Declarator.ordinal();
                        };
                    }
                    return Weights.Declarator.ordinal();
                }
                if (o instanceof OCDirective) {
                    return Weights.Directive.ordinal();
                }
                return Integer.MAX_VALUE;
            }
        };
    }

    public boolean isVisible() {
        return true;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(StructureViewBundle.message((String)"action.sort.by.type", (Object[])new Object[0]), "", AllIcons.ObjectBrowser.SortByType);
    }

    @NotNull
    public String getName() {
        return "KIND";
    }

    static enum Weights {
        CppNamespace,
        StructLike,
        ClassDeclaration,
        QNGroup,
        Constructor,
        Destructor,
        FunctionDefinition,
        Property,
        LocalVariable,
        Typedef,
        ChildInClassDeclaration,
        GlobalVariable,
        Declarator,
        Directive;

    }
}

