/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConvertIfToTernaryIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(1);
        }
        return this.createConverter(element).isAvailable();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(3);
        }
        this.createConverter(element).invoke();
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.replace.if.else.with.ternary", (Object[])new Object[0]);
        if (string == null) {
            OCConvertIfToTernaryIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected Converter createConverter(PsiElement element) {
        return new Converter(element);
    }

    protected OCExpression getNewExpression(Converter converter) {
        return OCElementFactory.conditionalExpression(converter.getCondition(), converter.getThenExpression(), converter.getElseExpression());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCConvertIfToTernaryIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCConvertIfToTernaryIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    public class Converter {
        private OCStatement myThenStatement;
        private OCStatement myElseStatement;
        private OCStatement myOriginalElseStatement;
        private OCExpression myThenExpression;
        private OCExpression myElseExpression;
        private OCExpression myCondition;
        private OCIfStatement myStatement;

        public Converter(PsiElement element) {
            PsiElement sibling;
            OCIfStatement statement = (OCIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCIfStatement.class, (boolean)false);
            if (statement == null || statement.isConstexpr()) {
                return;
            }
            this.myStatement = statement;
            OCCondition condition = statement.getCondition();
            if (condition == null || condition.getExpression() == null) {
                return;
            }
            this.myCondition = condition.getExpression();
            this.myThenStatement = statement.getThenBranch();
            this.myElseStatement = statement.getElseBranch();
            if (this.myElseStatement == null && (sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement)) instanceof OCReturnStatement) {
                this.myElseStatement = (OCStatement)sibling;
            }
            this.myOriginalElseStatement = this.myElseStatement;
            while (this.myThenStatement instanceof OCBlockStatement && ((OCBlockStatement)this.myThenStatement).getStatements().size() == 1) {
                this.myThenStatement = ((OCBlockStatement)this.myThenStatement).getStatements().get(0);
            }
            while (this.myElseStatement instanceof OCBlockStatement && ((OCBlockStatement)this.myElseStatement).getStatements().size() == 1) {
                this.myElseStatement = ((OCBlockStatement)this.myElseStatement).getStatements().get(0);
            }
            if (this.myThenStatement == null || this.myElseStatement == null) {
                return;
            }
            Pair<PsiElement, PsiElement> diff = OCElementUtil.getElementsDiff(this.myThenStatement, this.myElseStatement);
            if (diff == null) {
                return;
            }
            PsiElement first = Converter.getConvertibleElement((PsiElement)diff.first, this.myThenStatement);
            PsiElement second = Converter.getConvertibleElement((PsiElement)diff.second, this.myElseStatement);
            if (first instanceof OCExpression && second instanceof OCExpression) {
                this.myThenExpression = (OCExpression)first;
                this.myElseExpression = (OCExpression)second;
            }
        }

        @Nullable
        private static PsiElement getConvertibleElement(@Nullable PsiElement element, @NotNull OCStatement branchStatement) {
            OCCallExpression parentCall;
            if (branchStatement == null) {
                Converter.$$$reportNull$$$0(0);
            }
            PsiElement convertibleElement = element;
            PsiElement parentTemplateList = PsiTreeUtil.getParentOfType((PsiElement)element, OCTemplateArgumentList.class);
            if (parentTemplateList != null && PsiTreeUtil.isAncestor((PsiElement)branchStatement, (PsiElement)parentTemplateList, (boolean)false)) {
                convertibleElement = parentTemplateList;
            }
            if ((parentCall = (OCCallExpression)PsiTreeUtil.getParentOfType((PsiElement)convertibleElement, OCCallExpression.class)) != null && !PsiTreeUtil.isAncestor((PsiElement)parentCall.getArgumentList(), (PsiElement)convertibleElement, (boolean)false)) {
                convertibleElement = parentCall;
            }
            while (convertibleElement != null && !(convertibleElement instanceof OCExpression) && convertibleElement != branchStatement) {
                convertibleElement = convertibleElement.getParent();
            }
            return convertibleElement;
        }

        public OCExpression getCondition() {
            return this.myCondition;
        }

        public OCExpression getThenExpression() {
            return this.myThenExpression;
        }

        public OCExpression getElseExpression() {
            return this.myElseExpression;
        }

        public boolean isAvailable() {
            OCType guessedType2;
            if (this.myThenExpression == null || this.myElseExpression == null) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myThenExpression)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myThenStatement)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myElseExpression)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myElseStatement)) {
                return false;
            }
            if (!OCCodeInsightUtil.isValid(this.myCondition)) {
                return false;
            }
            OCType guessedType1 = this.myThenExpression.getResolvedType().getGuessedType();
            OCType type = guessedType1.getLeastCommonType(guessedType2 = this.myElseExpression.getResolvedType().getGuessedType(), OCResolveContext.forPsi(this.myThenExpression));
            return !type.isUnknown() && !type.isVoid();
        }

        public void invoke() {
            OCExpression result = OCConvertIfToTernaryIntentionAction.this.getNewExpression(this);
            OCParenthesesUtils.replaceExpressionAndRemoveAppendParentheses(this.myThenExpression, result);
            OCChangeUtil.replaceHandlingMacros(this.myStatement, this.myThenStatement);
            OCChangeUtil.delete(this.myOriginalElseStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchStatement", "com/jetbrains/cidr/lang/intentions/OCConvertIfToTernaryIntentionAction$Converter", "getConvertibleElement"));
        }
    }
}

