/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSplitIntoSeparateDeclarationsIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.split.into.separate.declarations", (Object[])new Object[0]);
        if (string == null) {
            OCSplitIntoSeparateDeclarationsIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCSplitIntoSeparateDeclarationsIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        boolean isInBlock;
        PsiElement element;
        if (project == null) {
            OCSplitIntoSeparateDeclarationsIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid(element = OCSplitIntoSeparateDeclarationsIntentionAction.getElement(editor, psiFile))) {
            return false;
        }
        boolean bl = isInBlock = PsiTreeUtil.getParentOfType((PsiElement)element, OCBlockStatement.class) != null;
        if (element instanceof OCDeclaration) {
            return (!isInBlock || element.getParent().getParent() instanceof OCBlockStatement) && OCSplitIntoSeparateDeclarationsIntentionAction.hasSplittableDeclarators(element);
        }
        if (element instanceof OCDeclarator) {
            return (!isInBlock || element.getParent().getParent().getParent() instanceof OCBlockStatement) && OCSplitIntoSeparateDeclarationsIntentionAction.hasSplittableDeclarators(element.getParent());
        }
        if (element instanceof OCSynthesizeProperty) {
            return OCSplitIntoSeparateDeclarationsIntentionAction.hasSplittableDeclarators(element.getParent());
        }
        return false;
    }

    private static boolean hasSplittableDeclarators(@Nullable PsiElement element) {
        if (element instanceof OCStructuredBindingDeclaration) {
            return false;
        }
        if (element instanceof OCDeclaration) {
            return ((OCDeclaration)element).getDeclarators().size() > 1;
        }
        if (element instanceof OCSynthesizePropertiesList) {
            return ((OCSynthesizePropertiesList)element).getProperties().size() > 1;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            OCSplitIntoSeparateDeclarationsIntentionAction.$$$reportNull$$$0(3);
        }
        if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)psiFile)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(psiFile.getViewProvider().getDocument());
        PsiElement element = OCSplitIntoSeparateDeclarationsIntentionAction.getElement(editor, psiFile);
        if (element instanceof OCDeclaration) {
            OCNormalizeUtil.normalizeDeclaration((OCDeclaration)element);
        } else if (element instanceof OCDeclarator) {
            OCNormalizeUtil.normalizeDeclarator((OCDeclarator)element);
        } else if (element instanceof OCSynthesizeProperty) {
            OCNormalizeUtil.normalizeSynthesizeStatement((OCSynthesizeProperty)element);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static PsiElement getElement(Editor editor, PsiFile file) {
        OCTypeElement typeElement;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        OCSymbolDeclarator declarator = (OCSymbolDeclarator)OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class, OCSynthesizeProperty.class);
        if (declarator == null && (typeElement = OCElementUtil.getAdjacentParentOfType(element, OCTypeElement.class)) != null && typeElement.getParent() instanceof OCDeclaration) {
            return typeElement.getParent();
        }
        return declarator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCSplitIntoSeparateDeclarationsIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCSplitIntoSeparateDeclarationsIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

