/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileWithOneLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKindContributor;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.psi.OCConfigurationOwner;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCPsiFile
extends PsiFileWithOneLanguage,
OCConfigurationOwner {
    @NotNull
    public OCFile getOCFile();

    @NotNull
    public OCLanguageKind getKind();

    @NotNull
    public PsiElement asElementFromOCFile(@NotNull PsiElement var1);

    public boolean isHeader();

    public boolean isInProjectSources();

    public boolean isInLibraries();

    @Contract(value="null -> null; !null -> !null")
    public static PsiElement tryGetElementFromOCFile(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        PsiFile file = psiElement.getContainingFile();
        if (file instanceof OCPsiFile) {
            return ((OCPsiFile)file).asElementFromOCFile(psiElement);
        }
        return psiElement;
    }

    @Contract(value="null -> null")
    @Nullable
    public static OCLanguageKind getKind(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        if (file instanceof OCPsiFile) {
            return ((OCPsiFile)file).getKind();
        }
        return OCLanguageKindContributor.getSupportedLanguageKind(file);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static OCNamespaceLikeSymbol getMembersContainer(@Nullable PsiFile file, boolean onlyTypes) {
        if (!OCLanguageUtils.supportsResolve(file)) {
            return null;
        }
        OCFileGlobalSymbolsCache cache = OCFileGlobalSymbolsCache.getInstance(file.getProject());
        return onlyTypes ? cache.typesOnlyTableForFile(file) : cache.lightTableForFile(file);
    }
}

