/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCGeneratedInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class OCChangeInfo
implements ChangeInfo {
    private PsiElement myContext;
    private OCParameterInfo[] myNewParameters;
    private OCMethodDescriptor myOldMethod;
    private List<OCCallable<?>> myNewMethods;
    private OCCallable myNewMethod;
    private String myNewName;
    private String myNewReturnType;
    private OCClassDeclaration myNewContainerClass;
    private OCCallableKind myNewCallableKind;
    private String mySelfParameterName;
    private String myNewSignatureWithInitializers;
    private String myNewSignatureWithoutInitializers;
    private boolean myChangeUsages;
    private OCGeneratedInfo myGeneratedInfo;
    private boolean myParameterSetOrOrderChanged;
    private boolean myReturnTypeChanged;
    private boolean myChangeAncestors;

    public OCChangeInfo(PsiElement context, OCMethodDescriptor oldMethod, String newName, OCParameterInfo[] newParameters, String newReturnType, OCClassDeclaration newContainerClass, OCCallableKind newCallableKind, String newSignatureWithInitializers, String newSignatureWithoutInitializers, boolean changeUsages, boolean changeAncestors, OCGeneratedInfo generatedInfo) {
        this.myContext = context;
        this.myOldMethod = oldMethod;
        this.myNewName = newName;
        this.myNewReturnType = newReturnType;
        this.myNewContainerClass = newContainerClass;
        this.myNewParameters = newParameters;
        this.myNewCallableKind = newCallableKind;
        this.myNewSignatureWithInitializers = newSignatureWithInitializers;
        this.myNewSignatureWithoutInitializers = newSignatureWithoutInitializers;
        this.myChangeUsages = changeUsages;
        this.myChangeAncestors = changeAncestors;
        this.myGeneratedInfo = generatedInfo;
        for (OCParameterInfo parameter : newParameters) {
            if (!parameter.isSelfParameter()) continue;
            this.mySelfParameterName = parameter.getName();
        }
        this.myParameterSetOrOrderChanged = this.innerIsParameterSetOrOrderChanged();
        this.myReturnTypeChanged = this.innerIsReturnTypeChanged();
    }

    public boolean isParameterSetOrOrderChanged() {
        return this.myParameterSetOrOrderChanged;
    }

    public boolean isAddExplicitKeyword() {
        return this.myOldMethod.isAddExplicitKeyword();
    }

    public boolean isAddConstQualifier() {
        return this.myOldMethod.isAddConstQualifier();
    }

    public boolean isAddConstexprSpecifier() {
        return this.myOldMethod.isAddConstexprSpecifier();
    }

    public boolean isAddNoexceptSpecifier() {
        return this.myOldMethod.isAddNoexceptSpecifier();
    }

    private boolean innerIsParameterSetOrOrderChanged() {
        boolean newHasNoParams;
        if (this.myNewCallableKind != this.myOldMethod.getCallableKind()) {
            return true;
        }
        boolean oldHasNoParams = this.myOldMethod.getParametersCount() == 0 || this.myOldMethod.getMethodSymbol() instanceof OCFunctionSymbol && ((OCFunctionSymbol)this.myOldMethod.getMethodSymbol()).getType().hasNoParameters();
        boolean bl = newHasNoParams = this.myNewParameters.length == 0 || this.myNewParameters.length == 1 && this.myNewParameters[0].getType() instanceof OCVoidType;
        if (oldHasNoParams != newHasNoParams) {
            return true;
        }
        if (this.myNewParameters.length != this.myOldMethod.getParametersCount()) {
            return true;
        }
        OCCallable oldCallable = this.myOldMethod.getMethod();
        if (oldCallable instanceof OCMethod && this.myNewSignatureWithoutInitializers.contains(":") != ((OCMethod)oldCallable).getSelector().endsWith(":")) {
            return true;
        }
        for (int i = 0; i < this.myNewParameters.length; ++i) {
            if (this.myNewParameters[i].getOldIndex() != i) {
                return true;
            }
            if (!this.myNewParameters[i].getSelector().isEmpty() && oldCallable instanceof OCMethod && ((OCMethodSelectorPart)oldCallable.getParameters().get(i)).getSelectorIdentifier() == null) {
                return true;
            }
            if (this.myNewParameters[i].getName().isEmpty() == this.myOldMethod.getParameter(i).getName().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterTypesChanged() {
        if (this.myNewParameters.length != this.myOldMethod.getParametersCount()) {
            return true;
        }
        for (int i = 0; i < this.myNewParameters.length; ++i) {
            OCParameterInfo newParam = this.myNewParameters[i];
            OCType newParamType = newParam.getType();
            if (newParamType == null) {
                return true;
            }
            OCParameterInfo oldParam = this.myOldMethod.getParameter(i);
            OCType oldParamType = oldParam.getType();
            boolean hasDifferentName = false;
            if (oldParamType != null) {
                OCType oldResolvedType = oldParamType.resolve(this.myContext);
                boolean bl = hasDifferentName = !StringUtil.equals((CharSequence)newParamType.getName(), (CharSequence)oldResolvedType.getName());
            }
            if (!hasDifferentName && newParamType.equals(oldParamType, true, true, OCResolveContext.forPsi(this.myContext)) && newParam.getInitializer() == oldParam.getInitializer()) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterNamesChanged() {
        if (this.myNewParameters.length != this.myOldMethod.getParametersCount()) {
            return true;
        }
        for (int i = 0; i < this.myNewParameters.length; ++i) {
            if (Objects.equals(this.myNewParameters[i].getName(), this.myOldMethod.getParameter(i).getName()) && Objects.equals(this.myNewParameters[i].getSelector(), this.myOldMethod.getParameter(i).getSelector())) continue;
            return true;
        }
        return false;
    }

    public boolean isReturnTypeChanged() {
        return this.myReturnTypeChanged;
    }

    private boolean innerIsReturnTypeChanged() {
        return !this.myNewReturnType.replaceAll(" ", "").equals(this.myOldMethod.getReturnTypeText(this.myContext).replaceAll(" ", ""));
    }

    public boolean isNameChanged() {
        return !this.myNewName.equals(this.myOldMethod.getName());
    }

    public boolean isGenerateDelegate() {
        return false;
    }

    public OCParameterInfo @NotNull [] getNewParameters() {
        if (this.myNewParameters == null) {
            OCChangeInfo.$$$reportNull$$$0(0);
        }
        return this.myNewParameters;
    }

    public OCCallableKind getNewCallableKind() {
        return this.myNewCallableKind;
    }

    public OCMethodDescriptor getOldMethodDescriptor() {
        return this.myOldMethod;
    }

    public OCCallable getMethod() {
        return this.myNewMethod != null ? this.myNewMethod : this.myOldMethod.getMethod();
    }

    public void setNewMethod(OCCallable newMethod) {
        this.myNewMethod = newMethod;
    }

    public void addNewMethod(OCCallable newMethod) {
        if (this.myNewMethods == null) {
            this.myNewMethods = new ArrayList();
        }
        this.myNewMethods.add(newMethod);
    }

    public List<OCCallable<?>> getNewMethods() {
        return this.myNewMethods == null ? Collections.emptyList() : this.myNewMethods;
    }

    public OCClassDeclaration getNewContainerClass() {
        return this.myNewContainerClass;
    }

    public boolean isChangeUsages() {
        return this.myChangeUsages;
    }

    public boolean isChangeAncestors() {
        return this.myChangeAncestors;
    }

    public OCGeneratedInfo getGenerated() {
        return this.myGeneratedInfo;
    }

    public String getNewReturnType() {
        return this.myNewReturnType;
    }

    public String getNewName() {
        return this.myNewName;
    }

    public String getNewSignature(boolean addInitializers) {
        return addInitializers ? this.myNewSignatureWithInitializers : this.myNewSignatureWithoutInitializers;
    }

    public abstract String getNewInheritedSignature(OCCallable var1, boolean var2);

    public String getNewParameterName(boolean isInherited, OCCallable callable, OCParameterInfo newParam) {
        List<PsiNamedElement> inheritedParameters = callable.getParameters();
        if (!isInherited || newParam.getOldIndex() < 0 || newParam.getOldIndex() >= this.myOldMethod.getParametersCount() || newParam.getType() instanceof OCVoidType || inheritedParameters == null || newParam.getOldIndex() >= inheritedParameters.size()) {
            return newParam.getName();
        }
        OCParameterInfo oldParam = this.myOldMethod.getParameter(newParam.getOldIndex());
        PsiNamedElement inheritedParam = inheritedParameters.get(newParam.getOldIndex());
        String oldParamName = oldParam.getName();
        String inheritedParamName = inheritedParam.getName();
        if (inheritedParamName == null) {
            return newParam.getName();
        }
        if (!(oldParamName.equals(inheritedParamName) || OCCallableUtil.isParameterNameEmpty(oldParamName) && OCCallableUtil.isParameterNameEmpty(inheritedParamName))) {
            return inheritedParamName;
        }
        if (callable.getBody() == null || OCCodeInsightUtil.isUniqueInScope(OCSymbolKind.PARAMETER, newParam.getName(), callable.getBody(), callable.getProject()) || OCCallableUtil.isParameterNameEmpty(inheritedParamName)) {
            return newParam.getName();
        }
        return inheritedParamName;
    }

    public String getSelfParameterName() {
        return this.mySelfParameterName;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public Language getLanguage() {
        return LanguageUtils.getInstance().getSlowLanguage();
    }

    public boolean willBeMethod() {
        return OCCallableKind.METHOD == this.getNewCallableKind();
    }

    public boolean willBeFunction() {
        return OCCallableKind.FUNCTION == this.getNewCallableKind();
    }

    public boolean willBeBlock() {
        return OCCallableKind.BLOCK == this.getNewCallableKind();
    }

    public boolean willBeLambda() {
        return OCCallableKind.LAMBDA == this.getNewCallableKind();
    }

    public boolean willBeBlockOrLambda() {
        return OCCallableKind.BLOCK == this.getNewCallableKind() || OCCallableKind.LAMBDA == this.getNewCallableKind();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeInfo", "getNewParameters"));
    }
}

