/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTopLevelModel
extends UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, PsiElement, OCMemberInfo> {
    private boolean myImportTargetFromSource;
    private boolean myImportSourceFromTarget;
    private VirtualFile mySourceFile;
    private Supplier<Boolean> myWrapMode;
    private Supplier<OCNamespaceSymbol> myTargetNamespace;
    private Project myProject;
    private final MyModel myUsesModel;

    public OCTopLevelModel(@Nullable PsiElement source, @NotNull Supplier<Boolean> wrapMode, @NotNull Supplier<OCNamespaceSymbol> targetNamespace, @NotNull Project project) {
        if (wrapMode == null) {
            OCTopLevelModel.$$$reportNull$$$0(0);
        }
        if (targetNamespace == null) {
            OCTopLevelModel.$$$reportNull$$$0(1);
        }
        if (project == null) {
            OCTopLevelModel.$$$reportNull$$$0(2);
        }
        super(source);
        this.mySourceFile = source != null ? source.getContainingFile().getVirtualFile() : null;
        this.myUsesModel = new MyModel(source);
        this.myWrapMode = wrapMode;
        this.myTargetNamespace = targetNamespace;
        this.myProject = project;
    }

    public boolean importTargetFromSource() {
        return this.myImportTargetFromSource;
    }

    public boolean importSourceFromTarget() {
        return this.myImportSourceFromTarget && !this.myImportTargetFromSource;
    }

    protected boolean insertImports() {
        return true;
    }

    @Nullable
    public String getConflictMessage(@NotNull OCMemberInfo memberInfo, @NotNull OCSymbol symbol, @NotNull Project project) {
        if (memberInfo == null) {
            OCTopLevelModel.$$$reportNull$$$0(3);
        }
        if (symbol == null) {
            OCTopLevelModel.$$$reportNull$$$0(4);
        }
        if (project == null) {
            OCTopLevelModel.$$$reportNull$$$0(5);
        }
        OCResolveContext context = OCResolveContext.forSymbol(symbol, project);
        OCSymbol owner = OCTopLevelModel.ownerInDifferentFile(memberInfo.getSymbol(), context);
        if (this.myWrapMode.get().booleanValue() && memberInfo.isChecked() && owner != null) {
            String message = "Can't move members of " + owner.getNameWithKindLowercase(context);
            VirtualFile file = owner.getContainingFile();
            if (file != null) {
                message = message + " from file '" + file.getName() + "'";
            }
            message = message + " to different namespace";
            return message;
        }
        if (super.checkForProblems((MemberInfoBase)memberInfo) != 0) {
            OCSymbolHolderVirtualPsiElement s;
            if (symbol instanceof OCSymbolWithQualifiedName && (owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context)) instanceof OCStructSymbol && this.myUsesModel.getDependenciesOf(s = new OCSymbolHolderVirtualPsiElement(owner, project)).contains(s)) {
                return null;
            }
            return symbol.getNameWithKindUppercase(context) + " will not be able to access the moved code";
        }
        if (this.myUsesModel.checkForProblems(memberInfo) != 0) {
            OCSymbol separatedMember = this.findSeparatedMember(symbol, context);
            if (separatedMember != null) {
                return separatedMember.getNameWithKindUppercase(context) + " must be in the same namespace as " + symbol.getNameWithKindLowercase(context);
            }
            return symbol.getNameWithKindUppercase(context) + " will be inaccessible in the moved code";
        }
        return "";
    }

    private OCSymbol findSeparatedMember(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        if (symbol == null) {
            OCTopLevelModel.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCTopLevelModel.$$$reportNull$$$0(7);
        }
        if ((this.myWrapMode.get().booleanValue() || this.myTargetNamespace.get() != null && !this.myTargetNamespace.get().isGlobalNamespace()) && symbol instanceof OCStructSymbol) {
            for (OCSymbolHolderVirtualPsiElement oCSymbolHolderVirtualPsiElement : this.myUsesModel.getDependenciesOf(new OCSymbolHolderVirtualPsiElement(symbol, context.getProject()))) {
                if (!(oCSymbolHolderVirtualPsiElement.getSymbol() instanceof OCSymbolWithQualifiedName) || ((OCSymbolWithQualifiedName)oCSymbolHolderVirtualPsiElement.getSymbol()).getResolvedOwner(context) != symbol) continue;
                return oCSymbolHolderVirtualPsiElement.getSymbol();
            }
        }
        return null;
    }

    @Nullable
    private static OCSymbol ownerInDifferentFile(@NotNull OCSymbol symbol, @NotNull OCResolveContext context) {
        OCSymbolWithQualifiedName owner;
        if (symbol == null) {
            OCTopLevelModel.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCTopLevelModel.$$$reportNull$$$0(9);
        }
        if (symbol instanceof OCSymbolWithQualifiedName && (owner = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context)) != null && !Comparing.equal((Object)owner.getContainingFile(), (Object)symbol.getContainingFile())) {
            return owner;
        }
        return null;
    }

    public int checkForProblems(@NotNull OCMemberInfo memberInfo) {
        if (memberInfo == null) {
            OCTopLevelModel.$$$reportNull$$$0(10);
        }
        OCResolveContext context = OCResolveContext.forSymbol(memberInfo.getSymbol(), this.myProject);
        if (this.myWrapMode.get().booleanValue() && memberInfo.isChecked() && OCTopLevelModel.ownerInDifferentFile(memberInfo.getSymbol(), context) != null) {
            return 2;
        }
        if (this.myUsesModel.checkForProblems(memberInfo) != 0) {
            this.myImportSourceFromTarget = true;
            return this.findSeparatedMember(memberInfo.getSymbol(), context) != null ? 2 : 1;
        }
        if (super.checkForProblems((MemberInfoBase)memberInfo) != 0) {
            this.myImportTargetFromSource = this.mySourceFile != null && this.mySourceFile.equals(memberInfo.getSymbol().getContainingFile());
            return 1;
        }
        return 0;
    }

    public void memberInfoChanged(@NotNull MemberInfoChange<OCSymbolHolderVirtualPsiElement, OCMemberInfo> event) {
        if (event == null) {
            OCTopLevelModel.$$$reportNull$$$0(11);
        }
        this.myImportTargetFromSource = false;
        this.myImportSourceFromTarget = false;
        super.memberInfoChanged(event);
        this.myUsesModel.memberInfoChanged(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapMode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNamespace";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberInfo";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/move/OCTopLevelModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getConflictMessage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findSeparatedMember";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "ownerInDifferentFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForProblems";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "memberInfoChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyModel
    extends AbstractUsesDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, PsiElement, OCMemberInfo> {
        private MyModel(PsiElement source) {
            super(source, null, false);
        }

        protected int doCheck(@NotNull OCMemberInfo memberInfo, int problem) {
            if (memberInfo == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            return problem;
        }

        public Set<? extends OCSymbolHolderVirtualPsiElement> getDependenciesOf(OCSymbolHolderVirtualPsiElement element) {
            return this.myMemberDependencyGraph.getDependenciesOf((PsiElement)element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfo", "com/jetbrains/cidr/lang/refactoring/move/OCTopLevelModel$MyModel", "doCheck"));
        }
    }
}

