/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCAvailabilityExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBoxedExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCommaExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCCppCoawaitExpression;
import com.jetbrains.cidr.lang.psi.OCCppDeleteExpression;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppTypeidExpression;
import com.jetbrains.cidr.lang.psi.OCEncodeExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFoldExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCNoexceptExpression;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatementExpression;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCVariadicPackExpression;
import com.jetbrains.cidr.lang.psi.impl.OCDefinedDirectiveImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPsiExprClassifierVisitor
extends OCVisitor {
    private OCExprValueCategory myResult;
    @NotNull
    private final OCResolveContext myContext;

    public OCPsiExprClassifierVisitor(@NotNull OCResolveContext context) {
        if (context == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(0);
        }
        this.myContext = context;
    }

    @NotNull
    public OCExprValueCategory getResult() {
        assert (this.myResult != null);
        OCExprValueCategory oCExprValueCategory = this.myResult;
        if (oCExprValueCategory == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(1);
        }
        return oCExprValueCategory;
    }

    private void setResult(@NotNull OCExprValueCategory result) {
        if (result == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(2);
        }
        assert (this.myResult == null);
        this.myResult = result;
    }

    @Nullable
    private static OCFunctionSymbol getOperatorSymbol(@Nullable PsiReference reference) {
        if (!(reference instanceof OCOperatorReference)) {
            return null;
        }
        OCSymbol first = (OCSymbol)ContainerUtil.getFirstItem(((OCOperatorReference)reference).resolveToSymbols());
        if (first == null) {
            return null;
        }
        if (!(first instanceof OCFunctionSymbol)) {
            OCLog.LOG.warn("Operator is not function symbol: " + String.valueOf(first));
            return null;
        }
        return (OCFunctionSymbol)first;
    }

    @Override
    public void visitDefinedDirective(OCDefinedDirectiveImpl directive) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(3);
        }
        OCLog.LOG.error(String.format("Not an expression: %s(`%s`)", element.toString(), element.getText()));
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitExpression(OCExpression expr) {
        OCLog.LOG.error(String.format("Expression not handled: %s(`%s`)", expr.toString(), expr.getTextWithMacros()));
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitThrowExpression(OCThrowExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitCommaExpression(OCCommaExpression e) {
        this.setResult(OCExprValueCategory.classify(e.getTailExpression(), this.myContext) == OCExprValueCategory.LValue ? OCExprValueCategory.LValue : OCExprValueCategory.PRValue);
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression e) {
        OCFunctionSymbol operatorSymbol = OCPsiExprClassifierVisitor.getOperatorSymbol(e.getReference());
        this.setResult(operatorSymbol == null ? OCExprValueCategory.LValue : this.byReturnType(operatorSymbol));
    }

    @NotNull
    private OCExprValueCategory byReturnType(@NotNull OCFunctionSymbol symbol) {
        if (symbol == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(4);
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.byReturnType(symbol.getType().getReturnType().resolve(this.myContext));
        if (oCExprValueCategory == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(5);
        }
        return oCExprValueCategory;
    }

    @Override
    public void visitConditionalExpression(OCConditionalExpression e) {
        if (!this.myContext.isCpp()) {
            this.setResult(OCExprValueCategory.PRValue);
            return;
        }
        OCExpression E1 = OCParenthesesUtils.diveIntoParentheses(e.getPositiveExpression(true));
        OCExpression E2 = OCParenthesesUtils.diveIntoParentheses(e.getNegativeExpression());
        if (E1 == null || E2 == null) {
            this.setResult(OCExprValueCategory.PRValue);
            return;
        }
        boolean throw1 = E1 instanceof OCThrowExpression;
        boolean throw2 = E2 instanceof OCThrowExpression;
        if (throw1 && throw2) {
            this.setResult(OCExprValueCategory.PRValue);
        } else if (throw1) {
            E2.accept(this);
        } else if (throw2) {
            E1.accept(this);
        } else {
            OCExprValueCategory c2;
            OCExprValueCategory c1 = OCExprValueCategory.classify(E1, this.myContext);
            if (c1 == (c2 = OCExprValueCategory.classify(E2, this.myContext)) && c1 != OCExprValueCategory.PRValue && E1.getResolvedType(this.myContext).equalsAfterResolving(E2.getResolvedType(this.myContext), this.myContext)) {
                this.setResult(c1);
            } else {
                this.setResult(OCExprValueCategory.PRValue);
            }
        }
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression e) {
        OCFunctionSymbol operatorSymbol = OCPsiExprClassifierVisitor.getOperatorSymbol(e.getReference());
        this.setResult(operatorSymbol == null ? this.byBinaryOperator(e) : this.byReturnType(operatorSymbol));
    }

    @NotNull
    private OCExprValueCategory byBinaryOperator(OCBinaryExpression e) {
        OCElementType sign = e.getOperationSign();
        if (sign == OCLexerTokenTypes.DOT_MUL && e.getLeft() != null && (e.getRight() == null || this.isPointerToDataMember(e.getRight()))) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.classify(e.getLeft(), this.myContext);
            if (oCExprValueCategory == null) {
                OCPsiExprClassifierVisitor.$$$reportNull$$$0(6);
            }
            return oCExprValueCategory;
        }
        if (sign == OCLexerTokenTypes.DEREF_MUL && (e.getRight() == null || this.isPointerToDataMember(e.getRight()))) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCPsiExprClassifierVisitor.$$$reportNull$$$0(7);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(8);
        }
        return oCExprValueCategory;
    }

    private boolean isPointerToDataMember(@NotNull OCExpression right) {
        OCType type;
        if (right == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(9);
        }
        if (!((type = right.getResolvedType(this.myContext)) instanceof OCPointerType)) {
            return true;
        }
        return !(((OCPointerType)type).getRefType() instanceof OCFunctionType);
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression e) {
        OCFunctionSymbol operatorSymbol = OCPsiExprClassifierVisitor.getOperatorSymbol(e.getReference());
        this.setResult(operatorSymbol == null ? OCPsiExprClassifierVisitor.byBuiltInUnaryOperationSign(e.getOperationSign(), true) : this.byReturnType(operatorSymbol));
    }

    @NotNull
    private static OCExprValueCategory byBuiltInUnaryOperationSign(@NotNull OCElementType sign, boolean prefix) {
        if (sign == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(10);
        }
        if (sign == OCLexerTokenTypes.MUL || prefix && (sign == OCLexerTokenTypes.PLUSPLUS || sign == OCLexerTokenTypes.MINUSMINUS)) {
            OCExprValueCategory oCExprValueCategory = OCExprValueCategory.LValue;
            if (oCExprValueCategory == null) {
                OCPsiExprClassifierVisitor.$$$reportNull$$$0(11);
            }
            return oCExprValueCategory;
        }
        OCExprValueCategory oCExprValueCategory = OCExprValueCategory.PRValue;
        if (oCExprValueCategory == null) {
            OCPsiExprClassifierVisitor.$$$reportNull$$$0(12);
        }
        return oCExprValueCategory;
    }

    @Override
    public void visitPrefixExpression(OCPrefixExpression e) {
        OCFunctionSymbol operatorSymbol = OCPsiExprClassifierVisitor.getOperatorSymbol(e.getReference());
        this.setResult(operatorSymbol == null ? OCPsiExprClassifierVisitor.byBuiltInUnaryOperationSign(e.getOperationSign(), true) : this.byReturnType(operatorSymbol));
    }

    @Override
    public void visitCastExpression(OCCastExpression e) {
        if (!this.myContext.isCpp() && e.getOperand() instanceof OCCompoundInitializer) {
            this.setResult(OCExprValueCategory.LValue);
            return;
        }
        OCType castType = e.getCastType().resolve(this.myContext);
        if (castType instanceof OCCppReferenceType) {
            OCCppReferenceType ref = (OCCppReferenceType)castType;
            if (ref.isRvalueRef()) {
                this.setResult(OCExprValueCategory.XValue);
            } else {
                this.setResult(OCExprValueCategory.LValue);
            }
        } else {
            this.setResult(OCExprValueCategory.PRValue);
        }
    }

    @Override
    public void visitSizeofExpression(OCSizeofExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitNoexceptExpression(OCNoexceptExpression noexceptExpr) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitPostfixExpression(OCPostfixExpression e) {
        OCFunctionSymbol operatorSymbol = OCPsiExprClassifierVisitor.getOperatorSymbol(e.getReference());
        this.setResult(operatorSymbol == null ? OCPsiExprClassifierVisitor.byBuiltInUnaryOperationSign(e.getOperationSign(), false) : this.byReturnType(operatorSymbol));
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression e) {
        OCExpression indexExpr = e.getIndexExpression();
        if (indexExpr == null) {
            this.setResult(OCExprValueCategory.LValue);
        } else {
            OCFunctionSymbol operatorSymbol = OCPsiExprClassifierVisitor.getOperatorSymbol(e.getReference());
            if (operatorSymbol == null) {
                this.setResult(OCExprValueCategory.LValue);
            } else {
                this.setResult(this.byReturnType(operatorSymbol));
            }
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression e) {
        OCExpression caller = e.getFunctionReferenceExpression();
        OCSymbol symbol = null;
        if (caller instanceof OCReferenceExpression) {
            symbol = ((OCReferenceExpression)caller).resolveToSymbol(this.myContext);
        } else if (caller instanceof OCQualifiedExpression) {
            OCQualifiedExpression qualifiedExpression = (OCQualifiedExpression)caller;
            symbol = qualifiedExpression.resolveToSymbol(this.myContext, true, false, false);
        }
        if (symbol instanceof OCFunctionSymbol) {
            this.setResult(this.byReturnType((OCFunctionSymbol)symbol));
        } else {
            this.setResult(OCExprValueCategory.PRValue);
        }
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression E1) {
        OCSymbol symbol = E1.resolveToSymbol();
        if (!(symbol instanceof OCSymbolWithQualifiedName)) {
            if (E1.getQualifyingTokenKind() == OCLexerTokenTypes.DEREF) {
                this.setResult(OCExprValueCategory.LValue);
            } else {
                E1.getQualifier().accept(this);
            }
            return;
        }
        OCSymbolWithQualifiedName E2 = (OCSymbolWithQualifiedName)symbol;
        if (E2.getType() instanceof OCCppReferenceType) {
            this.setResult(OCExprValueCategory.LValue);
            return;
        }
        if (E2.isStatic()) {
            this.setResult(OCExprValueCategory.LValue);
            return;
        }
        if (E2.getResolvedKind(this.myContext) == OCSymbolKind.STRUCT_FIELD) {
            if (E1.getQualifyingTokenKind() == OCLexerTokenTypes.DEREF) {
                this.setResult(OCExprValueCategory.LValue);
            } else {
                E1.getQualifier().accept(this);
            }
        } else {
            this.setResult(OCExprValueCategory.PRValue);
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression e) {
        this.setResult(e.isCppThis() || e.getSelfSuperToken() == OCElementTypes.SelfSuperToken.SUPER ? OCExprValueCategory.PRValue : OCExprValueCategory.LValue);
    }

    @Override
    public void visitParenthesizedExpression(OCParenthesizedExpression e) {
        OCExpression operand = e.getOperand();
        if (operand != null) {
            operand.accept(this);
        } else {
            this.setResult(OCExprValueCategory.PRValue);
        }
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression e) {
        if (e.isStringLiteral() && !e.isNSStringLiteral()) {
            this.setResult(OCExprValueCategory.LValue);
        } else {
            this.setResult(OCExprValueCategory.PRValue);
        }
    }

    @Override
    public void visitCompoundInitializer(OCCompoundInitializer initializer) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitBoxedExpression(OCBoxedExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitSelectorExpression(OCSelectorExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitAvailabilityExpression(OCAvailabilityExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitEncodeExpression(OCEncodeExpression e) {
        this.setResult(OCExprValueCategory.LValue);
    }

    @Override
    public void visitProtocolExpression(OCProtocolExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitStatementExpression(OCStatementExpression statementExpression) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitCppNewExpression(OCCppNewExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitCppDeleteExpression(OCCppDeleteExpression e) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitVariadicPackExpression(OCVariadicPackExpression e) {
        OCExpression operand = e.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitCppTypeIdExpression(OCCppTypeidExpression expression) {
        this.setResult(OCExprValueCategory.LValue);
    }

    @Override
    public void visitFoldExpression(OCFoldExpression expression) {
        this.setResult(OCExprValueCategory.PRValue);
    }

    @Override
    public void visitCppCoawaitExpression(OCCppCoawaitExpression e) {
        OCExpression operand = e.getOperand();
        if (operand != null) {
            operand.accept(this);
        } else {
            this.setResult(OCExprValueCategory.PRValue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 8, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCPsiExprClassifierVisitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCPsiExprClassifierVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "byReturnType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "byBinaryOperator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "byBuiltInUnaryOperationSign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setResult";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "byReturnType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPointerToDataMember";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "byBuiltInUnaryOperationSign";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 8, 11, 12 -> new IllegalStateException(string);
        };
    }
}

