/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.lang.search.scopes.OCExplicitSourcesSearchScope;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScopeService;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.Collection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSearchScope {
    @NotNull
    public static GlobalSearchScope getGotoSymbolScope(@NotNull Project project, boolean includeNonProjectFiles) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = OCSearchScopeService.getInstance(project).getGotoSymbolScope(includeNonProjectFiles);
        if (globalSearchScope == null) {
            OCSearchScope.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(2);
        }
        GlobalSearchScope globalSearchScope = OCSearchScopeService.getInstance(project).getProjectSourcesScope();
        if (globalSearchScope == null) {
            OCSearchScope.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(@NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(4);
        }
        Collection collection = OCExplicitSourcesSearchScope.getExplicitlySpecifiedProjectSourceFiles((Project)project);
        if (collection == null) {
            OCSearchScope.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Contract(value="null, _->false")
    public static boolean isInProjectSources(@Nullable OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(6);
        }
        return symbol != null && OCSearchScopeService.getInstance(project).isInProjectSources(symbol);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable PsiElement element) {
        return element != null && OCSearchScopeService.getInstance(element.getProject()).isInProjectSources(element);
    }

    public static boolean isInProjectSources(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(7);
        }
        return file != null && OCSearchScope.getProjectSourcesScope(project).contains(file);
    }

    public static boolean isInProjectNonSources(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(8);
        }
        return file != null && OCSearchScopeService.getInstance(project).isInProjectNonSources(file);
    }

    public static boolean isInProject(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(9);
        }
        return file != null && OCSearchScopeService.getInstance(project).isInProject(file);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        return element != null && OCSearchScopeService.getInstance(element.getProject()).isInProjectSourcesOrLibraries(element);
    }

    public static boolean isInProjectSourcesOrLibraries(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(10);
        }
        return file != null && OCSearchScopeService.getInstance(project).isInProjectSourcesOrLibraries(file);
    }

    public static boolean isInProjectSourcesOrLibraries(@Nullable OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(11);
        }
        return symbol != null && OCSearchScopeService.getInstance(project).isInProjectSourcesOrLibraries(symbol);
    }

    @Contract(value="null, _->false")
    public static boolean isInLibraries(@Nullable OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(12);
        }
        return symbol != null && OCSearchScopeService.getInstance(project).isInLibraries(symbol);
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable PsiElement element) {
        return element != null && OCSearchScopeService.getInstance(element.getProject()).isInLibraries(element);
    }

    public static boolean isInLibraries(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            OCSearchScope.$$$reportNull$$$0(13);
        }
        if (project == null) {
            OCSearchScope.$$$reportNull$$$0(14);
        }
        return OCSearchScopeService.getInstance(project).isInLibraries(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoSymbolScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitlySpecifiedProjectSourceFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGotoSymbolScope";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitlySpecifiedProjectSourceFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSources";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectNonSources";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSourcesOrLibraries";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5 -> new IllegalStateException(string);
        };
    }
}

