/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCSearchHelper;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCVisibility {
    HACK_MORE_VISIBLE_THAN_PUBLIC,
    PUBLIC,
    PACKAGE,
    PROTECTED,
    PRIVATE;


    @NlsSafe
    public String toString() {
        if (this == PUBLIC) {
            return "public";
        }
        if (this == PACKAGE) {
            return "package";
        }
        if (this == PROTECTED) {
            return "protected";
        }
        if (this == PRIVATE) {
            return "private";
        }
        return super.toString();
    }

    public static OCVisibility getDefaultObjCVisibility(OCSymbolKind fieldKind) {
        return fieldKind == OCSymbolKind.INSTANCE_VARIABLE ? PROTECTED : PRIVATE;
    }

    @Nullable
    public static OCVisibility getVisibilityFromElement(PsiElement element) {
        IElementType elementType = OCElementUtil.getElementType(element);
        if (elementType == OCElementTypes.OBJC_KEYWORD) {
            elementType = OCElementUtil.getObjCKeywordElementType(element.getNode());
        }
        return OCVisibility.getVisibilityFromElementType(elementType);
    }

    @Nullable
    public static OCVisibility getVisibilityFromElementType(IElementType elementType) {
        if (elementType == OCLexerTokenTypes.PUBLIC_KEYWORD) {
            return PUBLIC;
        }
        if (elementType == OCLexerTokenTypes.PACKAGE_KEYWORD) {
            return PACKAGE;
        }
        if (elementType == OCLexerTokenTypes.PROTECTED_KEYWORD) {
            return PROTECTED;
        }
        if (elementType == OCLexerTokenTypes.PRIVATE_KEYWORD) {
            return PRIVATE;
        }
        return null;
    }

    @Nullable
    public OCElementType getElementType() {
        return switch (this) {
            case PUBLIC -> OCLexerTokenTypes.PUBLIC_KEYWORD;
            case PACKAGE -> OCLexerTokenTypes.PACKAGE_KEYWORD;
            case PROTECTED -> OCLexerTokenTypes.PROTECTED_KEYWORD;
            case PRIVATE -> OCLexerTokenTypes.PRIVATE_KEYWORD;
            default -> null;
        };
    }

    @NotNull
    public static OCVisibility mostVisible(@NotNull OCVisibility x, @NotNull OCVisibility y) {
        if (x == null) {
            OCVisibility.$$$reportNull$$$0(0);
        }
        if (y == null) {
            OCVisibility.$$$reportNull$$$0(1);
        }
        OCVisibility oCVisibility = x.compareTo(y) < 0 ? x : y;
        if (oCVisibility == null) {
            OCVisibility.$$$reportNull$$$0(2);
        }
        return oCVisibility;
    }

    @NotNull
    public static OCVisibility leastVisible(@NotNull OCVisibility x, @NotNull OCVisibility y) {
        if (x == null) {
            OCVisibility.$$$reportNull$$$0(3);
        }
        if (y == null) {
            OCVisibility.$$$reportNull$$$0(4);
        }
        OCVisibility oCVisibility = x.compareTo(y) < 0 ? y : x;
        if (oCVisibility == null) {
            OCVisibility.$$$reportNull$$$0(5);
        }
        return oCVisibility;
    }

    public static boolean isVisible(OCSymbol symbol, PsiElement context, @Nullable OCType qualifierType, @NotNull Project project) {
        if (project == null) {
            OCVisibility.$$$reportNull$$$0(6);
        }
        return OCVisibility.isVisible(symbol, OCVisibility.getMinimalVisibilityForSymbolToBeAccessible(symbol, context, qualifierType), project);
    }

    public static boolean isVisible(OCSymbol symbol, OCVisibility visibility, @NotNull Project project) {
        OCVisibility declaredVisibility;
        if (project == null) {
            OCVisibility.$$$reportNull$$$0(7);
        }
        return (declaredVisibility = OCVisibility.getDeclaredVisibility(symbol, project)) == null || visibility.compareTo(declaredVisibility) >= 0 && !OCVisibility.shouldBeDeclaredInInterface(symbol, visibility);
    }

    public static boolean shouldBeDeclaredInInterface(OCSymbol symbol, OCVisibility visibility) {
        if (visibility.compareTo(PRIVATE) < 0 && symbol instanceof OCMemberSymbol) {
            OCClassSymbol parent = ((OCMemberSymbol)symbol).getParent();
            return parent instanceof OCImplementationSymbol || "".equals(parent.getCategoryName());
        }
        return false;
    }

    @Nullable
    public static OCVisibility getDeclaredVisibility(OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCVisibility.$$$reportNull$$$0(8);
        }
        OCVisibility visibility = null;
        if (symbol instanceof OCInstanceVariableSymbol) {
            visibility = ((OCInstanceVariableSymbol)symbol).getVisibility();
        } else if (symbol instanceof OCMemberSymbol) {
            OCMemberSymbol memberSymbol = (OCMemberSymbol)symbol;
            visibility = PRIVATE;
            if (memberSymbol.getParent() instanceof OCImplementationSymbol) {
                memberSymbol = memberSymbol.getAssociatedSymbol(project);
            }
            if (memberSymbol != null && !"".equals(memberSymbol.getParent().getCategoryName())) {
                visibility = PUBLIC;
            }
        } else if (symbol instanceof OCSymbolWithQualifiedName) {
            visibility = ((OCSymbolWithQualifiedName)symbol).getVisibility();
        }
        return visibility;
    }

    @NotNull
    public static OCVisibility getMinimalVisibilityForSymbolToBeAccessible(@NotNull OCSymbol symbol, @NotNull PsiElement contextElement, @Nullable OCType qualifierType) {
        if (symbol == null) {
            OCVisibility.$$$reportNull$$$0(9);
        }
        if (contextElement == null) {
            OCVisibility.$$$reportNull$$$0(10);
        }
        if (symbol instanceof OCMemberSymbol) {
            if (symbol instanceof OCForeignSymbol) {
                OCVisibility oCVisibility = PRIVATE;
                if (oCVisibility == null) {
                    OCVisibility.$$$reportNull$$$0(11);
                }
                return oCVisibility;
            }
            PsiFile containingFile = symbol.getContainingPsiFile(contextElement.getProject());
            if (containingFile != null) {
                OCVisibility oCVisibility = OCVisibility.getMemberVisibility((OCMemberSymbol)symbol, contextElement);
                if (oCVisibility == null) {
                    OCVisibility.$$$reportNull$$$0(12);
                }
                return oCVisibility;
            }
            OCVisibility oCVisibility = HACK_MORE_VISIBLE_THAN_PUBLIC;
            if (oCVisibility == null) {
                OCVisibility.$$$reportNull$$$0(13);
            }
            return oCVisibility;
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            OCVisibility oCVisibility = OCVisibility.getCppVisibility((OCSymbolWithParent)symbol, contextElement, qualifierType);
            if (oCVisibility == null) {
                OCVisibility.$$$reportNull$$$0(14);
            }
            return oCVisibility;
        }
        OCVisibility oCVisibility = HACK_MORE_VISIBLE_THAN_PUBLIC;
        if (oCVisibility == null) {
            OCVisibility.$$$reportNull$$$0(15);
        }
        return oCVisibility;
    }

    private static OCVisibility getMemberVisibility(@NotNull OCMemberSymbol symbol, @NotNull PsiElement contextElement) {
        OCVisibility visibility;
        if (symbol == null) {
            OCVisibility.$$$reportNull$$$0(16);
        }
        if (contextElement == null) {
            OCVisibility.$$$reportNull$$$0(17);
        }
        if ((visibility = OCVisibility.getDeclaredVisibility(symbol, contextElement.getProject())) == PUBLIC) {
            return visibility;
        }
        if (visibility == PACKAGE) {
            if (OCSearchHelper.areFromSamePackage(contextElement.getProject(), symbol.getContainingFile(), contextElement.getContainingFile().getVirtualFile())) {
                return PACKAGE;
            }
            return PUBLIC;
        }
        OCImplementation clazz = (OCImplementation)PsiTreeUtil.getContextOfType((PsiElement)contextElement, OCImplementation.class, (boolean)false);
        if (clazz == null) {
            return PUBLIC;
        }
        OCResolveContext context = OCResolveContext.forPsi(contextElement);
        OCObjectType type = clazz.getType();
        OCType declInType = symbol.getParent().getType().resolve(context);
        if (type == null || !(declInType instanceof OCObjectType)) {
            return PRIVATE;
        }
        if (declInType.equalsAfterResolving(type, context)) {
            return PRIVATE;
        }
        if (((OCObjectType)declInType).isAncestorOf(type)) {
            return PROTECTED;
        }
        return PUBLIC;
    }

    private static OCVisibility getCppVisibility(OCSymbolWithParent symbol, @NotNull PsiElement contextElement, @Nullable OCType qualifierType) {
        OCSymbol declParent;
        OCSymbol contextScopeSymbol;
        if (contextElement == null) {
            OCVisibility.$$$reportNull$$$0(18);
        }
        OCResolveContext context = OCResolveContext.forPsi(contextElement);
        OCSymbolDeclarator<?> contextScope = OCVisibility.getScope(contextElement);
        OCSymbol oCSymbol = contextScopeSymbol = contextScope != null ? (OCSymbol)contextScope.getSymbol() : null;
        if (contextScopeSymbol == null && contextScope instanceof OCEnum || contextScope instanceof OCStructLike && ((OCStructLike)contextScope).getNameIdentifier() == null) {
            OCSymbol oCSymbol2 = contextScopeSymbol = (contextScope = OCVisibility.getScope(contextScope.getParent())) != null ? (OCSymbol)contextScope.getSymbol() : null;
        }
        if (!((declParent = symbol.getParent()) instanceof OCStructSymbol)) {
            return PRIVATE;
        }
        OCStructSymbol declParentStruct = (OCStructSymbol)declParent;
        if (OCVisibility.isContextFriendOfDeclaration(contextScopeSymbol, declParentStruct, context)) {
            return PRIVATE;
        }
        OCVisibility bestVisibility = HACK_MORE_VISIBLE_THAN_PUBLIC;
        OCSymbolWithQualifiedName parent = contextScopeSymbol instanceof OCFunctionSymbol || contextScopeSymbol instanceof OCDeclaratorSymbol ? ((OCSymbolWithQualifiedName)contextScopeSymbol).getResolvedOwner(context, true) : (contextScopeSymbol instanceof OCStructSymbol ? (OCSymbolWithQualifiedName)contextScopeSymbol : null);
        if (parent instanceof OCStructSymbol) {
            Object usingParent;
            if (symbol instanceof OCSymbolWithQualifiedName && ((OCSymbolWithQualifiedName)symbol).isFromUsing() && (usingParent = ((OCSymbolWithQualifiedName)symbol).getUsingParent()) instanceof OCStructSymbol) {
                declParentStruct = (OCStructSymbol)usingParent;
            }
            bestVisibility = OCVisibility.leastVisible(bestVisibility, OCVisibility.searchCpp((OCStructSymbol)parent, declParentStruct, symbol, PRIVATE, context));
        }
        if (qualifierType instanceof OCStructType) {
            for (OCStructSymbol struct : ((OCStructType)qualifierType).getStructs()) {
                bestVisibility = OCVisibility.leastVisible(bestVisibility, OCVisibility.searchCpp(struct, declParentStruct, symbol, PUBLIC, context));
            }
        } else if (contextElement instanceof OCNamespaceQualifierOwner) {
            OCCppNamespaceQualifier qualifier = ((OCNamespaceQualifierOwner)contextElement).getNamespaceQualifier();
            if (qualifier != null) {
                OCSymbolReference.LocalReference reference = OCSymbolReference.getLocalReference(qualifier, OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
                for (OCSymbol qualifierSymbol : reference.resolveToSymbols(true, false, true, context)) {
                    if (qualifierSymbol instanceof OCStructSymbol) {
                        bestVisibility = OCVisibility.leastVisible(bestVisibility, OCVisibility.searchCpp((OCStructSymbol)qualifierSymbol, declParentStruct, symbol, PUBLIC, context));
                        continue;
                    }
                    bestVisibility = OCVisibility.leastVisible(bestVisibility, PUBLIC);
                }
            } else if (!(parent instanceof OCStructSymbol)) {
                bestVisibility = OCVisibility.leastVisible(bestVisibility, PUBLIC);
            }
        } else if (!(parent instanceof OCStructSymbol)) {
            bestVisibility = OCVisibility.leastVisible(bestVisibility, PUBLIC);
        }
        return bestVisibility;
    }

    private static OCSymbolWithQualifiedName addDefaultSubstitution(OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        if (context == null) {
            OCVisibility.$$$reportNull$$$0(19);
        }
        if (symbol instanceof OCTemplateSymbol) {
            OCTemplateSymbol template = (OCTemplateSymbol)((Object)symbol);
            HashMap<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
            for (OCTypeParameterSymbol paramSymbol : template.getTemplateParameters()) {
                substitutionMap.put(paramSymbol, new OCTypeParameterType(paramSymbol));
            }
            OCSimpleTypeSubstitution substitution = OCSimpleTypeSubstitution.create(substitutionMap);
            symbol = substitution.substitute(symbol, context);
        }
        return symbol;
    }

    private static boolean isContextFriendOfDeclaration(OCSymbol contextScopeSymbol, @NotNull OCStructSymbol declParent, @NotNull OCResolveContext context) {
        if (declParent == null) {
            OCVisibility.$$$reportNull$$$0(20);
        }
        if (context == null) {
            OCVisibility.$$$reportNull$$$0(21);
        }
        MultiMap structContext = new MultiMap();
        MultiMap functionContext = new MultiMap();
        if (contextScopeSymbol instanceof OCSymbolWithQualifiedName) {
            for (OCSymbolWithQualifiedName currentParent = (OCSymbolWithQualifiedName)contextScopeSymbol; currentParent != null; currentParent = currentParent.getResolvedOwner(context)) {
                OCSymbolWithQualifiedName parentSymbol = OCVisibility.addDefaultSubstitution(currentParent, context);
                String parentName = currentParent.getName();
                if (parentSymbol instanceof OCStructSymbol) {
                    structContext.putValue((Object)parentName, (Object)((OCStructSymbol)parentSymbol));
                }
                if (!(parentSymbol instanceof OCFunctionSymbol)) continue;
                functionContext.putValue((Object)parentName, (Object)((OCFunctionSymbol)parentSymbol));
            }
        }
        return !new InnerFriendFinder((MultiMap<String, OCStructSymbol>)structContext, (MultiMap<String, OCFunctionSymbol>)functionContext, context).initialProcess(declParent);
    }

    @SafeVarargs
    private static OCElement getScopeIgnoringPredeclarations(PsiElement contextElement, Class<? extends OCElement> ... classes) {
        if (classes == null) {
            OCVisibility.$$$reportNull$$$0(22);
        }
        OCElement scope = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)contextElement, (boolean)false, (Class[])classes);
        while (scope instanceof OCStructLike && !((OCStructLike)scope).isDeclaration()) {
            scope = (OCElement)PsiTreeUtil.getContextOfType((PsiElement)scope, (boolean)true, (Class[])classes);
        }
        return scope;
    }

    @Nullable
    private static OCSymbolDeclarator<?> getScope(PsiElement contextElement) {
        OCElement scope = OCVisibility.getScopeIgnoringPredeclarations(contextElement, OCDeclarator.class, OCFunctionDefinition.class, OCStructLike.class, OCDeclaration.class);
        if (scope instanceof OCDeclaration && !(scope instanceof OCFunctionDeclaration)) {
            if (!((OCDeclaration)scope).getDeclarators().isEmpty() && ((OCDeclaration)scope).getDeclarators().get(0).getNamespaceQualifier() != null) {
                return ((OCDeclaration)scope).getDeclarators().get(0);
            }
            scope = OCVisibility.getScopeIgnoringPredeclarations(contextElement, OCDeclarator.class, OCFunctionDefinition.class, OCStructLike.class);
        }
        if (scope instanceof OCDeclarator && PsiTreeUtil.getContextOfType((PsiElement)scope, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class}) != null) {
            return OCVisibility.getScope(PsiTreeUtil.getContextOfType((PsiElement)scope, (boolean)false, (Class[])new Class[]{OCFunctionDefinition.class}));
        }
        if (scope instanceof OCDeclarator && ((OCDeclarator)scope).getNamespaceQualifier() == null) {
            return OCVisibility.getScope(scope.getParent());
        }
        return scope instanceof OCSymbolDeclarator ? (OCSymbolDeclarator)((Object)scope) : null;
    }

    @NotNull
    private static OCVisibility searchCpp(OCNamespaceSymbol startSymbol, OCStructSymbol destSymbol, @NotNull OCSymbol symbolToFind, OCVisibility requiredVisibility, @NotNull OCResolveContext context) {
        if (symbolToFind == null) {
            OCVisibility.$$$reportNull$$$0(23);
        }
        if (context == null) {
            OCVisibility.$$$reportNull$$$0(24);
        }
        HashSet<OCNamespaceSymbol> processed = new HashSet<OCNamespaceSymbol>();
        Stack workset2 = new Stack();
        while (startSymbol != null) {
            if (startSymbol.isSameSymbol(destSymbol, context)) {
                OCVisibility oCVisibility = requiredVisibility;
                if (oCVisibility == null) {
                    OCVisibility.$$$reportNull$$$0(25);
                }
                return oCVisibility;
            }
            workset2.push((Object)Pair.create((Object)startSymbol, (Object)((Object)(requiredVisibility == PUBLIC ? PUBLIC : null))));
            OCSymbolWithQualifiedName parent = startSymbol.getResolvedOwner(context);
            startSymbol = parent instanceof OCNamespaceSymbol ? (OCNamespaceSymbol)parent : null;
        }
        requiredVisibility = OCVisibility.mostVisible(requiredVisibility, PROTECTED);
        boolean destSymbolReached = false;
        while (!workset2.isEmpty()) {
            Pair pair = (Pair)workset2.pop();
            OCNamespaceSymbol curClass = (OCNamespaceSymbol)pair.first;
            OCVisibility restriction = (OCVisibility)((Object)pair.second);
            if (curClass.resolvedNamesEqual(context.getProject(), destSymbol)) {
                destSymbolReached = true;
                if (restriction == null || restriction.compareTo(requiredVisibility) <= 0) {
                    OCVisibility oCVisibility = requiredVisibility;
                    if (oCVisibility == null) {
                        OCVisibility.$$$reportNull$$$0(26);
                    }
                    return oCVisibility;
                }
            }
            if (processed.contains(curClass)) continue;
            OCVisibility[] result = new OCVisibility[1];
            curClass.processMembers(symbolToFind.getName(), (Processor<? super OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCUsingSymbol) {
                    for (OCSymbol candidate : context.resolveToSymbols(((OCUsingSymbol)symbol).getSymbolReference())) {
                        if (!candidate.equals(symbolToFind)) continue;
                        result[0] = ((OCUsingSymbol)symbol).getVisibility();
                        return false;
                    }
                }
                return true;
            }));
            if (result[0] != null && result[0].compareTo(requiredVisibility) <= 0) {
                OCVisibility oCVisibility = PRIVATE;
                if (oCVisibility == null) {
                    OCVisibility.$$$reportNull$$$0(27);
                }
                return oCVisibility;
            }
            processed.add(curClass);
            OCSymbolWithQualifiedName parent = curClass.getResolvedOwner(context);
            if (parent instanceof OCStructSymbol) {
                workset2.push((Object)Pair.create((Object)((OCStructSymbol)parent), (Object)((Object)restriction)));
            }
            if (!(curClass instanceof OCStructSymbol)) continue;
            ((OCStructSymbol)curClass).processBaseClasses(context, (symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol) {
                    OCVisibility newRestriction = restriction != null ? OCVisibility.leastVisible(restriction, visibility) : PUBLIC;
                    workset2.push((Object)Pair.create((Object)((OCStructSymbol)symbol), (Object)((Object)newRestriction)));
                }
                return true;
            });
        }
        OCVisibility oCVisibility = destSymbolReached ? HACK_MORE_VISIBLE_THAN_PUBLIC : PUBLIC;
        if (oCVisibility == null) {
            OCVisibility.$$$reportNull$$$0(28);
        }
        return oCVisibility;
    }

    public static OCVisibility getMaxInheritanceVisibility(OCStructSymbol ancestor, OCStructSymbol inheritor, @NotNull OCResolveContext context) {
        if (context == null) {
            OCVisibility.$$$reportNull$$$0(29);
        }
        HashSet<OCStructSymbol> processed = new HashSet<OCStructSymbol>();
        Stack workset2 = new Stack();
        workset2.push((Object)Pair.create((Object)inheritor, (Object)((Object)PUBLIC)));
        OCVisibility result = PRIVATE;
        while (!workset2.isEmpty()) {
            Pair pair = (Pair)workset2.pop();
            OCStructSymbol curClass = (OCStructSymbol)pair.first;
            OCVisibility restriction = (OCVisibility)((Object)pair.second);
            if (curClass.equals(ancestor)) {
                result = OCVisibility.mostVisible(result, restriction);
            }
            if (!processed.add(curClass)) continue;
            curClass.processBaseClasses(context, (symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol) {
                    workset2.push((Object)Pair.create((Object)((OCStructSymbol)symbol), (Object)((Object)OCVisibility.leastVisible(restriction, visibility))));
                }
                return true;
            });
        }
        return result;
    }

    @Nullable
    public static OCVisibility getVisibilityAtOffset(@NotNull PsiElement element, int offset) {
        PsiElement kid;
        if (element == null) {
            OCVisibility.$$$reportNull$$$0(30);
        }
        if (!(element instanceof OCStructLike)) {
            return null;
        }
        OCStructLike elementStruct = (OCStructLike)element;
        for (kid = element.getContainingFile().findElementAt(offset); kid != null && kid.getParent() != element; kid = kid.getParent()) {
        }
        if (kid != null) {
            kid = kid.getPrevSibling();
        }
        while (kid != null) {
            OCVisibility visibility = OCVisibility.getVisibilityFromElement(kid);
            if (visibility != null) {
                return visibility;
            }
            kid = kid.getPrevSibling();
        }
        return elementStruct.getDefaultVisibility();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 11, 12, 13, 14, 15, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "y";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCVisibility";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 10: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 19: 
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declParent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolToFind";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCVisibility";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "mostVisible";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "leastVisible";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinimalVisibilityForSymbolToBeAccessible";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "searchCpp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mostVisible";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "leastVisible";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredVisibility";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMinimalVisibilityForSymbolToBeAccessible";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMemberVisibility";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCppVisibility";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultSubstitution";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isContextFriendOfDeclaration";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getScopeIgnoringPredeclarations";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "searchCpp";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getMaxInheritanceVisibility";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityAtOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 11, 12, 13, 14, 15, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    private static class InnerFriendFinder
    implements Processor<OCSymbol> {
        private final MultiMap<String, OCStructSymbol> myStructContext;
        private final MultiMap<String, OCFunctionSymbol> myFunctionContext;
        @NotNull
        private final OCResolveContext myContext;

        InnerFriendFinder(MultiMap<String, OCStructSymbol> structContext, MultiMap<String, OCFunctionSymbol> functionContext, @NotNull OCResolveContext context) {
            if (context == null) {
                InnerFriendFinder.$$$reportNull$$$0(0);
            }
            this.myStructContext = structContext;
            this.myFunctionContext = functionContext;
            this.myContext = context;
        }

        public boolean process(OCSymbol symbol) {
            block5: {
                OCQualifiedName symbolName;
                block4: {
                    if (!(symbol instanceof OCSymbolWithQualifiedName) || !((OCSymbolWithQualifiedName)symbol).isFriend()) {
                        return true;
                    }
                    symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(this.myContext);
                    if (!(symbol instanceof OCFunctionSymbol)) break block4;
                    Iterator iterator2 = this.myFunctionContext.get((Object)symbol.getName()).iterator();
                    while (iterator2.hasNext()) {
                        OCFunctionSymbol maybeFunction;
                        OCQualifiedName functionName;
                        boolean ok = Comparing.equal((Object)(symbolName == null ? null : symbolName.dropArguments()), (Object)((functionName = (maybeFunction = (OCFunctionSymbol)iterator2.next()).getResolvedQualifiedName(this.myContext)) == null ? null : functionName.dropArguments()));
                        if (!ok || !new OCTypeEqualityVisitor(symbol.getResolvedType(this.myContext), true, true, this.myContext).equal(maybeFunction.getResolvedType(this.myContext))) continue;
                        return false;
                    }
                    break block5;
                }
                if (!(symbol instanceof OCStructSymbol)) break block5;
                for (OCStructSymbol contextStruct : this.myStructContext.get((Object)symbol.getName())) {
                    OCQualifiedName structName = contextStruct.getResolvedQualifiedName(this.myContext);
                    if (symbolName != null && structName != null && !(symbolName instanceof OCQualifiedNameWithArguments)) {
                        structName = structName.dropArguments();
                    }
                    if (!Comparing.equal((Object)symbolName, (Object)structName)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean initialProcess(@NotNull OCStructSymbol declParent) {
            List<OCType> befriendedTypes;
            if (declParent == null) {
                InnerFriendFinder.$$$reportNull$$$0(1);
            }
            if ((befriendedTypes = declParent.getBefriendedTypes()) != null) {
                for (OCType type : befriendedTypes) {
                    OCType resolvedType = type.resolve(OCResolveContext.forSymbol(declParent, this.myContext.getProject()).substitute(declParent.getSubstitution()));
                    if (!(resolvedType instanceof OCStructType)) continue;
                    for (OCSymbolWithQualifiedName contextStruct : this.myStructContext.get((Object)resolvedType.getName())) {
                        if (!Comparing.equal((Object)((OCStructType)resolvedType).getStructs().get(0).getResolvedQualifiedName(this.myContext), (Object)contextStruct.getResolvedQualifiedName(this.myContext))) continue;
                        return false;
                    }
                }
            }
            return declParent.processMembers((String)null, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declParent";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCVisibility$InnerFriendFinder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initialProcess";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

