/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.cidr.cpp.util.CidrStringCodec;
import com.intellij.cidr.cpp.util.CidrStringLiteral;
import com.intellij.cidr.cpp.util.CidrStringLiteralUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.lang.util.OCCharLiteral;
import com.jetbrains.cidr.lang.util.OCStringCodec;
import com.jetbrains.cidr.lang.util.OCStringLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCStringLiteralUtil
extends CidrStringLiteralUtil {
    private static final Logger LOG = Logger.getInstance(OCStringLiteralUtil.class);

    @NotNull
    public static OCStringLiteral concatStrings(OCStringLiteral ... stringLiterals) {
        if (stringLiterals == null) {
            OCStringLiteralUtil.$$$reportNull$$$0(0);
        }
        OCStringLiteral oCStringLiteral = (OCStringLiteral)OCStringLiteralUtil.concatStrings((CidrStringCodec)OCStringCodec.STRING_CODEC, (CidrStringLiteral[])stringLiterals);
        if (oCStringLiteral == null) {
            OCStringLiteralUtil.$$$reportNull$$$0(1);
        }
        return oCStringLiteral;
    }

    @NotNull
    public static OCStringLiteral parseStringLiteral(@Nullable String literalText) {
        OCStringLiteral oCStringLiteral = (OCStringLiteral)OCStringLiteralUtil.parseStringLiteral((CidrStringCodec)OCStringCodec.STRING_CODEC, (String)literalText);
        if (oCStringLiteral == null) {
            OCStringLiteralUtil.$$$reportNull$$$0(2);
        }
        return oCStringLiteral;
    }

    @NotNull
    public static OCCharLiteral parseCharLiteral(@Nullable String literalText) {
        String contents;
        if (literalText == null) {
            OCCharLiteral oCCharLiteral = OCCharLiteral.BAD_LITERAL;
            if (oCCharLiteral == null) {
                OCStringLiteralUtil.$$$reportNull$$$0(3);
            }
            return oCCharLiteral;
        }
        int length = literalText.length();
        if (length == 0) {
            OCCharLiteral oCCharLiteral = OCCharLiteral.BAD_LITERAL;
            if (oCCharLiteral == null) {
                OCStringLiteralUtil.$$$reportNull$$$0(4);
            }
            return oCCharLiteral;
        }
        int quoteChar = 39;
        int firstQuotePos = literalText.indexOf(39);
        if (firstQuotePos == -1) {
            LOG.warn("String literal without quote (lexer problem?)");
            OCCharLiteral oCCharLiteral = OCCharLiteral.BAD_LITERAL;
            if (oCCharLiteral == null) {
                OCStringLiteralUtil.$$$reportNull$$$0(5);
            }
            return oCCharLiteral;
        }
        String prefixString = literalText.substring(0, firstQuotePos);
        CidrStringLiteralUtil.CidrCharType charType = (CidrStringLiteralUtil.CidrCharType)CHAR_PREFIX_TYPE.get(prefixString);
        if (charType == null) {
            OCCharLiteral oCCharLiteral = OCCharLiteral.BAD_LITERAL;
            if (oCCharLiteral == null) {
                OCStringLiteralUtil.$$$reportNull$$$0(6);
            }
            return oCCharLiteral;
        }
        if (firstQuotePos == length - 1) {
            contents = "";
        } else {
            contents = literalText.substring(firstQuotePos + 1);
            if (literalText.charAt(length - 1) == '\'') {
                contents = contents.substring(0, contents.length() - 1);
            }
        }
        if (prefixString.isEmpty() && contents.length() > 1) {
            charType = CidrStringLiteralUtil.CidrCharType.MULTICHAR_LITERAL;
        }
        return new OCCharLiteral(charType, prefixString, contents);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiterals";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCStringLiteralUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCStringLiteralUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "concatStrings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseStringLiteral";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCharLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "concatStrings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

