/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.lang.qml.workspace;

import com.intellij.ide.DataManager;
import com.intellij.lang.qml.QmlBundle;
import com.intellij.lang.qml.QmlFileType;
import com.intellij.lang.qml.settings.QmlSettings;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.qt.common.settings.QtSettings;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.awt.Component;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QmlNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    private static void executeAction(@NonNls String actionId, @NotNull JComponent component) {
        if (component == null) {
            QmlNotificationProvider.$$$reportNull$$$0(0);
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"unknown", (DataContext)dataContext);
        ActionUtil.performAction((AnAction)action, (AnActionEvent)event);
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            QmlNotificationProvider.$$$reportNull$$$0(1);
        }
        if (file == null) {
            QmlNotificationProvider.$$$reportNull$$$0(2);
        }
        return (Function)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
            VirtualFile contentRoot = rootManager.getFileIndex().getContentRootForFile(file);
            if (contentRoot == null) {
                return null;
            }
            if (contentRoot.equals(file) && rootManager.getContentRoots().length == 1) {
                return null;
            }
            if (!file.getFileType().equals(QmlFileType.INSTANCE)) {
                return null;
            }
            QtSettings qtSettings = QtSettings.getInstance((Project)project);
            @NotNull String qmlPath = qtSettings.getResultingQmlDir();
            if (qmlPath.isEmpty() || !FileUtil.exists((String)qmlPath)) {
                return fileEditor -> {
                    EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
                    panel.setText(QmlBundle.message("qml.not.autodetected.message", new Object[0]));
                    panel.createActionLabel(QmlBundle.message("qml.open.settings.message", new Object[0]), "QmlLang.OpenSettings");
                    panel.createActionLabel(QmlBundle.message("cmake.prefix.path.settings.message", new Object[0]), "CMake.OpenSettings");
                    return panel;
                };
            }
            if (!qtSettings.getQmlPath(qtSettings.getCurrentProfile()).isEmpty() && Registry.is((String)"com.intellij.clion.lang.qml.cmake.reload.notification")) {
                QmlSettings settings = QmlSettings.getInstance(project);
                if (settings.getAutomocJson(qtSettings.getCurrentProfile())) {
                    return null;
                }
                Optional firstProfile = CMakeWorkspace.getInstance((Project)project).getProfileInfos().stream().findFirst();
                if (firstProfile.isPresent()) {
                    File genDir = ((CMakeProfileInfo)firstProfile.get()).getGenerationDir();
                    try {
                        CMakeCacheFile cacheFile = new CMakeCacheFile(new File(FileUtil.join((String[])new String[]{genDir.getAbsolutePath(), "CMakeCache.txt"})), StandardCharsets.UTF_8.name());
                        @Nullable CMakeVariable automocOpts = cacheFile.getVariable("CMAKE_AUTOMOC_MOC_OPTIONS");
                        if (automocOpts != null) {
                            return null;
                        }
                    }
                    catch (CMakeException e) {
                        return null;
                    }
                    return fileEditor -> {
                        EditorNotificationPanel panel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Info);
                        panel.setText(QmlBundle.message("qml.require.cmake.reload.message", new Object[0]));
                        panel.createActionLabel(QmlBundle.message("qml.cmake.reload.message", new Object[0]), () -> {
                            settings.setAutomocJson(qtSettings.getCurrentProfile(), true);
                            panel.setVisible(false);
                            QmlNotificationProvider.executeAction("CMake.ReloadCMakeProject", (JComponent)panel);
                        });
                        panel.createActionLabel(QmlBundle.message("qml.cmake.reload.hide.message", new Object[0]), () -> panel.setVisible(false));
                        return panel;
                    };
                }
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/clion/lang/qml/workspace/QmlNotificationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNotificationData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

