/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe.columns;

import com.intellij.charts.dataframe.columns.Type;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006J\u0018\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\u000eH\u0086\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000eH&J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000eH&J \u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\u001fj\b\u0012\u0004\u0012\u00020\u000e` 2\u0006\u0010!\u001a\u00020\u0016H&J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001a\u001a\u00020\u000eH&\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0000\"\u0004\b\u0001\u0010\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0017R\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/intellij/charts/dataframe/columns/Column;", "T", "", "name", "", "data", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getData", "()Ljava/util/List;", "size", "", "getSize", "()I", "type", "Lcom/intellij/charts/dataframe/columns/Type;", "getType", "()Lcom/intellij/charts/dataframe/columns/Type;", "isNumerical", "", "()Z", "toList", "get", "index", "(I)Ljava/lang/Object;", "isNotNull", "isNull", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "descendant", "getDouble", "", "(I)Ljava/lang/Double;", "cast", "range", "Lkotlin/ranges/ClosedRange;", "getRange", "()Lkotlin/ranges/ClosedRange;", "intellij.charts"})
public abstract class Column<T>
implements Iterable<T>,
KMappedMarker {
    @NotNull
    private final String name;
    @NotNull
    private final List<T> data;
    private final int size;
    private final boolean isNumerical;

    public Column(@NotNull String name, @NotNull List<? extends T> data2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        this.name = name;
        this.data = data2;
        this.size = this.data.size();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    protected final List<T> getData() {
        return this.data;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public abstract Type<T> getType();

    public boolean isNumerical() {
        return this.isNumerical;
    }

    @NotNull
    public final List<T> toList() {
        return this.data;
    }

    @Nullable
    public final T get(int index) {
        return this.data.get(index);
    }

    public abstract boolean isNotNull(int var1);

    public abstract boolean isNull(int var1);

    @NotNull
    public abstract Comparator<Integer> getComparator(boolean var1);

    @Nullable
    public abstract Double getDouble(int var1);

    @NotNull
    public final <T> Column<T> cast() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.charts.dataframe.columns.Column<T of com.intellij.charts.dataframe.columns.Column.cast>");
        return this;
    }

    @NotNull
    public abstract ClosedRange<Double> getRange();

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

