/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.commons.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.commons.color.ColorPalette;
import org.jetbrains.letsPlot.core.commons.color.ColorScheme;
import org.jetbrains.letsPlot.core.commons.color.ColorUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\fJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/core/commons/color/PaletteUtil;", "", "()V", "EXTENSIBLE_COLOR_SCHEMES", "", "Lorg/jetbrains/letsPlot/core/commons/color/ColorScheme;", "NULL_COLOR", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getNULL_COLOR", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "PAL_TYPE_BY_PAL_NAME", "", "", "Lorg/jetbrains/letsPlot/core/commons/color/ColorPalette$Type;", "colorSchemeByIndex", "paletteType", "index", "", "fromColorsHex", "", "hexColors", "", "([Ljava/lang/String;)Ljava/util/List;", "isExtensibleScheme", "", "colorScheme", "paletteTypeByPaletteName", "paletteName", "schemeColors", "colorCount", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPaletteUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaletteUtil.kt\norg/jetbrains/letsPlot/core/commons/color/PaletteUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n11065#2:82\n11400#2,3:83\n11065#2:88\n11400#2,3:89\n11065#2:94\n11400#2,3:95\n1855#3,2:86\n1855#3,2:92\n1855#3,2:98\n*S KotlinDebug\n*F\n+ 1 PaletteUtil.kt\norg/jetbrains/letsPlot/core/commons/color/PaletteUtil\n*L\n27#1:82\n27#1:83,3\n30#1:88\n30#1:89,3\n33#1:94\n33#1:95,3\n27#1:86,2\n30#1:92,2\n33#1:98,2\n*E\n"})
public final class PaletteUtil {
    @NotNull
    public static final PaletteUtil INSTANCE;
    @NotNull
    private static final Color NULL_COLOR;
    @NotNull
    private static final Set<ColorScheme> EXTENSIBLE_COLOR_SCHEMES;
    @NotNull
    private static final Map<String, ColorPalette.Type> PAL_TYPE_BY_PAL_NAME;

    private PaletteUtil() {
    }

    @NotNull
    public final Color getNULL_COLOR() {
        return NULL_COLOR;
    }

    private final boolean isExtensibleScheme(ColorScheme colorScheme) {
        return EXTENSIBLE_COLOR_SCHEMES.contains(colorScheme);
    }

    @NotNull
    public final List<Color> schemeColors(@NotNull ColorScheme colorScheme, int colorCount) {
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        String[] colorsHex = colorScheme.getColors(colorCount);
        List<Color> colors = this.fromColorsHex(colorsHex);
        if (colorsHex.length < colorCount && this.isExtensibleScheme(colorScheme)) {
            List<Color> addColors = ColorUtil.INSTANCE.genColors(colorCount - colorsHex.length, colors);
            return CollectionsKt.plus((Collection)colors, (Iterable)addColors);
        }
        return colors;
    }

    private final List<Color> fromColorsHex(String[] hexColors) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String hexColor : hexColors) {
            try {
                colors.add(Color.Companion.parseHex(hexColor));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return colors;
    }

    @Nullable
    public final ColorPalette.Type paletteTypeByPaletteName(@NotNull String paletteName) {
        Intrinsics.checkNotNullParameter((Object)paletteName, (String)"paletteName");
        return PAL_TYPE_BY_PAL_NAME.get(paletteName);
    }

    @NotNull
    public final ColorScheme colorSchemeByIndex(@NotNull ColorPalette.Type paletteType, int index) {
        ColorScheme[] colorSchemeArray;
        Intrinsics.checkNotNullParameter((Object)((Object)paletteType), (String)"paletteType");
        switch (WhenMappings.$EnumSwitchMapping$0[paletteType.ordinal()]) {
            case 1: {
                colorSchemeArray = ColorPalette.Sequential.values();
                break;
            }
            case 2: {
                colorSchemeArray = ColorPalette.Diverging.values();
                break;
            }
            case 3: {
                colorSchemeArray = ColorPalette.Qualitative.values();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ColorScheme[] values2 = colorSchemeArray;
        return values2[index % values2.length];
    }

    static {
        int n;
        int n2;
        Object it;
        Collection collection;
        Object item$iv$iv2;
        Object $this$mapTo$iv$iv;
        INSTANCE = new PaletteUtil();
        NULL_COLOR = Color.Companion.getLIGHT_GRAY();
        Object[] objectArray = new ColorPalette.Qualitative[]{ColorPalette.Qualitative.Accent, ColorPalette.Qualitative.Dark2, ColorPalette.Qualitative.Pastel1, ColorPalette.Qualitative.Pastel2, ColorPalette.Qualitative.Set1, ColorPalette.Qualitative.Set2, ColorPalette.Qualitative.Set3};
        EXTENSIBLE_COLOR_SCHEMES = SetsKt.setOf((Object[])objectArray);
        HashMap map2 = new HashMap();
        Enum[] $this$map$iv = ColorPalette.Sequential.values();
        boolean $i$f$map = false;
        Enum[] enumArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void var9_12 = item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Enum)it).name());
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            n2 = 0;
            ((Map)map2).put(it2, ColorPalette.Type.SEQUENTIAL);
        }
        $this$map$iv = ColorPalette.Diverging.values();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        int n3 = ((Enum[])$this$mapTo$iv$iv).length;
        for (n2 = 0; n2 < n3; ++n2) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n2];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Enum)it).name());
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it3 = (String)element$iv;
            n = 0;
            ((Map)map2).put(it3, ColorPalette.Type.DIVERGING);
        }
        $this$map$iv = ColorPalette.Qualitative.values();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        n3 = ((Object)$this$mapTo$iv$iv).length;
        for (n = 0; n < n3; ++n) {
            it = item$iv$iv2 = $this$mapTo$iv$iv[n];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Enum)it).name());
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it4 = (String)element$iv;
            boolean bl = false;
            ((Map)map2).put(it4, ColorPalette.Type.QUALITATIVE);
        }
        PAL_TYPE_BY_PAL_NAME = map2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorPalette.Type.values().length];
            try {
                nArray[ColorPalette.Type.SEQUENTIAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorPalette.Type.DIVERGING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorPalette.Type.QUALITATIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

