/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataSourceManager<T extends RawDataSource> {
    public static final ProjectExtensionPointName<DataSourceManager<?>> EP_NAME = new ProjectExtensionPointName("com.intellij.database.dataSourceManager");
    public static final Topic<Listener> TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.TO_CHILDREN, true);

    @NotNull
    public static List<DataSourceManager<?>> getManagers(@NotNull Project project) {
        if (project == null) {
            DataSourceManager.$$$reportNull$$$0(0);
        }
        List list = EP_NAME.getExtensions((AreaInstance)project);
        if (list == null) {
            DataSourceManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public static <T extends RawDataSource> DataSourceManager<T> byDataSource(@NotNull Project project, @NotNull Class<? extends T> clazz) {
        if (project == null) {
            DataSourceManager.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            DataSourceManager.$$$reportNull$$$0(3);
        }
        return DataSourceManager.byDataSourceImpl(project, clazz);
    }

    @Nullable
    public static <T extends RawDataSource> DataSourceManager<T> byDataSource(@NotNull Project project, @NotNull T dataSource) {
        if (project == null) {
            DataSourceManager.$$$reportNull$$$0(4);
        }
        if (dataSource == null) {
            DataSourceManager.$$$reportNull$$$0(5);
        }
        return DataSourceManager.byDataSourceImpl(project, dataSource.getClass());
    }

    @Nullable
    private static <T extends RawDataSource> DataSourceManager<T> byDataSourceImpl(@NotNull Project project, @NotNull Class<? extends RawDataSource> clazz) {
        ExtensionPoint ep;
        if (project == null) {
            DataSourceManager.$$$reportNull$$$0(6);
        }
        if (clazz == null) {
            DataSourceManager.$$$reportNull$$$0(7);
        }
        return (ep = project.getExtensionArea().getExtensionPointIfRegistered(EP_NAME.getName())) == null ? null : (DataSourceManager)ContainerUtil.find((Iterable)ep.getExtensionList(), m -> m.isMyDataSource(clazz));
    }

    @NotNull
    public abstract List<T> getDataSources();

    public abstract boolean containsDataSource(@NotNull T var1);

    public abstract void addDataSource(@NotNull T var1);

    public abstract void removeDataSource(@NotNull T var1);

    public abstract boolean isLoading(@NotNull T var1);

    @Nullable
    public abstract AnAction getCreateDataSourceAction(@NotNull Consumer<? super T> var1);

    @NotNull
    public abstract T createEmpty();

    @NotNull
    public abstract T copyDataSource(@NotNull String var1, @NotNull T var2);

    public abstract void renameDataSource(@NotNull T var1, @NotNull String var2);

    public abstract void setGroupName(@NotNull T var1, @Nullable String var2);

    public abstract boolean isMyDataSource(@NotNull Class<? extends DasDataSource> var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/DataSourceManager";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/DataSourceManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManagers";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "byDataSource";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "byDataSourceImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface Listener
    extends EventListener {
        default public <T extends RawDataSource> void dataSourceAdded(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            if (manager == null) {
                Listener.$$$reportNull$$$0(0);
            }
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public <T extends RawDataSource> void dataSourceRemoved(@NotNull DataSourceManager<T> manager, @NotNull T dataSource) {
            if (manager == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        default public <T extends RawDataSource> void dataSourceChanged(@Nullable DataSourceManager<T> manager, @Nullable T dataSource) {
        }

        default public <T extends RawDataSource> void dataSourceGroupChanged(@NotNull T dataSource, @Nullable String oldGroupName, @Nullable String newGroupName) {
            if (dataSource == null) {
                Listener.$$$reportNull$$$0(4);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/psi/DataSourceManager$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceAdded";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dataSourceGroupChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

